/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.AdjustableCapacityBlockingQueue;
import org.elasticsearch.xpack.inference.common.RateLimiter;
import org.elasticsearch.xpack.inference.external.http.RequestExecutor;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.RejectableTask;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.RequestTask;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class RequestExecutorService
implements RequestExecutor {
    static final AdjustableCapacityBlockingQueue.QueueCreator<RejectableTask> DEFAULT_QUEUE_CREATOR = new AdjustableCapacityBlockingQueue.QueueCreator<RejectableTask>(){

        @Override
        public BlockingQueue<RejectableTask> create(int capacity) {
            BlockingQueue<RejectableTask> queue = capacity <= 0 ? this.create() : new LinkedBlockingQueue<RejectableTask>(capacity);
            return queue;
        }

        @Override
        public BlockingQueue<RejectableTask> create() {
            return new LinkedBlockingQueue<RejectableTask>();
        }
    };
    static final RateLimiterCreator DEFAULT_RATE_LIMIT_CREATOR = RateLimiter::new;
    private static final Logger logger = LogManager.getLogger(RequestExecutorService.class);
    private static final TimeValue RATE_LIMIT_GROUP_CLEANUP_INTERVAL = TimeValue.timeValueDays((long)1L);
    private final ConcurrentMap<Object, RateLimitingEndpointHandler> rateLimitGroupings = new ConcurrentHashMap<Object, RateLimitingEndpointHandler>();
    private final AtomicInteger rateLimitDivisor = new AtomicInteger(1);
    private final ThreadPool threadPool;
    private final CountDownLatch startupLatch;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final RequestSender requestSender;
    private final RequestExecutorServiceSettings settings;
    private final Clock clock;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AdjustableCapacityBlockingQueue.QueueCreator<RejectableTask> queueCreator;
    private final RateLimiterCreator rateLimiterCreator;
    private final AtomicReference<Scheduler.Cancellable> cancellableCleanupTask = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AdjustableCapacityBlockingQueue<RejectableTask> requestQueue;
    private volatile Future<?> requestQueueTask;
    private static final RejectableTask NOOP_TASK = new RejectableTask(){

        @Override
        public void onRejection(Exception e) {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }

        @Override
        public RequestManager getRequestManager() {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }

        @Override
        public InferenceInputs getInferenceInputs() {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }

        @Override
        public ActionListener<InferenceServiceResults> getListener() {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }

        @Override
        public boolean hasCompleted() {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }

        @Override
        public Supplier<Boolean> getRequestCompletedFunction() {
            throw new UnsupportedOperationException("NoopTask is a pure marker class for signals in the request queue");
        }
    };

    public RequestExecutorService(ThreadPool threadPool, @Nullable CountDownLatch startupLatch, RequestExecutorServiceSettings settings, RequestSender requestSender) {
        this(threadPool, DEFAULT_QUEUE_CREATOR, startupLatch, settings, requestSender, Clock.systemUTC(), DEFAULT_RATE_LIMIT_CREATOR);
    }

    public RequestExecutorService(ThreadPool threadPool, AdjustableCapacityBlockingQueue.QueueCreator<RejectableTask> queueCreator, @Nullable CountDownLatch startupLatch, RequestExecutorServiceSettings settings, RequestSender requestSender, Clock clock, RateLimiterCreator rateLimiterCreator) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.queueCreator = Objects.requireNonNull(queueCreator);
        this.startupLatch = startupLatch;
        this.requestSender = Objects.requireNonNull(requestSender);
        this.settings = Objects.requireNonNull(settings);
        this.clock = Objects.requireNonNull(clock);
        this.rateLimiterCreator = Objects.requireNonNull(rateLimiterCreator);
        this.requestQueue = new AdjustableCapacityBlockingQueue<RejectableTask>(queueCreator, settings.getQueueCapacity());
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.requestQueueTask != null) {
                this.requestQueue.offer(NOOP_TASK);
            }
            if (this.cancellableCleanupTask.get() != null) {
                logger.debug(() -> "Stopping clean up thread");
                this.cancellableCleanupTask.get().cancel();
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    @Override
    public boolean isTerminated() {
        return this.terminationLatch.getCount() == 0L;
    }

    public int queueSize() {
        return this.requestQueue.size() + this.rateLimitGroupings.values().stream().mapToInt(RateLimitingEndpointHandler::queueSize).sum();
    }

    @Override
    public void start() {
        try {
            assert (!this.started.get()) : "start() can only be called once";
            this.started.set(true);
            this.startCleanupTask();
            this.startRequestQueueTask();
            this.signalStartInitiated();
            this.startHandlingRateLimitedTasks();
        }
        catch (Exception e) {
            logger.warn("Failed to start request executor", (Throwable)e);
            this.cleanup(CleanupStrategy.RATE_LIMITED_REQUEST_QUEUES_ONLY);
        }
    }

    private void signalStartInitiated() {
        if (this.startupLatch != null) {
            this.startupLatch.countDown();
        }
    }

    private void startCleanupTask() {
        assert (this.cancellableCleanupTask.get() == null) : "The clean up task can only be set once";
        this.cancellableCleanupTask.set(this.startCleanupThread(RATE_LIMIT_GROUP_CLEANUP_INTERVAL));
    }

    private void startRequestQueueTask() {
        assert (this.requestQueueTask == null) : "The request queue can only be started once";
        this.requestQueueTask = this.threadPool.executor("inference_utility").submit(this::processRequestQueue);
    }

    private Scheduler.Cancellable startCleanupThread(TimeValue interval) {
        logger.debug(() -> Strings.format((String)"Clean up task scheduled with interval [%s]", (Object[])new Object[]{interval}));
        return this.threadPool.scheduleWithFixedDelay(this::removeStaleGroupings, interval, (Executor)this.threadPool.executor("inference_utility"));
    }

    void removeStaleGroupings() {
        Instant now = Instant.now(this.clock);
        Iterator iter = this.rateLimitGroupings.values().iterator();
        while (iter.hasNext()) {
            RateLimitingEndpointHandler endpoint = (RateLimitingEndpointHandler)iter.next();
            if (!now.isAfter(endpoint.timeOfLastEnqueue().plus(this.settings.getRateLimitGroupStaleDuration()))) continue;
            endpoint.close();
            iter.remove();
        }
    }

    private void scheduleNextHandleTasks(TimeValue timeToWait) {
        if (this.shutdown.get()) {
            logger.debug("Shutdown requested while scheduling next handle task call, cleaning up");
            this.cleanup(CleanupStrategy.RATE_LIMITED_REQUEST_QUEUES_ONLY);
            return;
        }
        this.threadPool.schedule(this::startHandlingRateLimitedTasks, timeToWait, (Executor)this.threadPool.executor("inference_utility"));
    }

    private void processRequestQueue() {
        try {
            while (!this.isShutdown()) {
                RejectableTask task = this.requestQueue.take();
                if (task == NOOP_TASK) {
                    if (!this.isShutdown()) continue;
                    logger.debug("Shutdown requested, exiting request queue processing");
                    break;
                }
                if (this.isShutdown()) {
                    logger.debug("Shutdown requested while handling request tasks, cleaning up");
                    this.rejectNonRateLimitedRequest(task);
                    break;
                }
                this.executeTaskImmediately(task);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("Inference request queue interrupted, exiting");
        }
        catch (Exception e) {
            logger.error("Unexpected error processing request queue, terminating", (Throwable)e);
        }
        finally {
            this.cleanup(CleanupStrategy.REQUEST_QUEUE_ONLY);
        }
    }

    private void executeTaskImmediately(RejectableTask task) {
        try {
            task.getRequestManager().execute(task.getInferenceInputs(), this.requestSender, task.getRequestCompletedFunction(), task.getListener());
        }
        catch (Exception e) {
            logger.warn(Strings.format((String)"Failed to execute fast-path request for inference id [%s]", (Object[])new Object[]{task.getRequestManager().inferenceEntityId()}), (Throwable)e);
            task.onRejection((Exception)((Object)new EsRejectedExecutionException(Strings.format((String)"Failed to execute request for inference id [%s]", (Object[])new Object[]{task.getRequestManager().inferenceEntityId()}), false)));
        }
    }

    void submitTaskToRateLimitedExecutionPath(RequestTask task) {
        RequestManager requestManager = task.getRequestManager();
        RateLimitingEndpointHandler endpoint = this.rateLimitGroupings.computeIfAbsent(requestManager.rateLimitGrouping(), key -> {
            RateLimitingEndpointHandler endpointHandler = new RateLimitingEndpointHandler(Integer.toString(requestManager.rateLimitGrouping().hashCode()), this.queueCreator, this.settings, this.requestSender, this.clock, requestManager.rateLimitSettings(), this::isShutdown, this.rateLimiterCreator, this.rateLimitDivisor.get());
            endpointHandler.init();
            return endpointHandler;
        });
        endpoint.enqueue(task);
    }

    private static boolean isEmbeddingsIngestInput(InferenceInputs inputs) {
        EmbeddingsInput embeddingsInput;
        return inputs instanceof EmbeddingsInput && InputType.isIngest((InputType)(embeddingsInput = (EmbeddingsInput)inputs).getInputType());
    }

    private static boolean rateLimitingEnabled(RateLimitSettings rateLimitSettings) {
        return rateLimitSettings != null && rateLimitSettings.isEnabled();
    }

    private void cleanup(CleanupStrategy cleanupStrategy) {
        try {
            this.shutdown();
            switch (cleanupStrategy.ordinal()) {
                case 1: {
                    this.notifyRateLimitedRequestsOfShutdown();
                    break;
                }
                case 0: {
                    this.rejectRequestsInRequestQueue();
                    break;
                }
                default: {
                    logger.error(Strings.format((String)"Unknown clean up strategy for request executor: [%s]", (Object[])new Object[]{cleanupStrategy.toString()}));
                }
            }
            this.terminationLatch.countDown();
        }
        catch (Exception e) {
            logger.warn("Encountered an error while cleaning up", (Throwable)e);
        }
    }

    private void startHandlingRateLimitedTasks() {
        try {
            TimeValue timeToWait;
            do {
                if (this.isShutdown()) {
                    logger.debug("Shutdown requested while handling rate limited tasks, cleaning up");
                    this.cleanup(CleanupStrategy.RATE_LIMITED_REQUEST_QUEUES_ONLY);
                    return;
                }
                timeToWait = this.settings.getTaskPollFrequency();
                for (RateLimitingEndpointHandler endpoint : this.rateLimitGroupings.values()) {
                    timeToWait = TimeValue.min((TimeValue)endpoint.executeEnqueuedTask(), (TimeValue)timeToWait);
                }
            } while (timeToWait.compareTo(TimeValue.ZERO) <= 0);
            this.scheduleNextHandleTasks(timeToWait);
        }
        catch (Exception e) {
            logger.warn("Encountered an error while handling rate limited tasks", (Throwable)e);
            this.cleanup(CleanupStrategy.RATE_LIMITED_REQUEST_QUEUES_ONLY);
        }
    }

    private void notifyRateLimitedRequestsOfShutdown() {
        assert (this.isShutdown()) : "Requests should only be notified if the executor is shutting down";
        for (RateLimitingEndpointHandler endpoint : this.rateLimitGroupings.values()) {
            endpoint.notifyRequestsOfShutdown();
        }
    }

    private void rejectRequestsInRequestQueue() {
        assert (this.isShutdown()) : "Requests in request queue should only be notified if the executor is shutting down";
        ArrayList requests = new ArrayList();
        this.requestQueue.drainTo(requests);
        for (RejectableTask request : requests) {
            if (request == NOOP_TASK) continue;
            this.rejectNonRateLimitedRequest(request);
        }
    }

    private void rejectNonRateLimitedRequest(RejectableTask task) {
        String inferenceEntityId = task.getRequestManager().inferenceEntityId();
        RequestExecutorService.rejectRequest(task, Strings.format((String)"Failed to send request for inference id [%s] because the request executor service has been shutdown", (Object[])new Object[]{inferenceEntityId}), Strings.format((String)"Failed to notify request for inference id [%s] of rejection after executor service shutdown", (Object[])new Object[]{inferenceEntityId}));
    }

    private static void rejectRequest(RejectableTask task, String rejectionMessage, String rejectionFailedMessage) {
        try {
            task.onRejection((Exception)((Object)new EsRejectedExecutionException(rejectionMessage, true)));
        }
        catch (Exception e) {
            logger.warn(rejectionFailedMessage);
        }
    }

    Integer remainingQueueCapacity(RequestManager requestManager) {
        RateLimitingEndpointHandler endpoint = (RateLimitingEndpointHandler)this.rateLimitGroupings.get(requestManager.rateLimitGrouping());
        if (endpoint == null) {
            return null;
        }
        return endpoint.remainingCapacity();
    }

    int numberOfRateLimitGroups() {
        return this.rateLimitGroupings.size();
    }

    @Override
    public void execute(RequestManager requestManager, InferenceInputs inferenceInputs, @Nullable TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        RequestTask task = new RequestTask(requestManager, inferenceInputs, timeout, this.threadPool, (ActionListener<InferenceServiceResults>)ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadPool.getThreadContext()));
        if (this.isShutdown()) {
            task.onRejection((Exception)((Object)new EsRejectedExecutionException(Strings.format((String)"Failed to enqueue request task for inference id [%s] because the request executor service has been shutdown", (Object[])new Object[]{requestManager.inferenceEntityId()}), true)));
            return;
        }
        if (RequestExecutorService.isEmbeddingsIngestInput(inferenceInputs) || RequestExecutorService.rateLimitingEnabled(requestManager.rateLimitSettings())) {
            this.submitTaskToRateLimitedExecutionPath(task);
        } else {
            boolean taskAccepted = this.requestQueue.offer(task);
            if (!taskAccepted) {
                task.onRejection((Exception)((Object)new EsRejectedExecutionException(Strings.format((String)"Failed to enqueue request task for inference id [%s]", (Object[])new Object[]{requestManager.inferenceEntityId()}), false)));
            }
        }
    }

    static interface RateLimiterCreator {
        public RateLimiter create(double var1, double var3, TimeUnit var5);
    }

    private static enum CleanupStrategy {
        REQUEST_QUEUE_ONLY,
        RATE_LIMITED_REQUEST_QUEUES_ONLY;

    }

    static class RateLimitingEndpointHandler {
        private static final TimeValue NO_TASKS_AVAILABLE = TimeValue.MAX_VALUE;
        private static final TimeValue EXECUTED_A_TASK = TimeValue.ZERO;
        private static final Logger logger = LogManager.getLogger(RateLimitingEndpointHandler.class);
        private static final int ACCUMULATED_TOKENS_LIMIT = 1;
        private final AdjustableCapacityBlockingQueue<RejectableTask> queue;
        private final Supplier<Boolean> isShutdownMethod;
        private final RequestSender requestSender;
        private final String rateLimitGroupingId;
        private final AtomicReference<Instant> timeOfLastEnqueue = new AtomicReference();
        private final Clock clock;
        private final RateLimiter rateLimiter;
        private final RequestExecutorServiceSettings requestExecutorServiceSettings;
        private final RateLimitSettings rateLimitSettings;
        private final Long originalRequestsPerTimeUnit;

        RateLimitingEndpointHandler(String rateLimitGroupingId, AdjustableCapacityBlockingQueue.QueueCreator<RejectableTask> createQueue, RequestExecutorServiceSettings settings, RequestSender requestSender, Clock clock, RateLimitSettings rateLimitSettings, Supplier<Boolean> isShutdownMethod, RateLimiterCreator rateLimiterCreator, Integer rateLimitDivisor) {
            this.requestExecutorServiceSettings = Objects.requireNonNull(settings);
            this.rateLimitGroupingId = Objects.requireNonNull(rateLimitGroupingId);
            this.queue = new AdjustableCapacityBlockingQueue<RejectableTask>(createQueue, settings.getQueueCapacity());
            this.requestSender = Objects.requireNonNull(requestSender);
            this.clock = Objects.requireNonNull(clock);
            this.isShutdownMethod = Objects.requireNonNull(isShutdownMethod);
            this.rateLimitSettings = Objects.requireNonNull(rateLimitSettings);
            this.originalRequestsPerTimeUnit = rateLimitSettings.requestsPerTimeUnit();
            Objects.requireNonNull(rateLimitSettings);
            Objects.requireNonNull(rateLimiterCreator);
            this.rateLimiter = rateLimiterCreator.create(1.0, rateLimitSettings.requestsPerTimeUnit(), rateLimitSettings.timeUnit());
        }

        public void init() {
            this.requestExecutorServiceSettings.registerQueueCapacityCallback(this.rateLimitGroupingId, this::onCapacityChange);
        }

        private void onCapacityChange(int capacity) {
            logger.debug(() -> Strings.format((String)"Executor service grouping [%s] setting queue capacity to [%s]", (Object[])new Object[]{this.rateLimitGroupingId, capacity}));
            try {
                this.queue.setCapacity(capacity);
            }
            catch (Exception e) {
                logger.warn(Strings.format((String)"Executor service grouping [%s] failed to set the capacity of the task queue to [%s]", (Object[])new Object[]{this.rateLimitGroupingId, capacity}), (Throwable)e);
            }
        }

        public int queueSize() {
            return this.queue.size();
        }

        public boolean isShutdown() {
            return this.isShutdownMethod.get();
        }

        public Instant timeOfLastEnqueue() {
            return this.timeOfLastEnqueue.get();
        }

        public synchronized TimeValue executeEnqueuedTask() {
            try {
                return this.executeEnqueuedTaskInternal();
            }
            catch (Exception e) {
                logger.warn(Strings.format((String)"Executor service grouping [%s] failed to execute request", (Object[])new Object[]{this.rateLimitGroupingId}), (Throwable)e);
                return EXECUTED_A_TASK;
            }
        }

        private TimeValue executeEnqueuedTaskInternal() {
            TimeValue timeBeforeAvailableToken;
            if (this.rateLimitSettings.isEnabled() && !RateLimitingEndpointHandler.shouldExecuteImmediately(timeBeforeAvailableToken = this.rateLimiter.timeToReserve(1))) {
                return timeBeforeAvailableToken;
            }
            RejectableTask task = this.queue.poll();
            if (!RateLimitingEndpointHandler.shouldExecuteTask(task)) {
                return NO_TASKS_AVAILABLE;
            }
            if (this.rateLimitSettings.isEnabled()) {
                TimeValue reserveRes = this.rateLimiter.reserve(1);
                assert (RateLimitingEndpointHandler.shouldExecuteImmediately(reserveRes)) : "Reserving request tokens required a sleep when it should not have";
            }
            task.getRequestManager().execute(task.getInferenceInputs(), this.requestSender, task.getRequestCompletedFunction(), task.getListener());
            return EXECUTED_A_TASK;
        }

        private static boolean shouldExecuteTask(RejectableTask task) {
            return task != null && !RateLimitingEndpointHandler.isNoopRequest(task) && !task.hasCompleted();
        }

        private static boolean isNoopRequest(InferenceRequest inferenceRequest) {
            return inferenceRequest.getRequestManager() == null || inferenceRequest.getInferenceInputs() == null || inferenceRequest.getListener() == null;
        }

        private static boolean shouldExecuteImmediately(TimeValue delay) {
            return delay.duration() == 0L;
        }

        public void enqueue(RequestTask task) {
            this.timeOfLastEnqueue.set(Instant.now(this.clock));
            if (this.isShutdown()) {
                EsRejectedExecutionException rejected = new EsRejectedExecutionException(Strings.format((String)"Failed to enqueue task for inference id [%s] because the request service [%s] has already shutdown", (Object[])new Object[]{task.getRequestManager().inferenceEntityId(), this.rateLimitGroupingId}), true);
                task.onRejection((Exception)((Object)rejected));
                return;
            }
            boolean addedToQueue = this.queue.offer(task);
            if (!addedToQueue) {
                EsRejectedExecutionException rejected = new EsRejectedExecutionException(Strings.format((String)"Failed to execute task for inference id [%s] because the request service [%s] queue is full", (Object[])new Object[]{task.getRequestManager().inferenceEntityId(), this.rateLimitGroupingId}), false);
                task.onRejection((Exception)((Object)rejected));
            } else if (this.isShutdown()) {
                this.notifyRequestsOfShutdown();
            }
        }

        public synchronized void notifyRequestsOfShutdown() {
            assert (this.isShutdown()) : "Requests should only be notified if the executor is shutting down";
            try {
                ArrayList<RejectableTask> notExecuted = new ArrayList<RejectableTask>();
                this.queue.drainTo(notExecuted);
                this.rejectTasks(notExecuted);
            }
            catch (Exception e) {
                logger.warn(Strings.format((String)"Failed to notify tasks of executor service grouping [%s] shutdown", (Object[])new Object[]{this.rateLimitGroupingId}));
            }
        }

        private void rejectTasks(List<RejectableTask> tasks) {
            for (RejectableTask task : tasks) {
                String inferenceEntityId = task.getRequestManager().inferenceEntityId();
                RequestExecutorService.rejectRequest(task, Strings.format((String)"Failed to send request, request service [%s] for inference id [%s] has shutdown prior to executing request", (Object[])new Object[]{this.rateLimitGroupingId, inferenceEntityId}), Strings.format((String)"Failed to notify request for inference id [%s] of rejection after executor service grouping [%s] shutdown", (Object[])new Object[]{inferenceEntityId, this.rateLimitGroupingId}));
            }
        }

        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        public void close() {
            this.requestExecutorServiceSettings.deregisterQueueCapacityCallback(this.rateLimitGroupingId);
        }
    }
}

