/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.CCMEnabledActionResponse;
import org.elasticsearch.xpack.core.inference.action.PutCCMConfigurationAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMService;

public class TransportPutCCMConfigurationAction
extends TransportMasterNodeAction<PutCCMConfigurationAction.Request, CCMEnabledActionResponse> {
    private final CCMFeature ccmFeature;
    private final CCMService ccmService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPutCCMConfigurationAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, CCMService ccmService, ProjectResolver projectResolver, CCMFeature ccmFeature) {
        super("cluster:admin/xpack/inference/ccm/put", transportService, clusterService, threadPool, actionFilters, PutCCMConfigurationAction.Request::new, CCMEnabledActionResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.ccmService = Objects.requireNonNull(ccmService);
        this.projectResolver = Objects.requireNonNull(projectResolver);
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    protected void masterOperation(Task task, PutCCMConfigurationAction.Request request, ClusterState state, ActionListener<CCMEnabledActionResponse> listener) {
        if (!this.ccmFeature.allowConfiguringCcm()) {
            listener.onFailure((Exception)CCMFeature.CCM_FORBIDDEN_EXCEPTION);
            return;
        }
        ActionListener enabledListener = listener.delegateFailureIgnoreResponseAndWrap(delegate -> delegate.onResponse((Object)new CCMEnabledActionResponse(true)));
        this.ccmService.storeConfiguration(new CCMModel(request.getApiKey()), (ActionListener<Void>)enabledListener);
    }

    protected ClusterBlockException checkBlock(PutCCMConfigurationAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

