/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;

public class RestGetStatusAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ilm/status"));
    }

    public String getName() {
        return "ilm_get_operation_mode_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        GetStatusAction.Request request = new GetStatusAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        if (restRequest.hasParam("timeout")) {
            TimeValue timeout = restRequest.paramAsTime("timeout", null);
            if (restRequest.getRestApiVersion() != RestApiVersion.V_8) {
                DeprecationLogger.getLogger(TransportLocalClusterStateAction.class).critical(DeprecationCategory.API, "TransportLocalClusterStateAction-timeout-parameter", "the [?timeout] query parameter to this API has no effect, is now deprecated, and will be removed in a future version", new Object[0]);
            }
        }
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)GetStatusAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

