/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;

public class ImmediateLocalSupplier
implements LocalSupplier {
    private static final TransportVersion ESQL_PLAN_WITH_NO_COLUMNS = TransportVersion.fromName((String)"esql_plan_with_no_columns");
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LocalSupplier.class, "ImmediateSupplier", ImmediateLocalSupplier::new);
    protected Page page;

    ImmediateLocalSupplier(Page page) {
        this.page = page;
    }

    ImmediateLocalSupplier(StreamInput in) throws IOException {
        this(in.getTransportVersion().supports(ESQL_PLAN_WITH_NO_COLUMNS) ? new Page(in.readInt(), ((PlanStreamInput)in).readCachedBlockArray()) : ImmediateLocalSupplier.legacyPage((PlanStreamInput)in));
    }

    private static Page legacyPage(PlanStreamInput in) throws IOException {
        Block[] blocks = in.readCachedBlockArray();
        if (blocks.length == 0) {
            return new Page(0, blocks);
        }
        return new Page(blocks);
    }

    @Override
    public Page get() {
        return this.page;
    }

    public String toString() {
        return this.page.toString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_PLAN_WITH_NO_COLUMNS)) {
            out.writeInt(this.page.getPositionCount());
        }
        Object[] blocks = new Block[this.page.getBlockCount()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.page.getBlock(i);
        }
        out.writeArray((o, v) -> ((PlanStreamOutput)o).writeCachedBlock((Block)v), blocks);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImmediateLocalSupplier other = (ImmediateLocalSupplier)obj;
        return this.page.equals((Object)other.page);
    }

    public int hashCode() {
        return this.page.hashCode();
    }

    public String getWriteableName() {
        return ImmediateLocalSupplier.ENTRY.name;
    }
}

