/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.StubRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.CopyingLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public class InlineJoin
extends Join {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "InlineJoin", InlineJoin::readFrom);

    public static LogicalPlan stubSource(UnaryPlan sourcePlan, LogicalPlan target) {
        return sourcePlan.replaceChild(new StubRelation(sourcePlan.source(), StubRelation.computeOutput(sourcePlan, target)));
    }

    public static LogicalPlan inlineData(InlineJoin target, LocalRelation data) {
        if (target.config().leftFields().isEmpty()) {
            List<Attribute> schema = data.output();
            Page page = (Page)data.supplier().get();
            ArrayList<Alias> aliases = new ArrayList<Alias>(schema.size());
            for (int i = 0; i < schema.size(); ++i) {
                Attribute attr = schema.get(i);
                aliases.add(new Alias(attr.source(), attr.name(), (Expression)Literal.of((Expression)attr, (Object)BlockUtils.toJavaObject((Block)page.getBlock(i), (int)0)), attr.id()));
            }
            return new Eval(target.source(), target.left(), aliases);
        }
        return target.replaceRight(data);
    }

    @Override
    protected LogicalPlan getRightToSerialize(StreamOutput out) {
        return this.right();
    }

    public static LogicalPlan replaceStub(LogicalPlan stubReplacement, LogicalPlan stubbedPlan) {
        Holder doneReplacing = new Holder((Object)false);
        LogicalPlan result = (LogicalPlan)stubbedPlan.transformUp(UnaryPlan.class, up -> {
            if (up.child() instanceof StubRelation) {
                if (!((Boolean)doneReplacing.get()).booleanValue()) {
                    doneReplacing.set((Object)true);
                    return up.replaceChild(stubReplacement);
                }
                throw new IllegalStateException("Expected to replace a single StubRelation in the plan, but found more than one");
            }
            return up;
        });
        if (!((Boolean)doneReplacing.get()).booleanValue()) {
            throw new IllegalStateException("Expected to replace a single StubRelation in the plan, but none found");
        }
        return result;
    }

    public static LogicalPlanTuple firstSubPlan(LogicalPlan optimizedPlan, Set<LocalRelation> subPlansResults) {
        Holder stubReplacedSubPlanHolder = new Holder();
        Holder originalSubPlanHolder = new Holder();
        optimizedPlan.forEachUp(InlineJoin.class, ij -> {
            block2: {
                block4: {
                    block6: {
                        block5: {
                            block3: {
                                if (stubReplacedSubPlanHolder.get() != null) break block2;
                                if (!ij.right().anyMatch(p -> p instanceof StubRelation)) break block3;
                                stubReplacedSubPlanHolder.set((Object)InlineJoin.replaceStub(ij.left(), ij.right()));
                                break block4;
                            }
                            LogicalPlan patt0$temp = ij.right();
                            if (!(patt0$temp instanceof LocalRelation)) break block5;
                            LocalRelation relation = (LocalRelation)patt0$temp;
                            if (subPlansResults.isEmpty() || !subPlansResults.contains((Object)relation)) break block6;
                        }
                        if (ij.right() instanceof LocalRelation || !ij.right().anyMatch(p -> p instanceof LocalRelation)) break block4;
                    }
                    stubReplacedSubPlanHolder.set((Object)ij.right());
                }
                originalSubPlanHolder.set((Object)ij.right());
            }
        });
        LogicalPlanTuple tuple = null;
        LogicalPlan plan = (LogicalPlan)((Object)stubReplacedSubPlanHolder.get());
        if (plan != null) {
            plan = (LogicalPlan)plan.transformUp(LocalRelation.class, lr -> {
                if (!(lr.supplier() instanceof CopyingLocalSupplier)) {
                    return new LocalRelation(lr.source(), lr.output(), new CopyingLocalSupplier((Page)lr.supplier().get()));
                }
                return lr;
            });
            plan.setOptimized();
            tuple = new LogicalPlanTuple(plan, (LogicalPlan)((Object)originalSubPlanHolder.get()));
        }
        return tuple;
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right, config);
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right, type, leftFields, rightFields, null);
    }

    private static InlineJoin readFrom(StreamInput in) throws IOException {
        PlanStreamInput planInput = (PlanStreamInput)in;
        Source source = Source.readFrom((StreamInput)planInput);
        LogicalPlan left = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        LogicalPlan right = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        JoinConfig config = new JoinConfig(in);
        return new InlineJoin(source, left, right, config);
    }

    @Override
    public String getWriteableName() {
        return InlineJoin.ENTRY.name;
    }

    @Override
    protected NodeInfo<Join> info() {
        JoinConfig config = this.config();
        return NodeInfo.create((Node)this, InlineJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)config.type(), config.leftFields(), config.rightFields());
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new InlineJoin(this.source(), left, right, this.config());
    }

    @Override
    public List<NamedExpression> computeOutputExpressions(List<? extends NamedExpression> left, List<? extends NamedExpression> right) {
        JoinType joinType = this.config().type();
        if (!JoinTypes.LEFT.equals(joinType)) {
            throw new IllegalArgumentException(joinType.joinName() + " unsupported");
        }
        List<NamedExpression> leftOutputWithoutKeys = left.stream().filter(ne -> !this.config().leftFields().contains(ne.toAttribute())).toList();
        ArrayList<? extends NamedExpression> rightWithAppendedLeftKeys = new ArrayList<NamedExpression>(right);
        rightWithAppendedLeftKeys.removeIf(ne -> this.config().rightFields().contains(ne.toAttribute()));
        AttributeMap leftAttrMap = AttributeMap.mapAll(left, NamedExpression::toAttribute);
        this.config().leftFields().forEach(lk -> rightWithAppendedLeftKeys.add((NamedExpression)leftAttrMap.getOrDefault(lk, lk)));
        List<NamedExpression> output = NamedExpressions.mergeOutputExpressions(rightWithAppendedLeftKeys, leftOutputWithoutKeys);
        return output;
    }

    public record LogicalPlanTuple(LogicalPlan stubReplacedSubPlan, LogicalPlan originalSubPlan) {
    }
}

