/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class InsensitiveEquals
extends InsensitiveBinaryComparison {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "InsensitiveEquals", InsensitiveEquals::new);

    public InsensitiveEquals(Source source, Expression left, Expression right) {
        super(source, left, right);
    }

    private InsensitiveEquals(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return InsensitiveEquals.ENTRY.name;
    }

    protected NodeInfo<InsensitiveEquals> info() {
        return NodeInfo.create((Node)this, InsensitiveEquals::new, (Object)this.left(), (Object)this.right());
    }

    protected InsensitiveEquals replaceChildren(Expression newLeft, Expression newRight) {
        return new InsensitiveEquals(this.source(), newLeft, newRight);
    }

    static boolean process(BytesRef lhs, BytesRef rhs) {
        return InsensitiveEquals.processConstant(lhs, new ByteRunAutomaton(InsensitiveEquals.automaton(rhs)));
    }

    static boolean processConstant(BytesRef lhs, ByteRunAutomaton rhs) {
        return rhs.run(lhs.bytes, lhs.offset, lhs.length);
    }

    public String symbol() {
        return "=~";
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isString((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isFoldable((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    public static Automaton automaton(BytesRef val) {
        if (val.length == 0) {
            return Automata.makeEmptyString();
        }
        return AutomatonQueries.toCaseInsensitiveString((String)val.utf8ToString());
    }

    public Boolean fold(FoldContext ctx) {
        BytesRef leftVal = BytesRefs.toBytesRef((Object)this.left().fold(ctx));
        BytesRef rightVal = BytesRefs.toBytesRef((Object)this.right().fold(ctx));
        if (leftVal == null || rightVal == null) {
            return null;
        }
        return InsensitiveEquals.process(leftVal, rightVal);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableFieldAttribute(this.left()) && this.right().foldable() ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        this.checkInsensitiveComparison();
        return this.translate();
    }

    private void checkInsensitiveComparison() {
        Check.isTrue((boolean)this.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{this.right().sourceLocation().getLineNumber(), this.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)this.right()), this.symbol()});
    }

    private Query translate() {
        TypedAttribute attribute = LucenePushdownPredicates.checkIsPushableAttribute(this.left());
        BytesRef value = BytesRefs.toBytesRef((Object)Foldables.literalValueOf(this.right()));
        String name = LucenePushdownPredicates.pushableAttributeName(attribute);
        return new TermQuery(this.source(), name, (Object)value.utf8ToString(), true);
    }

    @Override
    public Expression singleValueField() {
        return this.left();
    }
}

