/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.vector;

import java.io.IOException;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorSimilarityFunction;

public class CosineSimilarity
extends VectorSimilarityFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "CosineSimilarity", CosineSimilarity::new);
    public static final DenseVectorFieldMapper.SimilarityFunction SIMILARITY_FUNCTION = new DenseVectorFieldMapper.SimilarityFunction(){

        public float calculateSimilarity(byte[] leftVector, byte[] rightVector) {
            return VectorUtil.cosine((byte[])leftVector, (byte[])rightVector);
        }

        public float calculateSimilarity(float[] leftVector, float[] rightVector) {
            return VectorUtil.cosine((float[])leftVector, (float[])rightVector);
        }

        public BlockLoaderFunctionConfig.Function function() {
            return BlockLoaderFunctionConfig.Function.V_COSINE;
        }

        public String toString() {
            return "V_COSINE";
        }
    };

    @FunctionInfo(returnType={"double"}, preview=true, description="Calculates the cosine similarity between two dense_vectors.", examples={@Example(file="vector-cosine-similarity", tag="vector-cosine-similarity")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)})
    public CosineSimilarity(Source source, @Param(name="left", type={"dense_vector"}, description="first dense_vector to calculate cosine similarity") Expression left, @Param(name="right", type={"dense_vector"}, description="second dense_vector to calculate cosine similarity") Expression right) {
        super(source, left, right);
    }

    private CosineSimilarity(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public DenseVectorFieldMapper.SimilarityFunction getSimilarityFunction() {
        return SIMILARITY_FUNCTION;
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new CosineSimilarity(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CosineSimilarity::new, (Object)this.left(), (Object)this.right());
    }

    public String getWriteableName() {
        return CosineSimilarity.ENTRY.name;
    }
}

