/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySign;

public final class CopySignFloatEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CopySignFloatEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator magnitude;
    private final EvalOperator.ExpressionEvaluator sign;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CopySignFloatEvaluator(Source source, EvalOperator.ExpressionEvaluator magnitude, EvalOperator.ExpressionEvaluator sign, DriverContext driverContext) {
        this.source = source;
        this.magnitude = magnitude;
        this.sign = sign;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (FloatBlock magnitudeBlock = (FloatBlock)this.magnitude.eval(page);){
            FloatBlock floatBlock;
            block20: {
                DoubleVector signVector;
                FloatVector magnitudeVector;
                DoubleBlock signBlock;
                block18: {
                    FloatBlock floatBlock2;
                    block19: {
                        block16: {
                            FloatBlock floatBlock3;
                            block17: {
                                signBlock = (DoubleBlock)this.sign.eval(page);
                                try {
                                    magnitudeVector = magnitudeBlock.asVector();
                                    if (magnitudeVector != null) break block16;
                                    floatBlock3 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                                    if (signBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (signBlock != null) {
                                        try {
                                            signBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                signBlock.close();
                            }
                            return floatBlock3;
                        }
                        signVector = signBlock.asVector();
                        if (signVector != null) break block18;
                        floatBlock2 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                        if (signBlock == null) break block19;
                        signBlock.close();
                    }
                    return floatBlock2;
                }
                floatBlock = this.eval(page.getPositionCount(), magnitudeVector, signVector).asBlock();
                if (signBlock == null) break block20;
                signBlock.close();
            }
            return floatBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.magnitude.baseRamBytesUsed();
        return baseRamBytesUsed += this.sign.baseRamBytesUsed();
    }

    public FloatBlock eval(int positionCount, FloatBlock magnitudeBlock, DoubleBlock signBlock) {
        try (FloatBlock.Builder result = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (magnitudeBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (signBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                float magnitude = magnitudeBlock.getFloat(magnitudeBlock.getFirstValueIndex(p));
                double sign = signBlock.getDouble(signBlock.getFirstValueIndex(p));
                result.appendFloat(CopySign.processFloat(magnitude, sign));
            }
            FloatBlock floatBlock = result.build();
            return floatBlock;
        }
    }

    public FloatVector eval(int positionCount, FloatVector magnitudeVector, DoubleVector signVector) {
        try (FloatVector.FixedBuilder result = this.driverContext.blockFactory().newFloatVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                float magnitude = magnitudeVector.getFloat(p);
                double sign = signVector.getDouble(p);
                result.appendFloat(p, CopySign.processFloat(magnitude, sign));
            }
            FloatVector floatVector = result.build();
            return floatVector;
        }
    }

    public String toString() {
        return "CopySignFloatEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.magnitude, this.sign});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory magnitude;
        private final EvalOperator.ExpressionEvaluator.Factory sign;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory magnitude, EvalOperator.ExpressionEvaluator.Factory sign) {
            this.source = source;
            this.magnitude = magnitude;
            this.sign = sign;
        }

        public CopySignFloatEvaluator get(DriverContext context) {
            return new CopySignFloatEvaluator(this.source, this.magnitude.get(context), this.sign.get(context), context);
        }

        public String toString() {
            return "CopySignFloatEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
        }
    }
}

