/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(AbsDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;
    private Warnings warnings;

    public AbsDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.source = source;
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock fieldValBlock = (DoubleBlock)this.fieldVal.eval(page);){
            DoubleVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.fieldVal.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock fieldValBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (fieldValBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                double fieldVal = fieldValBlock.getDouble(fieldValBlock.getFirstValueIndex(p));
                result.appendDouble(Abs.process(fieldVal));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector fieldValVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double fieldVal = fieldValVector.getDouble(p);
                result.appendDouble(p, Abs.process(fieldVal));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "AbsDoubleEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal) {
            this.source = source;
            this.fieldVal = fieldVal;
        }

        public AbsDoubleEvaluator get(DriverContext context) {
            return new AbsDoubleEvaluator(this.source, this.fieldVal.get(context), context);
        }

        public String toString() {
            return "AbsDoubleEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
        }
    }
}

