/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVectorFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVectorFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVectorFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVectorFromStringEvaluator;

public class ToDenseVector
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToDenseVector", ToDenseVector::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.DENSE_VECTOR, (source, fieldEval) -> fieldEval), Map.entry(DataType.LONG, ToDenseVectorFromLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToDenseVectorFromIntEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToDenseVectorFromDoubleEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToDenseVectorFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"dense_vector"}, description="Converts a multi-valued input of numbers, or a hexadecimal string, to a dense_vector.", preview=true, examples={@Example(file="dense_vector", tag="to_dense_vector-ints")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")})
    public ToDenseVector(Source source, @Param(name="field", type={"double", "long", "integer", "keyword"}, description="multi-valued input of numbers or hexadecimal string to convert.") Expression field) {
        super(source, field);
    }

    private ToDenseVector(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToDenseVector.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.DENSE_VECTOR;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDenseVector(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDenseVector::new, (Object)this.field());
    }

    static float fromLong(long l) {
        return l;
    }

    static float fromInt(int i) {
        return i;
    }

    static float fromDouble(double d) {
        return (float)d;
    }
}

