/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;

public final class ClampMaxBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMaxBooleanEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator max;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMaxBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator max, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.max = max;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BooleanBlock fieldBlock = (BooleanBlock)this.field.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BooleanVector maxVector;
                BooleanVector fieldVector;
                BooleanBlock maxBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                maxBlock = (BooleanBlock)this.max.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                                    if (maxBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (maxBlock != null) {
                                        try {
                                            maxBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                maxBlock.close();
                            }
                            return booleanBlock3;
                        }
                        maxVector = maxBlock.asVector();
                        if (maxVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                        if (maxBlock == null) break block19;
                        maxBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), fieldVector, maxVector).asBlock();
                if (maxBlock == null) break block20;
                maxBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.max.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BooleanBlock fieldBlock, BooleanBlock maxBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (maxBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                boolean field = fieldBlock.getBoolean(fieldBlock.getFirstValueIndex(p));
                boolean max = maxBlock.getBoolean(maxBlock.getFirstValueIndex(p));
                result.appendBoolean(ClampMax.process(field, max));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BooleanVector fieldVector, BooleanVector maxVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean field = fieldVector.getBoolean(p);
                boolean max = maxVector.getBoolean(p);
                result.appendBoolean(p, ClampMax.process(field, max));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "ClampMaxBooleanEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.max});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory max;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory max) {
            this.source = source;
            this.field = field;
            this.max = max;
        }

        public ClampMaxBooleanEvaluator get(DriverContext context) {
            return new ClampMaxBooleanEvaluator(this.source, this.field.get(context), this.max.get(context), context);
        }

        public String toString() {
            return "ClampMaxBooleanEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
        }
    }
}

