/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.StdDevLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Variance
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Variance", Variance::new);

    @FunctionInfo(returnType={"double"}, description="The population variance of a numeric field.", type=FunctionType.AGGREGATE, examples={@Example(file="stats", tag="variance")})
    public Variance(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW);
    }

    public Variance(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private Variance(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Variance.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long or counter types"});
    }

    protected NodeInfo<Variance> info() {
        return NodeInfo.create((Node)this, Variance::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public Variance replaceChildren(List<Expression> newChildren) {
        return new Variance(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public Variance withFilter(Expression filter) {
        return new Variance(this.source(), this.field(), filter, this.window());
    }

    @Override
    public final AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (type == DataType.LONG) {
            return new StdDevLongAggregatorFunctionSupplier(false);
        }
        if (type == DataType.INTEGER) {
            return new StdDevIntAggregatorFunctionSupplier(false);
        }
        if (type == DataType.DOUBLE) {
            return new StdDevDoubleAggregatorFunctionSupplier(false);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

