/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.HistogramMerge;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.HistogramPercentile;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvPercentile;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Percentile
extends NumericAggregate
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Percentile", Percentile::new);
    private final Expression percentile;

    @FunctionInfo(returnType={"double"}, description="Returns the value at which a certain percentage of observed values occur. For example, the 95th percentile is the value which is greater than 95% of the observed values and the 50th percentile is the `MEDIAN`.", appendix="### `PERCENTILE` is (usually) approximate [esql-percentile-approximate]\n\n:::{include} /reference/aggregations/_snippets/search-aggregations-metrics-percentile-aggregation-approximate.md\n:::\n\n::::{warning}\n`PERCENTILE` is also {wikipedia}/Nondeterministic_algorithm[non-deterministic].\nThis means you can get slightly different results using the same data.\n::::", type=FunctionType.AGGREGATE, examples={@Example(file="stats_percentile", tag="percentile"), @Example(description="The expression can use inline functions. For example, to calculate a percentile of the maximum values of a multivalued column, first use `MV_MAX` to get the maximum value per row, and use the result with the `PERCENTILE` function", file="stats_percentile", tag="docsStatsPercentileNestedExpression")})
    public Percentile(Source source, @Param(name="number", type={"double", "integer", "long", "exponential_histogram"}) Expression field, @Param(name="percentile", type={"double", "integer", "long"}) Expression percentile) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, percentile);
    }

    public Percentile(Source source, Expression field, Expression filter, Expression window, Expression percentile) {
        super(source, field, filter, window, Collections.singletonList(percentile));
        this.percentile = percentile;
    }

    private Percentile(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Percentile.readWindow(in), (Expression)in.readNamedWriteableCollectionAsList(Expression.class).getFirst());
    }

    public String getWriteableName() {
        return Percentile.ENTRY.name;
    }

    protected NodeInfo<Percentile> info() {
        return NodeInfo.create((Node)this, Percentile::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.percentile);
    }

    public Percentile replaceChildren(List<Expression> newChildren) {
        return new Percentile(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Percentile withFilter(Expression filter) {
        return new Percentile(this.source(), this.field(), filter, this.window(), this.percentile);
    }

    public Expression percentile() {
        return this.percentile;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG || dt == DataType.EXPONENTIAL_HISTOGRAM, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"exponential_histogram or numeric except unsigned_long"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isType((Expression)this.percentile, dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"numeric except unsigned_long"}).and(TypeResolutions.isFoldable((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier() {
        return new PercentileLongAggregatorFunctionSupplier(this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier() {
        return new PercentileIntAggregatorFunctionSupplier(this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier() {
        return new PercentileDoubleAggregatorFunctionSupplier(this.percentileValue());
    }

    private double percentileValue() {
        return Foldables.doubleValueOf(this.percentile(), this.source().text(), "Percentile");
    }

    @Override
    public Expression surrogate() {
        Expression field = this.field();
        if (field.dataType() == DataType.EXPONENTIAL_HISTOGRAM) {
            return new HistogramPercentile(this.source(), (Expression)new HistogramMerge(this.source(), field, this.filter()), this.percentile());
        }
        if (field.foldable()) {
            return new MvPercentile(this.source(), (Expression)new ToDouble(this.source(), field), this.percentile());
        }
        return null;
    }
}

