/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SummationMode;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Avg
extends AggregateFunction
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Avg", Avg::new);
    private final Expression summationMode;

    @FunctionInfo(returnType={"double"}, description="The average of a numeric field.", type=FunctionType.AGGREGATE, examples={@Example(file="stats", tag="avg"), @Example(description="The expression can use inline functions. For example, to calculate the average over a multivalued column, first use `MV_AVG` to average the multiple values per row, and use the result with the `AVG` function", file="stats", tag="docsStatsAvgNestedExpression")})
    public Avg(Source source, @Param(name="number", type={"aggregate_metric_double", "double", "integer", "long"}, description="Expression that outputs values to average.") Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, (Expression)SummationMode.COMPENSATED_LITERAL);
    }

    public Avg(Source source, Expression field, Expression filter, Expression window, Expression summationMode) {
        super(source, field, filter, window, List.of(summationMode));
        this.summationMode = summationMode;
    }

    public Expression summationMode() {
        return this.summationMode;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG || dt == DataType.AGGREGATE_METRIC_DOUBLE, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"aggregate_metric_double or numeric except unsigned_long or counter types"});
    }

    private Avg(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), Avg.readWindow(in), Avg.readSummationMode(in));
    }

    private static Expression readSummationMode(StreamInput in) throws IOException {
        List parameters = in.readNamedWriteableCollectionAsList(Expression.class);
        return parameters.isEmpty() ? SummationMode.COMPENSATED_LITERAL : (Expression)parameters.getFirst();
    }

    public String getWriteableName() {
        return Avg.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected NodeInfo<Avg> info() {
        return NodeInfo.create((Node)this, Avg::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.summationMode);
    }

    public Avg replaceChildren(List<Expression> newChildren) {
        return new Avg(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public Avg withFilter(Expression filter) {
        return new Avg(this.source(), this.field(), filter, this.window(), this.summationMode);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        if (field.dataType() == DataType.AGGREGATE_METRIC_DOUBLE) {
            return new Div(s, new Sum(s, field, this.filter(), this.window(), this.summationMode).surrogate(), new Count(s, field, this.filter(), this.window()).surrogate());
        }
        if (field.foldable()) {
            return new MvAvg(s, field);
        }
        return new Div(s, (Expression)new Sum(s, field, this.filter(), this.window(), this.summationMode), (Expression)new Count(s, field, this.filter(), this.window()), this.dataType());
    }
}

