/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public abstract class AggregateFunction
extends Function
implements PostAnalysisPlanVerificationAware {
    public static final Literal NO_WINDOW = Literal.timeDuration((Source)Source.EMPTY, (Duration)Duration.ZERO);
    public static final TransportVersion WINDOW_INTERVAL = TransportVersion.fromName((String)"aggregation_window");
    private final Expression field;
    private final List<? extends Expression> parameters;
    private final Expression filter;
    private final Expression window;

    protected AggregateFunction(Source source, Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, Collections.emptyList());
    }

    protected AggregateFunction(Source source, Expression field, List<? extends Expression> parameters) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, parameters);
    }

    protected AggregateFunction(Source source, Expression field, Expression filter, Expression window, List<? extends Expression> parameters) {
        super(source, CollectionUtils.combine(Arrays.asList(field, filter, window), parameters));
        this.field = field;
        this.filter = filter;
        this.window = Objects.requireNonNull(window, "[window] must be specified; use NO_WINDOW instead");
        this.parameters = parameters;
    }

    protected AggregateFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), AggregateFunction.readWindow(in), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    protected static Expression readWindow(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(WINDOW_INTERVAL)) {
            return (Expression)in.readNamedWriteable(Expression.class);
        }
        return NO_WINDOW;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.filter);
        if (out.getTransportVersion().supports(WINDOW_INTERVAL)) {
            out.writeNamedWriteable((NamedWriteable)this.window);
        }
        out.writeNamedWriteableCollection(this.parameters);
    }

    public Expression field() {
        return this.field;
    }

    public List<? extends Expression> parameters() {
        return this.parameters;
    }

    public boolean hasFilter() {
        Literal literal;
        Expression expression;
        return this.filter != null && (!this.filter.foldable() || (expression = this.filter) instanceof Literal && !Boolean.TRUE.equals((literal = (Literal)expression).value()));
    }

    public Expression filter() {
        return this.filter;
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public abstract AggregateFunction withFilter(Expression var1);

    public AggregateFunction withParameters(List<? extends Expression> parameters) {
        if (parameters == this.parameters) {
            return this;
        }
        return (AggregateFunction)this.replaceChildren(CollectionUtils.combine(Arrays.asList(this.field, this.filter), parameters));
    }

    public Expression window() {
        return this.window;
    }

    public boolean hasWindow() {
        Literal lit;
        Object object = this.window;
        if (object instanceof Literal && (object = (lit = (Literal)object).value()) instanceof Duration) {
            Duration duration = (Duration)object;
            return !duration.isZero();
        }
        return true;
    }

    public AttributeSet aggregateInputReferences(Supplier<List<Attribute>> inputAttributes) {
        if (this.hasFilter()) {
            return Expressions.references((List)CollectionUtils.combine(List.of(this.field), this.parameters));
        }
        return this.references();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.children());
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AggregateFunction other = (AggregateFunction)obj;
            return Objects.equals(other.field(), this.field()) && Objects.equals(other.filter(), this.filter()) && Objects.equals(other.window(), this.window()) && Objects.equals(other.parameters(), this.parameters());
        }
        return false;
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (p, failures) -> {
            if (!(p instanceof Aggregate)) {
                p.expressions().forEach(x -> x.forEachDown(AggregateFunction.class, af -> failures.add(Failure.fail(af, "aggregate function [{}] not allowed outside STATS command", new Object[]{af.sourceText()}))));
            }
        };
    }
}

