/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;

public final class TypeResolutions {
    private TypeResolutions() {
    }

    public static Expression.TypeResolution isBoolean(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, (DataType dt) -> dt == DataType.BOOLEAN, operationName, paramOrd, "boolean");
    }

    public static Expression.TypeResolution isWholeNumber(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isWholeNumber, operationName, paramOrd, "integer");
    }

    public static Expression.TypeResolution isNumeric(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isNumeric, operationName, paramOrd, "numeric");
    }

    public static Expression.TypeResolution isString(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isString, operationName, paramOrd, "string");
    }

    public static Expression.TypeResolution isIP(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, (DataType dt) -> dt == DataType.IP, operationName, paramOrd, "ip");
    }

    public static Expression.TypeResolution isDate(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, (DataType dt) -> dt == DataType.DATETIME, operationName, paramOrd, "datetime");
    }

    public static Expression.TypeResolution isRepresentableExceptCountersDenseVectorAndAggregateMetricDouble(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, (DataType dt) -> DataType.isRepresentable(dt) && dt != DataType.DENSE_VECTOR && dt != DataType.AGGREGATE_METRIC_DOUBLE, operationName, paramOrd, "any type except counter types, dense_vector, or aggregate_metric_double");
    }

    public static Expression.TypeResolution isRepresentableExceptCountersSpatialDenseVectorAndAggregateMetricDouble(Expression e, String operationName, ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, (DataType t) -> !DataType.isSpatialOrGrid(t) && DataType.isRepresentable(t) && t != DataType.DENSE_VECTOR && t != DataType.AGGREGATE_METRIC_DOUBLE, operationName, paramOrd, "any type except counter, spatial types, dense_vector, or aggregate_metric_double");
    }

    public static Expression.TypeResolution isExact(Expression e, String message) {
        FieldAttribute fa;
        EsField.Exact exact;
        if (e instanceof FieldAttribute && !(exact = (fa = (FieldAttribute)e).getExactInfo()).hasExact()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)message, (Object[])new Object[]{e.dataType().typeName(), exact.errorMsg()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isExact(Expression e, String operationName, ParamOrdinal paramOrd) {
        FieldAttribute fa;
        EsField.Exact exact;
        if (e instanceof FieldAttribute && !(exact = (fa = (FieldAttribute)e).getExactInfo()).hasExact()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] cannot operate on {}field of data type [{}]: {}", (Object[])new Object[]{operationName, paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " argument ", e.dataType().typeName(), exact.errorMsg()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isStringAndExact(Expression e, String operationName, ParamOrdinal paramOrd) {
        Expression.TypeResolution resolution = TypeResolutions.isString(e, operationName, paramOrd);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isExact(e, operationName, paramOrd);
    }

    public static Expression.TypeResolution isIPAndExact(Expression e, String operationName, ParamOrdinal paramOrd) {
        Expression.TypeResolution resolution = TypeResolutions.isIP(e, operationName, paramOrd);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isExact(e, operationName, paramOrd);
    }

    public static Expression.TypeResolution isFoldable(Expression e, String operationName, ParamOrdinal paramOrd) {
        if (!e.foldable()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be a constant, received [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, Expressions.name(e)}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isNotNull(Expression e, String operationName, ParamOrdinal paramOrd) {
        if (e.dataType() == DataType.NULL) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] cannot be null, received [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, Expressions.name(e)}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isType(Expression e, Predicate<DataType> predicate, String operationName, ParamOrdinal paramOrd, String ... acceptedTypes) {
        return TypeResolutions.isType(e, predicate, operationName, paramOrd, false, acceptedTypes);
    }

    public static Expression.TypeResolution isTypeOrUnionType(Expression e, Predicate<DataType> predicate, String operationName, ParamOrdinal paramOrd, String ... acceptedTypes) {
        return TypeResolutions.isType(e, predicate, operationName, paramOrd, true, acceptedTypes);
    }

    public static Expression.TypeResolution isType(Expression e, Predicate<DataType> predicate, String operationName, ParamOrdinal paramOrd, boolean allowUnionTypes, String ... acceptedTypes) {
        return TypeResolutions.isType(e, predicate, null, operationName, paramOrd, allowUnionTypes, acceptedTypes);
    }

    public static Expression.TypeResolution isType(Expression e, Predicate<DataType> predicate, String errorMessagePrefix, String operationName, ParamOrdinal paramOrd, boolean allowUnionTypes, String ... acceptedTypes) {
        InvalidMappedField imf;
        FieldAttribute fa;
        EsField esField;
        if (predicate.test(e.dataType()) || e.dataType() == DataType.NULL) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (allowUnionTypes && e instanceof FieldAttribute && (esField = (fa = (FieldAttribute)e).field()) instanceof InvalidMappedField && (imf = (InvalidMappedField)esField).types().stream().allMatch(predicate)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(TypeResolutions.errorStringIncompatibleTypes(errorMessagePrefix, operationName, paramOrd, Expressions.name(e), e.dataType(), TypeResolutions.acceptedTypesForErrorMsg(acceptedTypes)));
    }

    private static String errorStringIncompatibleTypes(String errorMessagePrefix, String operationName, ParamOrdinal paramOrd, String argumentName, DataType foundType, String ... acceptedTypes) {
        return LoggerMessageFormat.format((String)errorMessagePrefix, (String)"{}argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, TypeResolutions.acceptedTypesForErrorMsg(acceptedTypes), argumentName, foundType.typeName()});
    }

    private static String acceptedTypesForErrorMsg(String ... acceptedTypes) {
        StringJoiner sj = new StringJoiner(", ");
        for (int i = 0; i < acceptedTypes.length - 1; ++i) {
            sj.add(acceptedTypes[i]);
        }
        if (acceptedTypes.length > 1) {
            return sj.toString() + " or " + acceptedTypes[acceptedTypes.length - 1];
        }
        return acceptedTypes[0];
    }

    public static Expression.TypeResolution isMapExpression(Expression e, String operationName, ParamOrdinal paramOrd) {
        if (!(e instanceof MapExpression)) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be a map expression, received [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, Expressions.name(e)}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static enum ParamOrdinal {
        DEFAULT,
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        FIFTH,
        IMPLICIT;


        public static ParamOrdinal fromIndex(int index) {
            ParamOrdinal paramOrdinal;
            if (index < 0) {
                paramOrdinal = IMPLICIT;
            } else {
                switch (index) {
                    case 0: {
                        paramOrdinal = FIRST;
                        break;
                    }
                    case 1: {
                        paramOrdinal = SECOND;
                        break;
                    }
                    case 2: {
                        paramOrdinal = THIRD;
                        break;
                    }
                    case 3: {
                        paramOrdinal = FOURTH;
                        break;
                    }
                    case 4: {
                        paramOrdinal = FIFTH;
                        break;
                    }
                    default: {
                        paramOrdinal = DEFAULT;
                    }
                }
            }
            return paramOrdinal;
        }
    }
}

