/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Types;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramBuilder;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ZeroBucket;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ExponentialHistogramXContent {
    public static final String SCALE_FIELD = "scale";
    public static final String SUM_FIELD = "sum";
    public static final String MIN_FIELD = "min";
    public static final String MAX_FIELD = "max";
    public static final String ZERO_FIELD = "zero";
    public static final String ZERO_COUNT_FIELD = "count";
    public static final String ZERO_THRESHOLD_FIELD = "threshold";
    public static final String POSITIVE_FIELD = "positive";
    public static final String NEGATIVE_FIELD = "negative";
    public static final String BUCKET_INDICES_FIELD = "indices";
    public static final String BUCKET_COUNTS_FIELD = "counts";

    public static void serialize(XContentBuilder builder, @Nullable ExponentialHistogram histogram) throws IOException {
        if (histogram == null) {
            builder.nullValue();
            return;
        }
        builder.startObject();
        builder.field(SCALE_FIELD, histogram.scale());
        builder.field(SUM_FIELD, histogram.sum());
        if (!Double.isNaN(histogram.min())) {
            builder.field(MIN_FIELD, histogram.min());
        }
        if (!Double.isNaN(histogram.max())) {
            builder.field(MAX_FIELD, histogram.max());
        }
        double zeroThreshold = histogram.zeroBucket().zeroThreshold();
        long zeroCount = histogram.zeroBucket().count();
        if (zeroCount != 0L || zeroThreshold != 0.0) {
            builder.startObject(ZERO_FIELD);
            if (zeroCount != 0L) {
                builder.field(ZERO_COUNT_FIELD, zeroCount);
            }
            if (zeroThreshold != 0.0) {
                builder.field(ZERO_THRESHOLD_FIELD, zeroThreshold);
            }
            builder.endObject();
        }
        ExponentialHistogramXContent.writeBuckets(builder, POSITIVE_FIELD, histogram.positiveBuckets());
        ExponentialHistogramXContent.writeBuckets(builder, NEGATIVE_FIELD, histogram.negativeBuckets());
        builder.endObject();
    }

    private static void writeBuckets(XContentBuilder b, String fieldName, ExponentialHistogram.Buckets buckets) throws IOException {
        if (!buckets.iterator().hasNext()) {
            return;
        }
        b.startObject(fieldName);
        CopyableBucketIterator it = buckets.iterator();
        b.startArray(BUCKET_INDICES_FIELD);
        while (it.hasNext()) {
            b.value(it.peekIndex());
            it.advance();
        }
        b.endArray();
        it = buckets.iterator();
        b.startArray(BUCKET_COUNTS_FIELD);
        while (it.hasNext()) {
            b.value(it.peekCount());
            it.advance();
        }
        b.endArray();
        b.endObject();
    }

    public static ExponentialHistogram parseForTesting(XContentParser xContent) throws IOException {
        if (xContent.currentToken() == null) {
            xContent.nextToken();
        }
        if (xContent.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return ExponentialHistogramXContent.parseForTesting(xContent.map());
    }

    public static ExponentialHistogram parseForTesting(@Nullable Map<String, Object> xContent) {
        if (xContent == null) {
            return null;
        }
        int scale = ((Number)xContent.get(SCALE_FIELD)).intValue();
        ExponentialHistogramBuilder builder = ExponentialHistogram.builder(scale, ExponentialHistogramCircuitBreaker.noop());
        Map zero = (Map)Types.forciblyCast(xContent.getOrDefault(ZERO_FIELD, Collections.emptyMap()));
        double zeroThreshold = ((Number)zero.getOrDefault(ZERO_THRESHOLD_FIELD, 0)).doubleValue();
        long zeroCount = ((Number)zero.getOrDefault(ZERO_COUNT_FIELD, 0)).longValue();
        builder.zeroBucket(ZeroBucket.create(zeroThreshold, zeroCount));
        builder.sum(((Number)xContent.getOrDefault(SUM_FIELD, 0)).doubleValue());
        builder.min(((Number)xContent.getOrDefault(MIN_FIELD, Double.NaN)).doubleValue());
        builder.max(((Number)xContent.getOrDefault(MAX_FIELD, Double.NaN)).doubleValue());
        ExponentialHistogramXContent.parseBuckets((Map)Types.forciblyCast(xContent.getOrDefault(NEGATIVE_FIELD, Collections.emptyMap())), builder::setNegativeBucket);
        ExponentialHistogramXContent.parseBuckets((Map)Types.forciblyCast(xContent.getOrDefault(POSITIVE_FIELD, Collections.emptyMap())), builder::setPositiveBucket);
        return builder.build();
    }

    private static void parseBuckets(Map<String, List<Number>> serializedBuckets, BiConsumer<Long, Long> bucketSetter) {
        List indices = serializedBuckets.getOrDefault(BUCKET_INDICES_FIELD, Collections.emptyList());
        List counts = serializedBuckets.getOrDefault(BUCKET_COUNTS_FIELD, Collections.emptyList());
        assert (indices.size() == counts.size());
        for (int i = 0; i < indices.size(); ++i) {
            bucketSetter.accept(((Number)indices.get(i)).longValue(), ((Number)counts.get(i)).longValue());
        }
    }
}

