/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.errorquery;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.test.errorquery.IndexError;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ErrorQueryBuilder
extends AbstractQueryBuilder<ErrorQueryBuilder> {
    public static final String NAME = "error_query";
    private List<IndexError> indices;
    static final ConstructingObjectParser<ErrorQueryBuilder, String> PARSER = new ConstructingObjectParser("error_query", false, (args, name) -> {
        ErrorQueryBuilder q = new ErrorQueryBuilder((List)args[0]);
        float boost = args[1] == null ? 1.0f : ((Float)args[1]).floatValue();
        String queryName = (String)args[2];
        q.boost = boost;
        q.queryName = queryName;
        return q;
    });

    public ErrorQueryBuilder(List<IndexError> indices) {
        this.indices = Objects.requireNonNull(indices);
    }

    public ErrorQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readCollectionAsList(IndexError::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeCollection(this.indices);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.nowInMillis();
        IndexError error = null;
        for (IndexError index : this.indices) {
            if (!context.indexMatches(index.getIndexName())) continue;
            error = index;
            break;
        }
        if (error == null) {
            return new MatchAllDocsQuery();
        }
        return new ErrorQuery(error, context);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray("indices");
        for (IndexError indexError : this.indices) {
            builder.startObject();
            indexError.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    protected boolean doEquals(ErrorQueryBuilder other) {
        return Objects.equals(this.indices, other.indices);
    }

    protected int doHashCode() {
        return Objects.hash(this.indices);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), IndexError.PARSER, new ParseField("indices", new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), BOOST_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
    }

    static class ErrorQuery
    extends Query {
        private final IndexError indexError;
        private volatile boolean sleepCompleted;
        private final MatchAllDocsQuery matchAllQuery;

        ErrorQuery(IndexError error, SearchExecutionContext context) {
            this.indexError = error;
            this.sleepCompleted = false;
            this.matchAllQuery = new MatchAllDocsQuery();
            if (error.getShardIds() != null) {
                boolean match = false;
                for (int shardId : error.getShardIds()) {
                    if (context.getShardId() != shardId) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return;
                }
            }
            String header = "[" + context.index().getName() + "][" + context.getShardId() + "]";
            if (error.getErrorType() == IndexError.ERROR_TYPE.WARNING) {
                HeaderWarning.addWarning((String)(header + " " + error.getMessage()), (Object[])new Object[0]);
            } else if (error.getErrorType() == IndexError.ERROR_TYPE.EXCEPTION) {
                if (this.indexError.getStallTimeSeconds() > 0) {
                    ErrorQueryBuilder.sleep((long)this.indexError.getStallTimeSeconds() * 1000L);
                }
                throw new RuntimeException(header + " " + error.getMessage());
            }
        }

        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
            if (this.indexError.getStallTimeSeconds() > 0 && !this.sleepCompleted) {
                ErrorQueryBuilder.sleep((long)this.indexError.getStallTimeSeconds() * 1000L);
                this.sleepCompleted = true;
            }
            return this.matchAllQuery.createWeight(searcher, scoreMode, boost);
        }

        public String toString(String field) {
            return "ErrorQuery MatchAll *:*";
        }

        public boolean equals(Object o) {
            return this.sameClassAs(o);
        }

        public int hashCode() {
            return this.classHash();
        }

        public void visit(QueryVisitor visitor) {
            this.matchAllQuery.visit(visitor);
        }
    }
}

