/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.snapshots.RegisteredPolicySnapshots;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicySecurityClient;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryItem;
import org.elasticsearch.xpack.slm.history.SnapshotHistoryStore;

public class SnapshotLifecycleTask
implements SchedulerEngine.Listener {
    private static final Logger logger = LogManager.getLogger(SnapshotLifecycleTask.class);
    private final ProjectId projectId;
    private final Client client;
    private final ClusterService clusterService;
    private final SnapshotHistoryStore historyStore;

    public SnapshotLifecycleTask(ProjectId projectId, Client client, ClusterService clusterService, SnapshotHistoryStore historyStore) {
        this.projectId = projectId;
        this.client = new OriginSettingClient(client, "index_lifecycle");
        this.clusterService = clusterService;
        this.historyStore = historyStore;
    }

    static List<String> findCompletedRegisteredSnapshotNames(ProjectState projectState, String policyId) {
        Set<SnapshotId> runningSnapshots = SnapshotLifecycleTask.currentlyRunningSnapshots(projectState.cluster());
        RegisteredPolicySnapshots registeredSnapshots = (RegisteredPolicySnapshots)projectState.metadata().custom("registered_snapshots", (Metadata.ProjectCustom)RegisteredPolicySnapshots.EMPTY);
        return registeredSnapshots.getSnapshots().stream().filter(policySnapshot -> policySnapshot.getPolicy().equals(policyId)).filter(policySnapshot -> !runningSnapshots.contains(policySnapshot.getSnapshotId())).map(policySnapshot -> policySnapshot.getSnapshotId().getName()).toList();
    }

    public void triggered(SchedulerEngine.Event event) {
        logger.debug("snapshot lifecycle policy task triggered from job [{}]", (Object)event.jobName());
        ProjectMetadata projectMetadata = this.clusterService.state().getMetadata().getProject(this.projectId);
        Optional<String> snapshotName = SnapshotLifecycleTask.maybeTakeSnapshot(projectMetadata, event.jobName(), this.client, this.clusterService, this.historyStore);
        snapshotName.ifPresent(name -> logger.info("snapshot lifecycle policy job [{}] issued new snapshot creation for [{}] successfully", (Object)event.jobName(), name));
        if (!snapshotName.isPresent()) {
            logger.warn("snapshot lifecycle policy for job [{}] no longer exists, snapshot not created", (Object)event.jobName());
        }
    }

    private static void findCompletedRegisteredSnapshotInfo(ProjectState projectState, String policyId, Client client, ActionListener<List<SnapshotInfo>> listener) {
        List<String> snapshotNames = SnapshotLifecycleTask.findCompletedRegisteredSnapshotNames(projectState, policyId);
        if (!snapshotNames.isEmpty()) {
            Optional<SnapshotLifecyclePolicyMetadata> policyMetadata = SnapshotLifecycleTask.getSnapPolicyMetadataById(projectState.metadata(), policyId);
            if (!policyMetadata.isPresent()) {
                listener.onFailure((Exception)new IllegalStateException(Strings.format((String)"snapshot lifecycle policy [%s] no longer exists", (Object[])new Object[]{policyId})));
                return;
            }
            SnapshotLifecyclePolicy policy = policyMetadata.get().getPolicy();
            GetSnapshotsRequest request = new GetSnapshotsRequest(TimeValue.MAX_VALUE, new String[]{policy.getRepository()}, snapshotNames.toArray(new String[0]));
            request.ignoreUnavailable(true);
            request.includeIndexNames(false);
            client.admin().cluster().execute(TransportGetSnapshotsAction.TYPE, (ActionRequest)request, ActionListener.wrap(response -> listener.onResponse((Object)response.getSnapshots()), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse(Collections.emptyList());
        }
    }

    public static Optional<String> maybeTakeSnapshot(ProjectMetadata projectMetadata, final String jobId, final Client client, final ClusterService clusterService, final SnapshotHistoryStore historyStore) {
        final ProjectId projectId = projectMetadata.id();
        Optional<SnapshotLifecyclePolicyMetadata> maybeMetadata = SnapshotLifecycleTask.getSnapPolicyMetadata(projectMetadata, jobId);
        String snapshotName = maybeMetadata.map(policyMetadata -> {
            final String policyId = policyMetadata.getPolicy().getId();
            final CreateSnapshotRequest request = policyMetadata.getPolicy().toRequest(TimeValue.MAX_VALUE);
            final SnapshotId snapshotId = new SnapshotId(request.snapshot(), request.uuid());
            LifecyclePolicySecurityClient clientWithHeaders = new LifecyclePolicySecurityClient(client, "index_lifecycle", policyMetadata.getHeaders());
            logger.info("snapshot lifecycle policy [{}] issuing create snapshot [{}]", (Object)policyMetadata.getPolicy().getId(), (Object)request.snapshot());
            clientWithHeaders.admin().cluster().createSnapshot(request, (ActionListener)new ActionListener<CreateSnapshotResponse>(){

                public void onResponse(CreateSnapshotResponse createSnapshotResponse) {
                    logger.debug("snapshot response for [{}]: {}", (Object)policyMetadata.getPolicy().getId(), (Object)org.elasticsearch.common.Strings.toString((ToXContent)createSnapshotResponse));
                    SnapshotInfo snapInfo = createSnapshotResponse.getSnapshotInfo();
                    assert (snapInfo != null) : "completed snapshot info is null";
                    if (snapInfo.failedShards() == 0) {
                        final long snapshotStartTime = snapInfo.startTime();
                        final long timestamp = Instant.now().toEpochMilli();
                        historyStore.putAsync(SnapshotHistoryItem.creationSuccessRecord(timestamp, policyMetadata.getPolicy(), request.snapshot()));
                        ProjectState currentProjectState = clusterService.state().projectState(projectId);
                        SnapshotLifecycleTask.findCompletedRegisteredSnapshotInfo(currentProjectState, policyId, client, new ActionListener<List<SnapshotInfo>>(){

                            public void onResponse(List<SnapshotInfo> snapshotInfo) {
                                SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-success-" + policyId, WriteJobStatus.success(projectId, policyId, snapshotId, snapshotStartTime, timestamp, snapshotInfo));
                            }

                            public void onFailure(Exception e) {
                                logger.warn(() -> Strings.format((String)"failed to retrieve stale registered snapshots for job [%s]", (Object[])new Object[]{jobId}), (Throwable)e);
                                SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-success-" + policyId, WriteJobStatus.success(projectId, policyId, snapshotId, snapshotStartTime, timestamp, Collections.emptyList()));
                            }
                        });
                    } else {
                        int failures = snapInfo.failedShards();
                        int total = snapInfo.totalShards();
                        SnapshotException e = new SnapshotException(request.repository(), request.snapshot(), "failed to create snapshot successfully, " + failures + " out of " + total + " total shards failed");
                        this.onFailure((Exception)e);
                    }
                }

                public void onFailure(final Exception e) {
                    SnapshotHistoryStore.logErrorOrWarning(logger, clusterService.state(), () -> Strings.format((String)"failed to create snapshot for snapshot lifecycle policy [%s]", (Object[])new Object[]{policyMetadata.getPolicy().getId()}), e);
                    final long timestamp = Instant.now().toEpochMilli();
                    try {
                        SnapshotHistoryItem failureRecord = SnapshotHistoryItem.creationFailureRecord(timestamp, policyMetadata.getPolicy(), request.snapshot(), e);
                        historyStore.putAsync(failureRecord);
                    }
                    catch (IOException ex) {
                        logger.error(() -> Strings.format((String)"failed to record snapshot creation failure for snapshot lifecycle policy [%s]", (Object[])new Object[]{policyMetadata.getPolicy().getId()}), (Throwable)e);
                    }
                    ProjectState currentProjectState = clusterService.state().projectState(projectId);
                    SnapshotLifecycleTask.findCompletedRegisteredSnapshotInfo(currentProjectState, policyId, client, new ActionListener<List<SnapshotInfo>>(){

                        public void onResponse(List<SnapshotInfo> snapshotInfo) {
                            SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-failure-" + policyMetadata.getPolicy().getId(), WriteJobStatus.failure(projectId, policyMetadata.getPolicy().getId(), snapshotId, timestamp, snapshotInfo, e));
                        }

                        public void onFailure(Exception e2) {
                            logger.warn(() -> Strings.format((String)"failed to retrieve stale registered snapshots for job [%s]", (Object[])new Object[]{jobId}), (Throwable)e2);
                            SnapshotLifecycleTask.submitUnbatchedTask(clusterService, "slm-record-failure-" + policyMetadata.getPolicy().getId(), WriteJobStatus.failure(projectId, policyMetadata.getPolicy().getId(), snapshotId, timestamp, Collections.emptyList(), e2));
                        }
                    });
                }
            });
            return request.snapshot();
        }).orElse(null);
        return Optional.ofNullable(snapshotName);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static Optional<SnapshotLifecyclePolicyMetadata> getSnapPolicyMetadata(ProjectMetadata projectMetadata, String jobId) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)projectMetadata.custom("snapshot_lifecycle")).map(SnapshotLifecycleMetadata::getSnapshotConfigurations).flatMap(configMap -> configMap.values().stream().filter(policyMeta -> jobId.equals(SnapshotLifecycleService.getJobId(policyMeta))).findFirst());
    }

    static Optional<SnapshotLifecyclePolicyMetadata> getSnapPolicyMetadataById(ProjectMetadata projectMetadata, String policyId) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)projectMetadata.custom("snapshot_lifecycle")).map(metadata -> (SnapshotLifecyclePolicyMetadata)metadata.getSnapshotConfigurations().get(policyId));
    }

    public static String exceptionToString(Exception ex) {
        return org.elasticsearch.common.Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)ex);
            return builder;
        }, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
    }

    static Set<SnapshotId> currentlyRunningSnapshots(ClusterState clusterState) {
        SnapshotsInProgress snapshots = (SnapshotsInProgress)clusterState.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY);
        HashSet<SnapshotId> currentlyRunning = new HashSet<SnapshotId>();
        Iterable entriesByRepo = snapshots.entriesByRepo();
        for (List entriesForRepo : entriesByRepo) {
            for (SnapshotsInProgress.Entry entry : entriesForRepo) {
                currentlyRunning.add(entry.snapshot().getSnapshotId());
            }
        }
        return currentlyRunning;
    }

    static SnapshotInvocationRecord buildFailedSnapshotRecord(SnapshotId snapshot) {
        return new SnapshotInvocationRecord(snapshot.getName(), null, Instant.now().toEpochMilli(), String.format(Locale.ROOT, "found registered snapshot [%s] which is no longer running, assuming failed.", snapshot.getName()));
    }

    static SnapshotInvocationRecord buildSnapshotRecord(SnapshotInfo snapshotInfo, @Nullable String details) {
        return new SnapshotInvocationRecord(snapshotInfo.snapshotId().getName(), Long.valueOf(snapshotInfo.startTime()), snapshotInfo.endTime(), details);
    }

    static boolean isSnapshotSuccessful(SnapshotInfo snapshotInfo) {
        return snapshotInfo.state() != null && snapshotInfo.state().completed() && snapshotInfo.failedShards() == 0;
    }

    static class WriteJobStatus
    extends ClusterStateUpdateTask {
        private final ProjectId projectId;
        private final String policyName;
        private final SnapshotId snapshotId;
        private final long snapshotStartTime;
        private final long snapshotFinishTime;
        private final Optional<Exception> exception;
        private final List<SnapshotInfo> registeredSnapshotInfo;

        private WriteJobStatus(ProjectId projectId, String policyName, SnapshotId snapshotId, long snapshotStartTime, long snapshotFinishTime, List<SnapshotInfo> registeredSnapshotInfo, Optional<Exception> exception) {
            this.projectId = projectId;
            this.policyName = policyName;
            this.snapshotId = snapshotId;
            this.exception = exception;
            this.snapshotStartTime = snapshotStartTime;
            this.snapshotFinishTime = snapshotFinishTime;
            this.registeredSnapshotInfo = registeredSnapshotInfo;
        }

        static WriteJobStatus success(ProjectId projectId, String policyId, SnapshotId snapshotId, long snapshotStartTime, long snapshotFinishTime, List<SnapshotInfo> registeredSnapshotInfo) {
            return new WriteJobStatus(projectId, policyId, snapshotId, snapshotStartTime, snapshotFinishTime, registeredSnapshotInfo, Optional.empty());
        }

        static WriteJobStatus failure(ProjectId projectId, String policyId, SnapshotId snapshotId, long timestamp, List<SnapshotInfo> registeredSnapshotInfo, Exception exception) {
            return new WriteJobStatus(projectId, policyId, snapshotId, timestamp, timestamp, registeredSnapshotInfo, Optional.of(exception));
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            ProjectMetadata project = currentState.metadata().getProject(this.projectId);
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)project.custom("snapshot_lifecycle", (Metadata.ProjectCustom)SnapshotLifecycleMetadata.EMPTY);
            RegisteredPolicySnapshots registeredSnapshots = (RegisteredPolicySnapshots)project.custom("registered_snapshots", (Metadata.ProjectCustom)RegisteredPolicySnapshots.EMPTY);
            HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
            SnapshotLifecyclePolicyMetadata policyMetadata = (SnapshotLifecyclePolicyMetadata)snapLifecycles.get(this.policyName);
            if (policyMetadata == null) {
                logger.warn("failed to record snapshot [{}] for snapshot [{}] in policy [{}]: policy not found", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotId.getName(), (Object)this.policyName);
                return currentState;
            }
            Map snapshotInfoById = this.registeredSnapshotInfo.stream().collect(Collectors.toMap(SnapshotInfo::snapshotId, Function.identity()));
            SnapshotLifecyclePolicyMetadata.Builder newPolicyMetadata = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)policyMetadata);
            SnapshotLifecycleStats newStats = snapMeta.getStats();
            boolean snapshotIsRegistered = registeredSnapshots.contains(this.snapshotId);
            if (!snapshotIsRegistered) {
                logger.warn("Snapshot [{}] not found in registered set after snapshot completion. This means snapshot was recorded as a failure by another snapshot's cleanup run.", (Object)this.snapshotId.getName());
            }
            Set<SnapshotId> runningSnapshots = SnapshotLifecycleTask.currentlyRunningSnapshots(currentState);
            ArrayList<RegisteredPolicySnapshots.PolicySnapshot> newRegistered = new ArrayList<RegisteredPolicySnapshots.PolicySnapshot>();
            for (RegisteredPolicySnapshots.PolicySnapshot registeredSnapshot : registeredSnapshots.getSnapshots()) {
                SnapshotId registeredSnapshotId = registeredSnapshot.getSnapshotId();
                if (registeredSnapshotId.equals((Object)this.snapshotId) || !snapLifecycles.containsKey(registeredSnapshot.getPolicy())) continue;
                if (!registeredSnapshot.getPolicy().equals(this.policyName) || runningSnapshots.contains(registeredSnapshotId)) {
                    newRegistered.add(registeredSnapshot);
                    continue;
                }
                SnapshotInfo snapshotInfo = (SnapshotInfo)snapshotInfoById.get(registeredSnapshotId);
                if (snapshotInfo != null) {
                    if (SnapshotLifecycleTask.isSnapshotSuccessful(snapshotInfo)) {
                        newStats = newStats.withTakenIncremented(this.policyName);
                        newPolicyMetadata.setInvocationsSinceLastSuccess(0L).setLastSuccess(SnapshotLifecycleTask.buildSnapshotRecord(snapshotInfo, null));
                        continue;
                    }
                    newStats = newStats.withFailedIncremented(this.policyName);
                    newPolicyMetadata.incrementInvocationsSinceLastSuccess().setLastFailure(SnapshotLifecycleTask.buildSnapshotRecord(snapshotInfo, Strings.format((String)"found failed snapshot [%s] in the registered SLM snapshot set", (Object[])new Object[]{snapshotInfo.snapshotId().getName()})));
                    continue;
                }
                newStats = newStats.withFailedIncremented(this.policyName);
                newPolicyMetadata.incrementInvocationsSinceLastSuccess().setLastFailure(SnapshotLifecycleTask.buildFailedSnapshotRecord(registeredSnapshotId));
            }
            if (this.exception.isPresent()) {
                newStats = newStats.withFailedIncremented(this.policyName);
                newPolicyMetadata.setLastFailure(new SnapshotInvocationRecord(this.snapshotId.getName(), null, this.snapshotFinishTime, (String)this.exception.map(SnapshotLifecycleTask::exceptionToString).orElse(null)));
                if (snapshotIsRegistered) {
                    newPolicyMetadata.incrementInvocationsSinceLastSuccess();
                }
            } else {
                newStats = newStats.withTakenIncremented(this.policyName);
                newPolicyMetadata.setLastSuccess(new SnapshotInvocationRecord(this.snapshotId.getName(), Long.valueOf(this.snapshotStartTime), this.snapshotFinishTime, null));
                newPolicyMetadata.setInvocationsSinceLastSuccess(0L);
            }
            snapLifecycles.put(this.policyName, newPolicyMetadata.build());
            SnapshotLifecycleMetadata lifecycleMetadata = new SnapshotLifecycleMetadata(snapLifecycles, LifecycleOperationMetadata.currentSLMMode((ProjectMetadata)project), newStats);
            return currentState.copyAndUpdateProject(project.id(), builder -> builder.putCustom("snapshot_lifecycle", (Metadata.ProjectCustom)lifecycleMetadata).putCustom("registered_snapshots", (Metadata.ProjectCustom)new RegisteredPolicySnapshots(newRegistered)));
        }

        public void onFailure(Exception e) {
            logger.log(e instanceof NotMasterException ? Level.INFO : Level.ERROR, Strings.format((String)"failed to record snapshot policy execution status [%s] for snapshot [%s] in policy [%s]", (Object[])new Object[]{this.exception.isPresent() ? "failure" : "success", this.snapshotId.getName(), this.policyName}), (Throwable)e);
        }
    }
}

