/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.util.Locale;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.index.Index;

public class WatchStoreUtils {
    public static IndexMetadata getConcreteIndex(String name, Metadata metadata) {
        ProjectMetadata projectMetadata = metadata.getProject(ProjectId.DEFAULT);
        IndexAbstraction indexAbstraction = (IndexAbstraction)projectMetadata.getIndicesLookup().get(name);
        if (indexAbstraction == null) {
            return null;
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && indexAbstraction.getIndices().size() > 1 && indexAbstraction.getWriteIndex() == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Alias [%s] points to %d indices, and does not have a designated write index", name, indexAbstraction.getIndices().size()));
        }
        Index concreteIndex = indexAbstraction.getWriteIndex();
        if (concreteIndex == null) {
            concreteIndex = (Index)indexAbstraction.getIndices().get(indexAbstraction.getIndices().size() - 1);
        }
        return projectMetadata.index(concreteIndex);
    }
}

