/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;

public class ExecutableHttpInput
extends ExecutableInput<HttpInput, HttpInput.Result> {
    private static final Logger logger = LogManager.getLogger(ExecutableHttpInput.class);
    private final HttpClient client;
    private final TextTemplateEngine templateEngine;

    public ExecutableHttpInput(HttpInput input, HttpClient client, TextTemplateEngine templateEngine) {
        super((Input)input);
        this.client = client;
        this.templateEngine = templateEngine;
    }

    public HttpInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        HttpRequest request = null;
        try {
            Map<String, Object> model = Variables.createCtxParamsMap(ctx, payload);
            request = ((HttpInput)this.input).getRequest().render(this.templateEngine, model);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            logger.error(() -> Strings.format((String)"failed to execute [%s] input for watch [%s]", (Object[])new Object[]{"http", ctx.watch().id()}), (Throwable)e);
            return new HttpInput.Result(request, e);
        }
    }

    HttpInput.Result doExecute(WatchExecutionContext ctx, HttpRequest request) throws Exception {
        XContentType contentType;
        HttpResponse response = this.client.execute(request);
        Map<String, List<String>> headers = response.headers();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("_status_code", response.status());
        if (!headers.isEmpty()) {
            payloadMap.put("_headers", headers);
        }
        if (!response.hasContent()) {
            return new HttpInput.Result(request, response.status(), (Payload)new Payload.Simple(payloadMap));
        }
        XContentType responseContentType = response.xContentType();
        if (((HttpInput)this.input).getExpectedResponseXContentType() == null) {
            contentType = responseContentType != null ? responseContentType : XContentHelper.xContentType((BytesReference)response.body());
        } else {
            contentType = ((HttpInput)this.input).getExpectedResponseXContentType().contentType();
            if (responseContentType != contentType) {
                logger.warn("[{}] [{}] input expected content type [{}] but read [{}] from headers, using expected one", (Object)this.type(), (Object)ctx.id(), (Object)((HttpInput)this.input).getExpectedResponseXContentType(), (Object)responseContentType);
            }
        }
        if (contentType != null) {
            try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)response.body(), (XContentType)contentType);){
                if (((HttpInput)this.input).getExtractKeys() != null) {
                    payloadMap.putAll(XContentFilterKeysUtils.filterMapOrdered(((HttpInput)this.input).getExtractKeys(), parser));
                }
                XContentParser.Token token = parser.nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    payloadMap.put("data", parser.listOrderedMap());
                }
                payloadMap.putAll(parser.mapOrdered());
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("could not parse response body [{}] it does not appear to be [{}]", new Object[]{this.type(), ctx.id(), response.body().utf8ToString(), contentType.queryParameter()});
            }
        } else {
            payloadMap.put("_value", response.body().utf8ToString());
        }
        return new HttpInput.Result(request, response.status(), (Payload)new Payload.Simple(payloadMap));
    }
}

