/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.parser;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.support.NestedScope;

public class KqlParsingContext {
    private static final List<String> IGNORED_METADATA_FIELDS = List.of("_seq_no", "_index_mode", "_routing", "_ignored", "_nested_path", "_field_names");
    private final QueryRewriteContext queryRewriteContext;
    private final boolean caseInsensitive;
    private final ZoneId timeZone;
    private final String defaultField;
    private final NestedScope nestedScope = new NestedScope();

    public static Builder builder(QueryRewriteContext queryRewriteContext) {
        return new Builder(queryRewriteContext);
    }

    public KqlParsingContext(QueryRewriteContext queryRewriteContext, boolean caseInsensitive, ZoneId timeZone, String defaultField) {
        this.queryRewriteContext = queryRewriteContext;
        this.caseInsensitive = caseInsensitive;
        this.timeZone = timeZone;
        this.defaultField = defaultField;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public String nestedPath(String fieldName) {
        return this.nestedLookup().getNestedParent(fieldName);
    }

    public boolean isNestedField(String fieldName) {
        return this.nestedMappers().containsKey(this.fullFieldName(fieldName));
    }

    public Set<String> resolveFieldNames(String fieldNamePattern) {
        assert (fieldNamePattern != null && !fieldNamePattern.isEmpty()) : "fieldNamePattern cannot be null or empty";
        return this.queryRewriteContext.getMatchingFieldNames(this.fullFieldName(fieldNamePattern));
    }

    public Set<String> resolveDefaultFieldNames() {
        if (this.defaultField != null) {
            return this.resolveFieldNames(this.defaultField);
        }
        assert (this.queryRewriteContext.getIndexSettings() != null);
        if (this.queryRewriteContext.getIndexSettings().getDefaultFields().isEmpty()) {
            return this.resolveFieldNames("*");
        }
        HashSet<String> fieldNames = new HashSet<String>();
        this.queryRewriteContext.getIndexSettings().getDefaultFields().forEach(fieldNamePattern -> fieldNames.addAll(this.resolveFieldNames((String)fieldNamePattern)));
        return fieldNames;
    }

    public MappedFieldType fieldType(String fieldName) {
        return this.queryRewriteContext.getFieldType(fieldName);
    }

    public static boolean isRuntimeField(MappedFieldType fieldType) {
        return fieldType instanceof AbstractScriptFieldType;
    }

    public boolean isDateField(String fieldName) {
        return KqlParsingContext.isDateField(this.fieldType(fieldName));
    }

    public boolean isRangeField(String fieldName) {
        return this.fieldType(fieldName) != null && this.fieldType(fieldName) instanceof RangeFieldMapper.RangeFieldType;
    }

    public static boolean isDateField(MappedFieldType fieldType) {
        return fieldType.typeName().equals("date") || fieldType.typeName().equals("date_nanos");
    }

    public static boolean isKeywordField(MappedFieldType fieldType) {
        return fieldType.typeName().equals("keyword");
    }

    public static boolean isSearchableField(String fieldName, MappedFieldType fieldType) {
        return !IGNORED_METADATA_FIELDS.contains(fieldName) && fieldType.isSearchable();
    }

    public boolean isSearchableField(String fieldName) {
        return KqlParsingContext.isSearchableField(fieldName, this.fieldType(fieldName));
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public <T> T withNestedPath(String nestedFieldName, Supplier<T> supplier) {
        assert (this.isNestedField(nestedFieldName));
        this.nestedScope.nextLevel(this.nestedMappers().get(this.fullFieldName(nestedFieldName)));
        T result = supplier.get();
        this.nestedScope.previousLevel();
        return result;
    }

    public String currentNestedPath() {
        return this.nestedScope().getObjectMapper() != null ? this.nestedScope().getObjectMapper().fullPath() : null;
    }

    public String fullFieldName(String fieldName) {
        if (this.nestedScope.getObjectMapper() == null) {
            return fieldName;
        }
        return Strings.format((String)"%s.%s", (Object[])new Object[]{this.nestedScope.getObjectMapper().fullPath(), fieldName});
    }

    private NestedLookup nestedLookup() {
        return this.queryRewriteContext.getMappingLookup().nestedLookup();
    }

    private Map<String, NestedObjectMapper> nestedMappers() {
        return this.nestedLookup().getNestedMappers();
    }

    public static class Builder {
        private final QueryRewriteContext queryRewriteContext;
        private boolean caseInsensitive = false;
        private ZoneId timeZone = null;
        private String defaultField = null;

        private Builder(QueryRewriteContext queryRewriteContext) {
            this.queryRewriteContext = queryRewriteContext;
        }

        public KqlParsingContext build() {
            return new KqlParsingContext(this.queryRewriteContext, this.caseInsensitive, this.timeZone, this.defaultField);
        }

        public Builder caseInsensitive(boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this;
        }

        public Builder timeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder defaultField(String defaultField) {
            this.defaultField = defaultField;
            return this;
        }
    }
}

