/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.Constants;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.elasticsearch.Build;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.plugin.scanner.ClassReaders;
import org.elasticsearch.plugin.scanner.NamedComponentScanner;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginsUtils;
import org.elasticsearch.plugins.cli.InstallablePlugin;
import org.elasticsearch.plugins.cli.PluginSecurity;
import org.elasticsearch.plugins.cli.ProgressInputStream;

public class InstallPluginAction
implements Closeable {
    private static final String PROPERTY_STAGING_ID = "es.plugins.staging";
    static final int PLUGIN_EXISTS = 1;
    static final int PLUGIN_MALFORMED = 2;
    private static final Set<String> MODULES;
    public static final Set<String> OFFICIAL_PLUGINS;
    public static final Set<String> PLUGINS_CONVERTED_TO_MODULES;
    static final Set<PosixFilePermission> BIN_DIR_PERMS;
    static final Set<PosixFilePermission> BIN_FILES_PERMS;
    static final Set<PosixFilePermission> CONFIG_DIR_PERMS;
    static final Set<PosixFilePermission> CONFIG_FILES_PERMS;
    static final Set<PosixFilePermission> PLUGIN_DIR_PERMS;
    static final Set<PosixFilePermission> PLUGIN_FILES_PERMS;
    private final Terminal terminal;
    private Environment env;
    private boolean batch;
    private Proxy proxy = null;
    private static final String LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR;
    private final List<Path> pathsToDeleteOnShutdown = new ArrayList<Path>();

    public InstallPluginAction(Terminal terminal, Environment env, boolean batch) {
        this.terminal = terminal;
        this.env = env;
        this.batch = batch;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void execute(List<InstallablePlugin> plugins) throws Exception {
        if (plugins.isEmpty()) {
            throw new UserException(64, "at least one plugin id is required");
        }
        HashSet<String> uniquePluginIds = new HashSet<String>();
        for (InstallablePlugin plugin : plugins) {
            if (uniquePluginIds.add(plugin.getId())) continue;
            throw new UserException(64, "duplicate plugin id [" + plugin.getId() + "]");
        }
        String logPrefix = this.terminal.isHeadless() ? "" : "-> ";
        LinkedHashMap<String, ArrayList<Path>> deleteOnFailures = new LinkedHashMap<String, ArrayList<Path>>();
        for (InstallablePlugin plugin : plugins) {
            String pluginId = plugin.getId();
            this.terminal.println((CharSequence)(logPrefix + "Installing " + pluginId));
            try {
                if ("x-pack".equals(pluginId)) {
                    throw new UserException(78, "this distribution of Elasticsearch contains X-Pack by default");
                }
                if (PLUGINS_CONVERTED_TO_MODULES.contains(pluginId)) {
                    this.terminal.errorPrintln("[" + pluginId + "] is no longer a plugin but instead a module packaged with this distribution of Elasticsearch");
                    continue;
                }
                ArrayList<Path> deleteOnFailure = new ArrayList<Path>();
                deleteOnFailures.put(pluginId, deleteOnFailure);
                Path pluginZip = this.download(plugin, this.env.tmpDir());
                Path extractedZip = this.unzip(pluginZip, this.env.pluginsDir());
                deleteOnFailure.add(extractedZip);
                PluginDescriptor pluginDescriptor = this.installPlugin(plugin, extractedZip, deleteOnFailure);
                this.terminal.println((CharSequence)(logPrefix + "Installed " + pluginDescriptor.getName()));
                deleteOnFailures.remove(pluginId);
                deleteOnFailures.put(pluginDescriptor.getName(), deleteOnFailure);
            }
            catch (Exception installProblem) {
                this.terminal.println((CharSequence)(logPrefix + "Failed installing " + pluginId));
                for (Map.Entry deleteOnFailureEntry : deleteOnFailures.entrySet()) {
                    this.terminal.println((CharSequence)(logPrefix + "Rolling back " + (String)deleteOnFailureEntry.getKey()));
                    boolean success = false;
                    try {
                        IOUtils.rm((Path[])((List)deleteOnFailureEntry.getValue()).toArray(new Path[0]));
                        success = true;
                    }
                    catch (IOException exceptionWhileRemovingFiles) {
                        Exception exception = new Exception("failed rolling back installation of [" + (String)deleteOnFailureEntry.getKey() + "]", exceptionWhileRemovingFiles);
                        installProblem.addSuppressed(exception);
                        this.terminal.println((CharSequence)(logPrefix + "Failed rolling back " + (String)deleteOnFailureEntry.getKey()));
                    }
                    if (!success) continue;
                    this.terminal.println((CharSequence)(logPrefix + "Rolled back " + (String)deleteOnFailureEntry.getKey()));
                }
                throw installProblem;
            }
        }
        if (!this.terminal.isHeadless()) {
            this.terminal.println((CharSequence)"-> Please restart Elasticsearch to activate any plugins installed");
        }
    }

    private Path download(InstallablePlugin plugin, Path tmpDir) throws Exception {
        String logPrefix;
        String pluginId = plugin.getId();
        String string = logPrefix = this.terminal.isHeadless() ? "" : "-> ";
        if (OFFICIAL_PLUGINS.contains(pluginId) && (plugin.getLocation() == null || plugin.getLocation().equals(pluginId))) {
            Path pluginPath;
            String pluginArchiveDir = System.getenv("ES_PLUGIN_ARCHIVE_DIR");
            if (pluginArchiveDir != null && !pluginArchiveDir.isEmpty() && Files.exists(pluginPath = this.getPluginArchivePath(pluginId, pluginArchiveDir), new LinkOption[0])) {
                this.terminal.println((CharSequence)(logPrefix + "Downloading " + pluginId + " from local archive: " + pluginArchiveDir));
                return this.downloadZip("file://" + String.valueOf(pluginPath), tmpDir);
            }
            String url = this.getElasticUrl(this.getStagingHash(), this.isSnapshot(), pluginId, Platforms.PLATFORM_NAME);
            this.terminal.println((CharSequence)(logPrefix + "Downloading " + pluginId + " from elastic"));
            return this.downloadAndValidate(url, tmpDir, true);
        }
        String pluginLocation = plugin.getLocation();
        String[] coordinates = pluginLocation.split(":");
        if (coordinates.length == 3 && !pluginLocation.contains("/") && !pluginLocation.startsWith("file:")) {
            String mavenUrl = this.getMavenUrl(coordinates);
            this.terminal.println((CharSequence)(logPrefix + "Downloading " + pluginId + " from maven central"));
            return this.downloadAndValidate(mavenUrl, tmpDir, false);
        }
        if (!pluginLocation.contains(":")) {
            List<String> pluginSuggestions = InstallPluginAction.checkMisspelledPlugin(pluginId);
            String msg = "Unknown plugin " + pluginId;
            if (!pluginSuggestions.isEmpty()) {
                msg = msg + ", did you mean " + (pluginSuggestions.size() > 1 ? "any of " : "") + String.valueOf(pluginSuggestions) + "?";
            }
            throw new UserException(64, msg);
        }
        this.verifyLocationNotInPluginsDirectory(pluginLocation);
        this.terminal.println((CharSequence)(logPrefix + "Downloading " + URLDecoder.decode(pluginLocation, StandardCharsets.UTF_8)));
        return this.downloadZip(pluginLocation, tmpDir);
    }

    @SuppressForbidden(reason="Need to use Paths#get")
    private void verifyLocationNotInPluginsDirectory(String pluginLocation) throws URISyntaxException, IOException, UserException {
        Path pluginsDirectory;
        Path pluginRealPath;
        if (pluginLocation == null) {
            return;
        }
        URI uri = new URI(pluginLocation);
        if ("file".equalsIgnoreCase(uri.getScheme()) && (pluginRealPath = Paths.get(uri).toRealPath(new LinkOption[0])).startsWith(pluginsDirectory = this.env.pluginsDir().toRealPath(new LinkOption[0]))) {
            throw new UserException(64, "Installation of plugin in location [" + pluginLocation + "] from inside the plugins directory is not permitted.");
        }
    }

    @SuppressForbidden(reason="Need to use PathUtils#get")
    private Path getPluginArchivePath(String pluginId, String pluginArchiveDir) throws UserException {
        Path path = PathUtils.get((String)pluginArchiveDir, (String[])new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new UserException(78, "Location in ES_PLUGIN_ARCHIVE_DIR does not exist");
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new UserException(78, "Location in ES_PLUGIN_ARCHIVE_DIR is not a directory");
        }
        return PathUtils.get((String)pluginArchiveDir, (String[])new String[]{pluginId + "-" + Build.current().qualifiedVersion() + ".zip"});
    }

    String getStagingHash() {
        return System.getProperty(PROPERTY_STAGING_ID);
    }

    boolean isSnapshot() {
        return Build.current().isSnapshot();
    }

    private String getElasticUrl(String stagingHash, boolean isSnapshot, String pluginId, String platform) throws IOException, UserException {
        if (isSnapshot && stagingHash == null) {
            throw new UserException(78, "attempted to install release build of official plugin on snapshot build of Elasticsearch");
        }
        String semanticVersion = InstallPluginAction.getSemanticVersion(Build.current().version());
        if (semanticVersion == null) {
            throw new UserException(78, "attempted to download a plugin for a non-semantically-versioned build of Elasticsearch: [" + Build.current().version() + "]");
        }
        String baseUrl = stagingHash != null ? (isSnapshot ? InstallPluginAction.nonReleaseUrl("snapshots", semanticVersion, stagingHash, pluginId) : InstallPluginAction.nonReleaseUrl("staging", semanticVersion, stagingHash, pluginId)) : String.format(Locale.ROOT, "https://artifacts.elastic.co/downloads/elasticsearch-plugins/%s", pluginId);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, pluginId, platform, Build.current().qualifiedVersion());
        if (this.urlExists(platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, pluginId, Build.current().qualifiedVersion());
    }

    private static String nonReleaseUrl(String hostname, String version, String stagingHash, String pluginId) {
        return String.format(Locale.ROOT, "https://%s.elastic.co/%s-%s/downloads/elasticsearch-plugins/%s", hostname, version, stagingHash, pluginId);
    }

    private String getMavenUrl(String[] coordinates) throws IOException {
        String groupId = coordinates[0].replace(".", "/");
        String artifactId = coordinates[1];
        String version = coordinates[2];
        String baseUrl = String.format(Locale.ROOT, "https://repo1.maven.org/maven2/%s/%s/%s", groupId, artifactId, version);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, artifactId, Platforms.PLATFORM_NAME, version);
        if (this.urlExists(platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, artifactId, version);
    }

    @SuppressForbidden(reason="Make HEAD request using URLConnection.connect()")
    boolean urlExists(String urlString) throws IOException {
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Checking if url exists: " + urlString));
        URL url = new URL(urlString);
        assert ("https".equals(url.getProtocol())) : "Only http urls can be checked";
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        urlConnection.setRequestMethod("HEAD");
        urlConnection.connect();
        return urlConnection.getResponseCode() == 200;
    }

    private static List<String> checkMisspelledPlugin(String pluginId) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple> scoredKeys = new ArrayList<Tuple>();
        for (String officialPlugin : OFFICIAL_PLUGINS) {
            float distance = ld.getDistance(pluginId, officialPlugin);
            if (!(distance > 0.7f)) continue;
            scoredKeys.add(new Tuple((Object)Float.valueOf(distance), (Object)officialPlugin));
        }
        CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredKeys.stream().map(Tuple::v2).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="We use getInputStream to download plugins")
    Path downloadZip(String urlString, Path tmpDir) throws IOException, URISyntaxException {
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Retrieving zip from " + urlString));
        URL url = new URI(urlString).toURL();
        Path zip = Files.createTempFile(tmpDir, null, ".zip", new FileAttribute[0]);
        URLConnection urlConnection = this.proxy == null ? url.openConnection() : url.openConnection(this.proxy);
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        try (InputStream in = this.batch || this.terminal.isHeadless() ? urlConnection.getInputStream() : new TerminalProgressInputStream(urlConnection.getInputStream(), urlConnection.getContentLength(), this.terminal);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        return zip;
    }

    void setEnvironment(Environment environment) {
        this.env = environment;
    }

    void setBatch(boolean batch) {
        this.batch = batch;
    }

    @SuppressForbidden(reason="URL#openStream")
    private InputStream urlOpenStream(URL url) throws IOException {
        return this.proxy == null ? url.openStream() : url.openConnection(this.proxy).getInputStream();
    }

    private Path downloadAndValidate(String urlString, Path tmpDir, boolean officialPlugin) throws IOException, PGPException, UserException, URISyntaxException {
        String expectedChecksum;
        Path zip = this.downloadZip(urlString, tmpDir);
        this.pathsToDeleteOnShutdown.add(zip);
        String checksumUrlString = urlString + ".sha512";
        URL checksumUrl = this.openUrl(checksumUrlString);
        String digestAlgo = "SHA-512";
        if (checksumUrl == null && !officialPlugin) {
            this.terminal.println((CharSequence)"Warning: sha512 not found, falling back to sha1. This behavior is deprecated and will be removed in a future release. Please update the plugin to use a sha512 checksum.");
            checksumUrlString = urlString + ".sha1";
            checksumUrl = this.openUrl(checksumUrlString);
            digestAlgo = "SHA-1";
        }
        if (checksumUrl == null) {
            throw new UserException(74, "Plugin checksum missing: " + checksumUrlString);
        }
        try (InputStream in = this.urlOpenStream(checksumUrl);){
            BufferedReader checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            if (digestAlgo.equals("SHA-1")) {
                expectedChecksum = checksumReader.readLine();
            } else {
                String[] segments;
                String expectedFile;
                String checksumLine = checksumReader.readLine();
                String[] fields = checksumLine.split(" {2}");
                if (officialPlugin && fields.length != 2 || !officialPlugin && fields.length > 2) {
                    throw new UserException(74, "Invalid checksum file at " + String.valueOf(checksumUrl));
                }
                expectedChecksum = fields[0];
                if (fields.length == 2 && !fields[1].equals(expectedFile = (segments = URI.create(urlString).getPath().split("/"))[segments.length - 1])) {
                    String message = String.format(Locale.ROOT, "checksum file at [%s] is not for this plugin, expected [%s] but was [%s]", checksumUrl, expectedFile, fields[1]);
                    throw new UserException(74, message);
                }
            }
            if (checksumReader.readLine() != null) {
                throw new UserException(74, "Invalid checksum file at " + String.valueOf(checksumUrl));
            }
        }
        try (InputStream zis = Files.newInputStream(zip, new OpenOption[0]);){
            try {
                int read;
                MessageDigest digest = MessageDigest.getInstance(digestAlgo);
                byte[] bytes = new byte[8192];
                while ((read = zis.read(bytes)) != -1) {
                    assert (read > 0) : read;
                    digest.update(bytes, 0, read);
                }
                String actualChecksum = MessageDigests.toHexString((byte[])digest.digest());
                if (!expectedChecksum.equals(actualChecksum)) {
                    throw new UserException(74, digestAlgo + " mismatch, expected " + expectedChecksum + " but got " + actualChecksum);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (officialPlugin) {
            this.verifySignature(zip, urlString);
        }
        return zip;
    }

    void verifySignature(Path zip, String urlString) throws IOException, PGPException {
        String ascUrlString = urlString + ".asc";
        URL ascUrl = this.openUrl(ascUrlString);
        try (InputStream fin = this.pluginZipInputStream(zip);
             InputStream sin = this.urlOpenStream(ascUrl);
             ArmoredInputStream ain = new ArmoredInputStream(this.getPublicKey());){
            JcaPGPObjectFactory factory = new JcaPGPObjectFactory(PGPUtil.getDecoderStream((InputStream)sin));
            PGPSignature signature = ((PGPSignatureList)factory.nextObject()).get(0);
            String keyId = Long.toHexString(signature.getKeyID()).toUpperCase(Locale.ROOT);
            if (!this.getPublicKeyId().equals(keyId)) {
                throw new IllegalStateException("key id [" + keyId + "] does not match expected key id [" + this.getPublicKeyId() + "]");
            }
            this.timedComputeSignatureForDownloadedPlugin(fin, (InputStream)ain, signature);
            if (!signature.verify()) {
                throw new IllegalStateException("signature verification for [" + urlString + "] failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timedComputeSignatureForDownloadedPlugin(InputStream fin, InputStream ain, PGPSignature signature) throws PGPException, IOException {
        Timer timer = new Timer();
        try {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    InstallPluginAction.this.reportLongSignatureVerification();
                }
            }, this.acceptableSignatureVerificationDelay());
            this.computeSignatureForDownloadedPlugin(fin, ain, signature);
        }
        finally {
            timer.cancel();
        }
    }

    void computeSignatureForDownloadedPlugin(InputStream fin, InputStream ain, PGPSignature signature) throws PGPException, IOException {
        int read;
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(ain, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey key = collection.getPublicKey(signature.getKeyID());
        signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)new BouncyCastleFipsProvider()), key);
        byte[] buffer = new byte[1024];
        while ((read = fin.read(buffer)) != -1) {
            signature.update(buffer, 0, read);
        }
    }

    void reportLongSignatureVerification() {
        this.terminal.println((CharSequence)("The plugin installer is trying to verify the signature of the downloaded plugin but this verification is taking longer than expected. This is often because the plugin installer is waiting for your system to supply it with random numbers. " + (!System.getProperty("os.name").startsWith("Windows") ? "Ensure that your system has sufficient entropy so that reads from /dev/random do not block." : "")));
    }

    long acceptableSignatureVerificationDelay() {
        return 5000L;
    }

    InputStream pluginZipInputStream(Path zip) throws IOException {
        return Files.newInputStream(zip, new OpenOption[0]);
    }

    String getPublicKeyId() {
        return "D27D666CD88E42B4";
    }

    InputStream getPublicKey() {
        return InstallPluginAction.class.getResourceAsStream("/public_key.asc");
    }

    URL openUrl(String urlString) throws IOException {
        HttpURLConnection connection;
        URL checksumUrl = new URL(urlString);
        HttpURLConnection httpURLConnection = connection = this.proxy == null ? (HttpURLConnection)checksumUrl.openConnection() : (HttpURLConnection)checksumUrl.openConnection(this.proxy);
        if (connection.getResponseCode() == 404) {
            return null;
        }
        return checksumUrl;
    }

    private Path unzip(Path zip, Path pluginsDir) throws IOException, UserException {
        Path target = InstallPluginAction.stagingDirectory(pluginsDir);
        this.pathsToDeleteOnShutdown.add(target);
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.getName().startsWith("elasticsearch/")) {
                    throw new UserException(2, "This plugin was built with an older plugin structure. Contact the plugin author to remove the intermediate \"elasticsearch\" directory within the plugin zip.");
                }
                Path targetFile = target.resolve(entry.getName());
                if (!targetFile.normalize().startsWith(target)) {
                    throw new UserException(2, "Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        catch (UserException e) {
            IOUtils.rm((Path[])new Path[]{target});
            throw e;
        }
        Files.delete(zip);
        return target;
    }

    private static Path stagingDirectory(Path pluginsDir) throws IOException {
        try {
            return Files.createTempDirectory(pluginsDir, ".installing-", PosixFilePermissions.asFileAttribute(PLUGIN_DIR_PERMS));
        }
        catch (UnsupportedOperationException e) {
            return InstallPluginAction.stagingDirectoryWithoutPosixPermissions(pluginsDir);
        }
    }

    private static Path stagingDirectoryWithoutPosixPermissions(Path pluginsDir) throws IOException {
        return Files.createTempDirectory(pluginsDir, ".installing-", new FileAttribute[0]);
    }

    private static void verifyPluginName(Path pluginPath, String pluginName) throws UserException, IOException {
        if (MODULES.contains(pluginName)) {
            throw new UserException(64, "plugin '" + pluginName + "' cannot be installed as a plugin, it is a system module");
        }
        Path destination = pluginPath.resolve(pluginName);
        if (Files.exists(destination, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin directory [%s] already exists; if you need to update the plugin, uninstall it first using command 'remove %s'", destination, pluginName);
            throw new UserException(1, message);
        }
    }

    private PluginDescriptor loadPluginInfo(Path pluginRoot) throws Exception {
        PluginDescriptor info = PluginDescriptor.readFromProperties((Path)pluginRoot);
        if (info.hasNativeController()) {
            throw new IllegalStateException("plugins can not have native controllers");
        }
        PluginsUtils.verifyCompatibility((PluginDescriptor)info);
        InstallPluginAction.verifyPluginName(this.env.pluginsDir(), info.getName());
        PluginsUtils.checkForFailedPluginRemovals((Path)this.env.pluginsDir());
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)info.toString());
        this.jarHellCheck(info, pluginRoot, this.env.pluginsDir(), this.env.modulesDir());
        if (info.isStable() && !InstallPluginAction.hasNamedComponentFile(pluginRoot)) {
            InstallPluginAction.generateNameComponentFile(pluginRoot);
        }
        return info;
    }

    private static void generateNameComponentFile(Path pluginRoot) throws IOException {
        Stream classPath = ClassReaders.ofClassPath().stream();
        List classReaders = Stream.concat(ClassReaders.ofDirWithJars((Path)pluginRoot).stream(), classPath).toList();
        Map namedComponentsMap = NamedComponentScanner.scanForNamedClasses(classReaders);
        Path outputFile = pluginRoot.resolve("named_components.json");
        NamedComponentScanner.writeToFile((Map)namedComponentsMap, (Path)outputFile);
    }

    private static boolean hasNamedComponentFile(Path pluginRoot) {
        return Files.exists(pluginRoot.resolve("named_components.json"), new LinkOption[0]);
    }

    void jarHellCheck(PluginDescriptor candidateInfo, Path candidateDir, Path pluginsDir, Path modulesDir) throws Exception {
        Set classpath = JarHell.parseClassPath().stream().filter(url -> {
            try {
                return !url.toURI().getPath().matches(LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
        PluginsUtils.preInstallJarHellCheck((PluginDescriptor)candidateInfo, (Path)candidateDir, (Path)pluginsDir, (Path)modulesDir, classpath);
    }

    private PluginDescriptor installPlugin(InstallablePlugin descriptor, Path tmpRoot, List<Path> deleteOnFailure) throws Exception {
        PluginDescriptor info = this.loadPluginInfo(tmpRoot);
        Path legacyPolicyFile = tmpRoot.resolve("plugin-security.policy");
        if (Files.exists(legacyPolicyFile, new LinkOption[0])) {
            this.terminal.errorPrintln("WARNING: this plugin contains a legacy Security Policy file. Starting with version 8.18, Entitlements replace SecurityManager as the security mechanism. Plugins must migrate their policy files to the new format. For more information, please refer to https://www.elastic.co/guide/en/elasticsearch/plugins/current/creating-classic-plugins.html");
        }
        Policy pluginPolicy = PolicyUtils.parsePolicyIfExists((String)info.getName(), (Path)tmpRoot, (boolean)true);
        Set entitlements = PolicyUtils.getEntitlementsDescriptions((Policy)pluginPolicy);
        PluginSecurity.confirmPolicyExceptions(this.terminal, entitlements, this.batch);
        if (!descriptor.getId().contains(":") && !descriptor.getId().equals(info.getName())) {
            throw new UserException(2, "Expected downloaded plugin to have ID [" + descriptor.getId() + "] but found [" + info.getName() + "]");
        }
        Path destination = this.env.pluginsDir().resolve(info.getName());
        deleteOnFailure.add(destination);
        InstallPluginAction.installPluginSupportFiles(info, tmpRoot, this.env.binDir().resolve(info.getName()), this.env.configDir().resolve(info.getName()), deleteOnFailure);
        InstallPluginAction.movePlugin(tmpRoot, destination);
        return info;
    }

    private static void installPluginSupportFiles(PluginDescriptor info, Path tmpRoot, Path destBinDir, Path destConfigDir, List<Path> deleteOnFailure) throws Exception {
        Path tmpConfigDir;
        Path tmpBinDir = tmpRoot.resolve("bin");
        if (Files.exists(tmpBinDir, new LinkOption[0])) {
            deleteOnFailure.add(destBinDir);
            InstallPluginAction.installBin(info, tmpBinDir, destBinDir);
        }
        if (Files.exists(tmpConfigDir = tmpRoot.resolve("config"), new LinkOption[0])) {
            InstallPluginAction.installConfig(info, tmpConfigDir, destConfigDir);
        }
    }

    private static void movePlugin(Path tmpRoot, Path destination) throws IOException {
        Files.move(tmpRoot, destination, StandardCopyOption.ATOMIC_MOVE);
        Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String parentDirName = file.getParent().getFileName().toString();
                if ("bin".equals(parentDirName) || Constants.MAC_OS_X && "MacOS".equals(parentDirName)) {
                    InstallPluginAction.setFileAttributes(file, BIN_FILES_PERMS);
                } else {
                    InstallPluginAction.setFileAttributes(file, PLUGIN_FILES_PERMS);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                InstallPluginAction.setFileAttributes(dir, PLUGIN_DIR_PERMS);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void installBin(PluginDescriptor info, Path tmpBinDir, Path destBinDir) throws Exception {
        if (!Files.isDirectory(tmpBinDir, new LinkOption[0])) {
            throw new UserException(2, "bin in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destBinDir, new FileAttribute[0]);
        InstallPluginAction.setFileAttributes(destBinDir, BIN_DIR_PERMS);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpBinDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in bin dir for plugin " + info.getName() + ", found " + String.valueOf(srcFile.getFileName()));
                }
                Path destFile = destBinDir.resolve(tmpBinDir.relativize(srcFile));
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginAction.setFileAttributes(destFile, BIN_FILES_PERMS);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpBinDir});
    }

    private static void installConfig(PluginDescriptor info, Path tmpConfigDir, Path destConfigDir) throws Exception {
        PosixFileAttributes destConfigDirAttributes;
        if (!Files.isDirectory(tmpConfigDir, new LinkOption[0])) {
            throw new UserException(2, "config in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destConfigDir, new FileAttribute[0]);
        InstallPluginAction.setFileAttributes(destConfigDir, CONFIG_DIR_PERMS);
        PosixFileAttributeView destConfigDirAttributesView = Files.getFileAttributeView(destConfigDir.getParent(), PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes posixFileAttributes = destConfigDirAttributes = destConfigDirAttributesView != null ? destConfigDirAttributesView.readAttributes() : null;
        if (destConfigDirAttributes != null) {
            InstallPluginAction.setOwnerGroup(destConfigDir, destConfigDirAttributes);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpConfigDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in config dir for plugin " + info.getName());
                }
                Path destFile = destConfigDir.resolve(tmpConfigDir.relativize(srcFile));
                if (Files.exists(destFile, new LinkOption[0])) continue;
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginAction.setFileAttributes(destFile, CONFIG_FILES_PERMS);
                if (destConfigDirAttributes == null) continue;
                InstallPluginAction.setOwnerGroup(destFile, destConfigDirAttributes);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpConfigDir});
    }

    private static void setOwnerGroup(Path path, PosixFileAttributes attributes) throws IOException {
        Objects.requireNonNull(attributes);
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        assert (fileAttributeView != null);
        fileAttributeView.setOwner(attributes.owner());
        fileAttributeView.setGroup(attributes.group());
    }

    private static void setFileAttributes(Path path, Set<PosixFilePermission> permissions) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView != null) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.rm((Path[])this.pathsToDeleteOnShutdown.toArray(new Path[0]));
    }

    static String getSemanticVersion(String version) {
        Matcher matcher = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\D?.*").matcher(version);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static {
        InputStream stream;
        try {
            stream = InstallPluginAction.class.getResourceAsStream("/modules.txt");
            try {
                MODULES = Streams.readAllLines((InputStream)stream).stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            stream = InstallPluginAction.class.getResourceAsStream("/plugins.txt");
            try {
                OFFICIAL_PLUGINS = (Set)Streams.readAllLines((InputStream)stream).stream().map(String::trim).collect(Sets.toUnmodifiableSortedSet());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PLUGINS_CONVERTED_TO_MODULES = Set.of("repository-azure", "repository-gcs", "repository-s3", "ingest-attachment");
        BIN_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-xr-x"));
        BIN_FILES_PERMS = BIN_DIR_PERMS;
        CONFIG_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
        CONFIG_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
        PLUGIN_DIR_PERMS = BIN_DIR_PERMS;
        PLUGIN_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r--r--"));
        LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR = String.format(Locale.ROOT, ".+%1$slib%1$stools%1$splugin-cli%1$s[^%1$s]+\\.jar", "(/|\\\\)");
    }

    private static class TerminalProgressInputStream
    extends ProgressInputStream {
        private static final int WIDTH = 50;
        private final Terminal terminal;
        private final boolean enabled;

        TerminalProgressInputStream(InputStream is, int expectedTotalSize, Terminal terminal) {
            super(is, expectedTotalSize);
            this.terminal = terminal;
            this.enabled = expectedTotalSize > 0;
        }

        @Override
        public void onProgress(int percent) {
            if (this.enabled) {
                int currentPosition = percent * 50 / 100;
                StringBuilder sb = new StringBuilder("\r[");
                sb.append(String.join((CharSequence)"=", Collections.nCopies(currentPosition, "")));
                if (currentPosition > 0 && percent < 100) {
                    sb.append(">");
                }
                sb.append(String.join((CharSequence)" ", Collections.nCopies(50 - currentPosition, "")));
                sb.append("] %s\u00a0\u00a0 ");
                if (percent == 100) {
                    sb.append("\n");
                }
                this.terminal.print(Terminal.Verbosity.NORMAL, String.format(Locale.ROOT, sb.toString(), percent + "%"));
            }
        }
    }
}

