/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.SearchResults;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.invoke.VarHandle;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.LongToIntFunction;

class SearchResultsImpl
implements SearchResults {
    private final List<Map<Integer, Float>> results;

    SearchResultsImpl(List<Map<Integer, Float>> results) {
        this.results = results;
    }

    static SearchResults create(SequenceLayout neighboursSequenceLayout, SequenceLayout distancesSequenceLayout, MemorySegment neighboursMemorySegment, MemorySegment distancesMemorySegment, int topK, LongToIntFunction mapping, long numberOfQueries) {
        LinkedList<Map<Integer, Float>> results = new LinkedList<Map<Integer, Float>>();
        LinkedHashMap<Integer, Float> intermediateResultMap = new LinkedHashMap<Integer, Float>();
        VarHandle neighboursVarHandle = neighboursSequenceLayout.varHandle(MemoryLayout.PathElement.sequenceElement());
        VarHandle distancesVarHandle = distancesSequenceLayout.varHandle(MemoryLayout.PathElement.sequenceElement());
        int count = 0;
        for (long i = 0L; i < (long)topK * numberOfQueries; ++i) {
            long id = neighboursVarHandle.get(neighboursMemorySegment, 0L, i);
            float dst = distancesVarHandle.get(distancesMemorySegment, 0L, i);
            intermediateResultMap.put(mapping != null ? mapping.applyAsInt((int)id) : (int)id, Float.valueOf(dst));
            if (++count != topK) continue;
            results.add(intermediateResultMap);
            intermediateResultMap = new LinkedHashMap();
            count = 0;
        }
        return new SearchResultsImpl(results);
    }

    @Override
    public List<Map<Integer, Float>> getResults() {
        return this.results;
    }
}

