/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.License;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformEffectiveSettings;
import org.elasticsearch.xpack.transform.TransformExtensionHolder;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.utils.SecondaryAuthorizationUtils;
import org.elasticsearch.xpack.transform.utils.SourceDestValidations;

public class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformAction.Request, PreviewTransformAction.Response> {
    private static final int NUMBER_OF_PREVIEW_BUCKETS = 100;
    private final SecurityContext securityContext;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Settings nodeSettings;
    private final SourceDestValidator sourceDestValidator;
    private final Settings destIndexSettings;

    @Inject
    public TransportPreviewTransformAction(TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService, TransformExtensionHolder transformExtensionHolder) {
        super("cluster:admin/transform/preview", transportService, actionFilters, PreviewTransformAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettings = settings;
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), DiscoveryNode.isRemoteClusterClient((Settings)settings) ? new RemoteClusterLicenseChecker(client, null) : null, ingestService, clusterService.getNodeName(), License.OperationMode.BASIC.description());
        this.destIndexSettings = transformExtensionHolder.getTransformExtension().getTransformDestinationIndexSettings();
    }

    protected void doExecute(Task task, PreviewTransformAction.Request request, ActionListener<PreviewTransformAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ClusterState clusterState = this.clusterService.state();
        TransformNodes.throwIfNoTransformNodes(clusterState);
        boolean requiresRemote = request.getConfig().getSource().requiresRemoteCluster();
        if (TransformNodes.redirectToAnotherNodeIfNeeded(clusterState, this.nodeSettings, requiresRemote, this.transportService, this.actionName, request, PreviewTransformAction.Response::new, listener)) {
            return;
        }
        TransformConfig config = request.getConfig();
        Function function = FunctionFactory.create(config);
        ActionListener validateConfigListener = ActionListener.wrap(validateConfigResponse -> this.getPreview(parentTaskId, request.ackTimeout(), config.getId(), function, config.getSource(), config.getDestination().getPipeline(), config.getDestination().getIndex(), config.getSyncConfig(), config.getSettings(), request.previewAsIndexRequest(), listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener validateSourceDestListener = ActionListener.wrap(validateSourceDestResponse -> function.validateConfig((ActionListener<Boolean>)validateConfigListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> this.sourceDestValidator.validate(clusterState, config.getSource().getIndex(), config.getDestination().getIndex(), config.getDestination().getPipeline(), SourceDestValidations.getValidationsForPreview(config.getAdditionalSourceDestValidations()), validateSourceDestListener), arg_0 -> listener.onFailure(arg_0));
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.nodeSettings)).booleanValue()) {
            TransformPrivilegeChecker.checkPrivileges("preview", this.nodeSettings, this.securityContext, this.indexNameExpressionResolver, clusterState, (Client)new ParentTaskAssigningClient(this.client, parentTaskId), config, !"unused-transform-preview-index".equals(config.getDestination().getIndex()), (ActionListener<Void>)checkPrivilegesListener);
        } else {
            checkPrivilegesListener.onResponse(null);
        }
    }

    private void getPreview(TaskId parentTaskId, TimeValue timeout, String transformId, Function function, SourceConfig source, String pipeline, String dest, SyncConfig syncConfig, SettingsConfig settingsConfig, boolean previewAsIndexRequest, ActionListener<PreviewTransformAction.Response> listener) {
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, parentTaskId);
        SetOnce mappings = new SetOnce();
        Map<String, String> filteredHeaders = SecondaryAuthorizationUtils.getSecurityHeadersPreferringSecondary(this.threadPool, this.securityContext, this.clusterService.state());
        ActionListener responseDocsListener = listener.delegateFailureAndWrap((l, docs) -> {
            TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings(this.destIndexSettings, (Map)mappings.get(), transformId, Clock.systemUTC());
            TransformConfigLinter.getWarnings(function, source, syncConfig).forEach(x$0 -> HeaderWarning.addWarning((String)x$0, (Object[])new Object[0]));
            if (previewAsIndexRequest) {
                l.onResponse((Object)new PreviewTransformAction.Response(docs, generatedDestIndexSettings));
            } else {
                l.onResponse((Object)new PreviewTransformAction.Response(docs.stream().map(doc -> (Map)doc.get("_source")).toList(), generatedDestIndexSettings));
            }
        });
        ActionListener previewListener = responseDocsListener.delegateFailureAndWrap((l, docs) -> {
            if (pipeline == null) {
                l.onResponse(docs);
            } else {
                this.simulatePipeline((List<Map<String, Object>>)docs, pipeline, dest, (Client)parentTaskClient, (ActionListener<List<Map<String, Object>>>)l);
            }
        });
        ActionListener deduceMappingsListener = previewListener.delegateFailureAndWrap((l, deducedMappings) -> {
            if (TransformEffectiveSettings.isDeduceMappingsDisabled((SettingsConfig)settingsConfig)) {
                mappings.set(Collections.emptyMap());
            } else {
                mappings.set(deducedMappings);
            }
            function.preview((Client)parentTaskClient, timeout, filteredHeaders, source, (Map<String, String>)deducedMappings, 100, (ActionListener<List<Map<String, Object>>>)l);
        });
        function.deduceMappings((Client)parentTaskClient, filteredHeaders, transformId, source, (ActionListener<Map<String, String>>)deduceMappingsListener);
    }

    private void simulatePipeline(List<Map<String, Object>> previewDocs, String pipeline, String dest, Client client, ActionListener<List<Map<String, Object>>> listener) throws IOException {
        ActionListener pipelineResponseActionListener = listener.delegateFailureAndWrap((l, simulatePipelineResponse) -> {
            ArrayList docs = new ArrayList(simulatePipelineResponse.getResults().size());
            ArrayList<Map> errors = new ArrayList<Map>();
            for (SimulateDocumentResult simulateDocumentResult : simulatePipelineResponse.getResults()) {
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                try {
                    Map error;
                    XContentBuilder content = simulateDocumentResult.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                    Map tempMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)content), (boolean)true, (XContentType)XContentType.JSON).v2();
                    Map sourceDoc = (Map)XContentMapValues.extractValue((String)"doc._source", (Map)tempMap);
                    if (sourceDoc != null) {
                        docs.add(Map.ofEntries(Map.entry("_id", XContentMapValues.extractValue((String)"doc._id", (Map)tempMap)), Map.entry("_source", sourceDoc)));
                    }
                    if ((error = (Map)XContentMapValues.extractValue((String)"error", (Map)tempMap)) == null) continue;
                    errors.add(error);
                }
                finally {
                    if (xContentBuilder == null) continue;
                    xContentBuilder.close();
                }
            }
            if (!errors.isEmpty()) {
                HeaderWarning.addWarning((String)("Pipeline returned " + errors.size() + " errors, first error: " + String.valueOf(errors.getFirst())), (Object[])new Object[0]);
            }
            l.onResponse(docs);
        });
        List<Map> results = previewDocs.stream().map(doc -> Map.ofEntries(Map.entry("_source", doc.get("_source")), Map.entry("_id", doc.get("_id")), Map.entry("_index", dest))).toList();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field("docs", results);
            builder.endObject();
            SimulatePipelineRequest pipelineRequest = new SimulatePipelineRequest(ReleasableBytesReference.wrap((BytesReference)BytesReference.bytes((XContentBuilder)builder)), XContentType.JSON);
            pipelineRequest.setId(pipeline);
            client.execute((ActionType)SimulatePipelineAction.INSTANCE, (ActionRequest)pipelineRequest, pipelineResponseActionListener);
        }
    }
}

