/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;

final class SearchableSnapshotsUsageTracker
implements Runnable {
    private final XPackLicenseState licenseState;
    private final Supplier<ClusterState> clusterStateSupplier;

    SearchableSnapshotsUsageTracker(XPackLicenseState licenseState, Supplier<ClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
        this.licenseState = licenseState;
    }

    @Override
    public void run() {
        if (SearchableSnapshotsUsageTracker.hasSearchableSnapshotsIndices(this.clusterStateSupplier.get())) {
            SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.check(this.licenseState);
        }
    }

    private static boolean hasSearchableSnapshotsIndices(ClusterState state) {
        return state.metadata().getProject().stream().anyMatch(IndexMetadata::isSearchableSnapshot);
    }
}

