/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ProjectRepo;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.reservedstate.service.FileSettingsService;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.IndexMetadataRestoreTransformer;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.threadpool.ThreadPool;

public final class RestoreService
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(RestoreService.class);
    public static final Setting<Boolean> REFRESH_REPO_UUID_ON_RESTORE_SETTING = Setting.boolSetting("snapshot.refresh_repo_uuid_on_restore", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final Set<String> UNMODIFIABLE_SETTINGS = Set.of("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", "index.history.uuid", IndexSettings.MODE.getKey(), IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.getKey(), IndexSettings.RECOVERY_USE_SYNTHETIC_SOURCE_SETTING.getKey(), IndexSortConfig.INDEX_SORT_FIELD_SETTING.getKey(), IndexSortConfig.INDEX_SORT_ORDER_SETTING.getKey(), IndexSortConfig.INDEX_SORT_MODE_SETTING.getKey(), IndexSortConfig.INDEX_SORT_MISSING_SETTING.getKey());
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final IndexMetadataVerifier indexMetadataVerifier;
    private final boolean deserializeProjectMetadata;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterSettings clusterSettings;
    private final SystemIndices systemIndices;
    private final IndicesService indicesService;
    private final FileSettingsService fileSettingsService;
    private final ThreadPool threadPool;
    private final Executor snapshotMetaExecutor;
    private final IndexMetadataRestoreTransformer indexMetadataRestoreTransformer;
    private volatile boolean refreshRepositoryUuidOnRestore;
    private volatile boolean cleanupInProgress = false;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, IndexMetadataVerifier indexMetadataVerifier, ShardLimitValidator shardLimitValidator, SystemIndices systemIndices, IndicesService indicesService, FileSettingsService fileSettingsService, ThreadPool threadPool, boolean deserializeProjectMetadata, IndexMetadataRestoreTransformer indexMetadataRestoreTransformer) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.indexMetadataVerifier = indexMetadataVerifier;
        this.deserializeProjectMetadata = deserializeProjectMetadata;
        if (DiscoveryNode.isMasterNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterService.getClusterSettings();
        this.shardLimitValidator = shardLimitValidator;
        this.systemIndices = systemIndices;
        this.indicesService = indicesService;
        this.fileSettingsService = fileSettingsService;
        this.threadPool = threadPool;
        this.snapshotMetaExecutor = threadPool.executor("snapshot_meta");
        this.refreshRepositoryUuidOnRestore = REFRESH_REPO_UUID_ON_RESTORE_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(REFRESH_REPO_UUID_ON_RESTORE_SETTING, this::setRefreshRepositoryUuidOnRestore);
        this.indexMetadataRestoreTransformer = indexMetadataRestoreTransformer;
    }

    public void restoreSnapshot(ProjectId projectId, RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener) {
        this.restoreSnapshot(projectId, request, listener, (clusterState, builder) -> {});
    }

    public void restoreSnapshot(ProjectId projectId, RestoreSnapshotRequest request, ActionListener<RestoreCompletionResponse> listener, BiConsumer<ClusterState, ProjectMetadata.Builder> updater) {
        assert (Repository.assertSnapshotMetaThread());
        if (!this.clusterService.state().metadata().hasProject(projectId)) {
            listener.onFailure(new SnapshotRestoreException(request.repository(), request.snapshot(), "project [" + String.valueOf(projectId) + "] does not exist"));
            return;
        }
        SubscribableListener repositoryUuidRefreshStep = SubscribableListener.newForked(l -> RestoreService.refreshRepositoryUuids(this.refreshRepositoryUuidOnRestore, projectId, this.repositoriesService, () -> l.onResponse(null), this.snapshotMetaExecutor));
        AtomicReference repositoryRef = new AtomicReference();
        AtomicReference repositoryDataRef = new AtomicReference();
        SubscribableListener.newForked(repositorySetListener -> {
            repositoryRef.set(this.repositoriesService.repository(projectId, request.repository()));
            repositorySetListener.onResponse(null);
        }).andThen(repositoryDataListener -> ((Repository)repositoryRef.get()).getRepositoryData(this.snapshotMetaExecutor, (ActionListener<RepositoryData>)repositoryDataListener)).andThenAccept(repositoryDataRef::set).andThen(repositoryUuidRefreshStep::addListener).andThen(snapshotInfoListener -> {
            assert (Repository.assertSnapshotMetaThread());
            String snapshotName = request.snapshot();
            SnapshotId snapshotId = ((RepositoryData)repositoryDataRef.get()).getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst().orElseThrow(() -> new SnapshotRestoreException(request.repository(), snapshotName, "snapshot does not exist"));
            if (request.snapshotUuid() != null && !request.snapshotUuid().equals(snapshotId.getUUID())) {
                throw new SnapshotRestoreException(request.repository(), snapshotName, "snapshot UUID mismatch: expected [" + request.snapshotUuid() + "] but got [" + snapshotId.getUUID() + "]");
            }
            ((Repository)repositoryRef.get()).getSnapshotInfo(snapshotId, (ActionListener<SnapshotInfo>)snapshotInfoListener);
        }).andThen((responseListener, snapshotInfo) -> this.startRestore((SnapshotInfo)snapshotInfo, (Repository)repositoryRef.get(), request, (RepositoryData)repositoryDataRef.get(), updater, (ActionListener<RestoreCompletionResponse>)responseListener)).addListener(listener.delegateResponse((delegate, e) -> {
            logger.warn(() -> "[" + ProjectRepo.projectRepoString(projectId, request.repository()) + ":" + request.snapshot() + "] failed to restore snapshot", (Throwable)e);
            delegate.onFailure((Exception)e);
        }));
    }

    private void startRestore(SnapshotInfo snapshotInfo, Repository repository, RestoreSnapshotRequest request, RepositoryData repositoryData, BiConsumer<ClusterState, ProjectMetadata.Builder> updater, ActionListener<RestoreCompletionResponse> listener) throws IOException {
        Metadata.Builder metadataBuilder;
        assert (Repository.assertSnapshotMetaThread());
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        String repositoryName = repository.getMetadata().name();
        Snapshot snapshot = new Snapshot(snapshotInfo.projectId(), repositoryName, snapshotId);
        RestoreService.validateSnapshotRestorable(request, repository.getMetadata(), snapshotInfo, this.repositoriesService.getPreRestoreVersionChecks());
        ProjectId projectId = snapshotInfo.projectId();
        Metadata globalMetadata = null;
        if (request.includeGlobalState()) {
            globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId, this.deserializeProjectMetadata);
            metadataBuilder = Metadata.builder(globalMetadata);
        } else {
            metadataBuilder = Metadata.builder();
        }
        String[] indicesInRequest = request.indices();
        ArrayList<String> requestIndices = new ArrayList<String>(indicesInRequest.length);
        if (indicesInRequest.length == 0) {
            requestIndices.add("*");
        } else {
            Collections.addAll(requestIndices, indicesInRequest);
        }
        Map<String, List<String>> featureStatesToRestore = this.getFeatureStatesToRestore(request, snapshotInfo, snapshot);
        Set featureStateIndices = featureStatesToRestore.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> featureStateDataStreams = featureStatesToRestore.keySet().stream().filter(featureName -> {
            if (this.systemIndices.getFeatureNames().contains(featureName)) {
                return true;
            }
            logger.warn(() -> Strings.format((String)"Restoring snapshot[%s] skipping feature [%s] because it is not available in this cluster", (Object[])new Object[]{snapshotInfo.snapshot(), featureName}));
            return false;
        }).map(this.systemIndices::getFeature).flatMap(feature -> feature.getDataStreamDescriptors().stream()).map(SystemDataStreamDescriptor::getDataStreamName).collect(Collectors.toSet());
        Tuple<Map<String, DataStream>, Map<String, DataStreamAlias>> result = this.getDataStreamsToRestore(repository, snapshotId, snapshotInfo, globalMetadata, requestIndices, featureStateDataStreams, request.includeAliases());
        Map dataStreamsToRestore = (Map)result.v1();
        Map dataStreamAliasesToRestore = (Map)result.v2();
        this.validateDataStreamTemplatesExistAndWarnIfMissing(dataStreamsToRestore, snapshotInfo, globalMetadata);
        requestIndices.removeAll(dataStreamsToRestore.keySet());
        Map backingIndices = dataStreamsToRestore.values().stream().flatMap(ds -> ds.getIndices().stream().map(idx -> new Tuple((Object)ds.isSystem(), (Object)idx.getName()))).collect(Collectors.partitioningBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toSet())));
        Map failureIndices = dataStreamsToRestore.values().stream().flatMap(ds -> ds.getFailureIndices().stream().map(idx -> new Tuple((Object)ds.isSystem(), (Object)idx.getName()))).collect(Collectors.partitioningBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toSet())));
        Set systemDataStreamIndices = Sets.union(backingIndices.getOrDefault(true, Set.of()), failureIndices.getOrDefault(true, Set.of()));
        Set<String> nonSystemDataStreamBackingIndices = backingIndices.getOrDefault(false, Set.of());
        Set<String> nonSystemDataStreamFailureIndices = failureIndices.getOrDefault(false, Set.of());
        requestIndices.addAll(nonSystemDataStreamBackingIndices);
        requestIndices.addAll(nonSystemDataStreamFailureIndices);
        Set<String> allSystemIndicesToRestore = Stream.of(systemDataStreamIndices, featureStateIndices).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet systemIndicesInSnapshot = new HashSet();
        snapshotInfo.featureStates().stream().flatMap(state -> state.getIndices().stream()).forEach(systemIndicesInSnapshot::add);
        snapshotInfo.indices().stream().filter(this.systemIndices::isSystemIndexBackingDataStream).forEach(systemIndicesInSnapshot::add);
        HashSet<String> explicitlyRequestedSystemIndices = new HashSet<String>(requestIndices);
        explicitlyRequestedSystemIndices.retainAll(systemIndicesInSnapshot);
        if (explicitlyRequestedSystemIndices.size() > 0) {
            throw new IllegalArgumentException(Strings.format((String)"requested system indices %s, but system indices can only be restored as part of a feature state", (Object[])new Object[]{explicitlyRequestedSystemIndices}));
        }
        List<String> availableNonSystemIndices = snapshotInfo.indices().stream().filter(idxName -> !systemIndicesInSnapshot.contains(idxName)).toList();
        List<String> requestedIndicesInSnapshot = SnapshotUtils.filterIndices(availableNonSystemIndices, (String[])requestIndices.toArray(String[]::new), request.indicesOptions());
        List<String> requestedIndicesIncludingSystem = Stream.of(requestedIndicesInSnapshot, featureStateIndices, systemDataStreamIndices).flatMap(Collection::stream).distinct().toList();
        HashSet<String> explicitlyRequestedSystemIndices2 = new HashSet<String>();
        ProjectMetadata.Builder projectBuilder = metadataBuilder.getProject(projectId);
        if (projectBuilder == null) {
            projectBuilder = ProjectMetadata.builder(projectId);
            metadataBuilder.put(projectBuilder);
        }
        for (IndexId indexId : repositoryData.resolveIndices(requestedIndicesIncludingSystem).values()) {
            IndexMetadata snapshotIndexMetaData = repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId);
            if ((snapshotIndexMetaData = this.indexMetadataRestoreTransformer.updateIndexMetadata(snapshotIndexMetaData)).isSystem() && requestIndices.contains(indexId.getName())) {
                explicitlyRequestedSystemIndices2.add(indexId.getName());
            }
            projectBuilder.put(snapshotIndexMetaData, false);
        }
        assert (explicitlyRequestedSystemIndices2.size() == 0) : "it should be impossible to reach this point with explicitly requested system indices, but got: " + String.valueOf(explicitlyRequestedSystemIndices2);
        projectBuilder.dataStreams(dataStreamsToRestore, dataStreamAliasesToRestore);
        this.submitUnbatchedTask("restore_snapshot[" + snapshotId.getName() + "]", new RestoreSnapshotStateTask(request, snapshot, featureStatesToRestore.keySet(), RestoreService.renamedIndices(request, requestedIndicesIncludingSystem, nonSystemDataStreamBackingIndices, nonSystemDataStreamFailureIndices, allSystemIndicesToRestore, repositoryData), snapshotInfo, metadataBuilder.build(), dataStreamsToRestore.values(), updater, this.clusterService.getSettings(), listener));
    }

    private void validateDataStreamTemplatesExistAndWarnIfMissing(Map<String, DataStream> dataStreamsToRestore, SnapshotInfo snapshotInfo, Metadata globalMetadata) {
        ProjectId projectId = snapshotInfo.projectId();
        Stream<ComposableIndexTemplate> streams = Stream.concat(this.clusterService.state().metadata().getProject(projectId).templatesV2().values().stream(), globalMetadata == null ? Stream.empty() : globalMetadata.getProject(projectId).templatesV2().values().stream());
        Set<String> templatePatterns = streams.filter(cit -> cit.getDataStreamTemplate() != null).flatMap(cit -> cit.indexPatterns().stream()).collect(Collectors.toSet());
        RestoreService.warnIfIndexTemplateMissing(dataStreamsToRestore, templatePatterns, snapshotInfo);
    }

    static void warnIfIndexTemplateMissing(Map<String, DataStream> dataStreamsToRestore, Set<String> templatePatterns, SnapshotInfo snapshotInfo) {
        for (Map.Entry<String, DataStream> entry : dataStreamsToRestore.entrySet()) {
            String name = entry.getKey();
            DataStream dataStream = entry.getValue();
            if (dataStream.isSystem() || !templatePatterns.stream().noneMatch(pattern -> Regex.simpleMatch(pattern, name))) continue;
            String warningMessage = Strings.format((String)"Snapshot [%s] contains data stream [%s] but custer does not have a matching index template. This will cause rollover to fail until a matching index template is created", (Object[])new Object[]{snapshotInfo.snapshot(), name});
            logger.warn(() -> warningMessage);
            HeaderWarning.addWarning(warningMessage, new Object[0]);
        }
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private void setRefreshRepositoryUuidOnRestore(boolean refreshRepositoryUuidOnRestore) {
        this.refreshRepositoryUuidOnRestore = refreshRepositoryUuidOnRestore;
    }

    static void refreshRepositoryUuids(boolean enabled, ProjectId projectId, RepositoriesService repositoriesService, Runnable onCompletion, Executor responseExecutor) {
        try (RefCountingRunnable refs = new RefCountingRunnable(onCompletion);){
            if (!enabled) {
                logger.debug("repository UUID refresh is disabled");
                return;
            }
            for (Repository repository : repositoriesService.getProjectRepositories(projectId).values()) {
                if (!(repository instanceof BlobStoreRepository) || !repository.getMetadata().uuid().equals("_na_")) continue;
                final String repositoryName = repository.getMetadata().name();
                logger.info("refreshing repository UUID for repository [{}]", (Object)repositoryName);
                repository.getRepositoryData(responseExecutor, ActionListener.releaseAfter(new ActionListener<RepositoryData>(){

                    @Override
                    public void onResponse(RepositoryData repositoryData) {
                        logger.debug(() -> Strings.format((String)"repository UUID [%s] refresh completed", (Object[])new Object[]{repositoryName}));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug(() -> Strings.format((String)"repository UUID [%s] refresh failed", (Object[])new Object[]{repositoryName}), (Throwable)e);
                    }
                }, refs.acquire()));
            }
        }
    }

    private boolean isSystemIndex(IndexMetadata indexMetadata) {
        return indexMetadata.isSystem() || this.systemIndices.isSystemName(indexMetadata.getIndex().getName());
    }

    private Tuple<Map<String, DataStream>, Map<String, DataStreamAlias>> getDataStreamsToRestore(Repository repository, SnapshotId snapshotId, SnapshotInfo snapshotInfo, Metadata globalMetadata, List<String> requestIndices, Collection<String> featureStateDataStreams, boolean includeAliases) {
        Map<String, DataStreamAlias> dataStreamAliases;
        Map<String, DataStream> allDataStreams;
        List<String> requestedDataStreams = SnapshotUtils.filterIndices(snapshotInfo.dataStreams(), (String[])Stream.of(requestIndices, featureStateDataStreams).flatMap(Collection::stream).toArray(String[]::new), IndicesOptions.lenientExpand());
        if (requestedDataStreams.isEmpty()) {
            allDataStreams = Map.of();
            dataStreamAliases = Map.of();
        } else {
            if (globalMetadata == null) {
                globalMetadata = repository.getSnapshotGlobalMetadata(snapshotId, this.deserializeProjectMetadata);
            }
            ProjectId projectId = snapshotInfo.projectId();
            Map<String, DataStream> dataStreamsInSnapshot = globalMetadata.getProject(projectId).dataStreams();
            allDataStreams = Maps.newMapWithExpectedSize(requestedDataStreams.size());
            HashMap<String, DataStream> systemDataStreams = new HashMap<String, DataStream>();
            for (String requestedDataStream : requestedDataStreams) {
                DataStream dataStreamInSnapshot = dataStreamsInSnapshot.get(requestedDataStream);
                assert (dataStreamInSnapshot != null) : "DataStream [" + requestedDataStream + "] not found in snapshot";
                if (!dataStreamInSnapshot.isSystem()) {
                    allDataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    continue;
                }
                if (requestIndices.contains(requestedDataStream)) {
                    throw new IllegalArgumentException(Strings.format((String)"requested system data stream [%s], but system data streams can only be restored as part of a feature state", (Object[])new Object[]{requestedDataStream}));
                }
                if (featureStateDataStreams.contains(requestedDataStream)) {
                    allDataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    systemDataStreams.put(requestedDataStream, dataStreamInSnapshot);
                    continue;
                }
                logger.debug("omitting system data stream [{}] from snapshot restoration because its feature state was not requested", (Object)requestedDataStream);
            }
            if (includeAliases || !systemDataStreams.isEmpty()) {
                dataStreamAliases = new HashMap();
                Map<String, DataStreamAlias> dataStreamAliasesInSnapshot = globalMetadata.getProject(projectId).dataStreamAliases();
                Map<String, DataStream> dataStreamsWithAliases = includeAliases ? allDataStreams : systemDataStreams;
                for (DataStreamAlias alias : dataStreamAliasesInSnapshot.values()) {
                    DataStreamAlias copy = alias.intersect(dataStreamsWithAliases.keySet()::contains);
                    if (copy.getDataStreams().isEmpty()) continue;
                    dataStreamAliases.put(alias.getName(), copy);
                }
            } else {
                dataStreamAliases = Map.of();
            }
        }
        return new Tuple(allDataStreams, dataStreamAliases);
    }

    private Map<String, List<String>> getFeatureStatesToRestore(RestoreSnapshotRequest request, SnapshotInfo snapshotInfo, Snapshot snapshot) {
        Map<String, List<String>> featureStatesToRestore;
        if (snapshotInfo.featureStates() == null) {
            return Collections.emptyMap();
        }
        Map<String, List> snapshotFeatureStates = snapshotInfo.featureStates().stream().collect(Collectors.toMap(SnapshotFeatureInfo::getPluginName, SnapshotFeatureInfo::getIndices));
        String[] requestedFeatureStates = request.featureStates();
        if (requestedFeatureStates == null || requestedFeatureStates.length == 0) {
            featureStatesToRestore = request.includeGlobalState() ? new HashMap<String, List>(snapshotFeatureStates) : Collections.emptyMap();
        } else if (requestedFeatureStates.length == 1 && "none".equalsIgnoreCase(requestedFeatureStates[0])) {
            featureStatesToRestore = Collections.emptyMap();
        } else {
            Set<String> requestedStates = Set.of(requestedFeatureStates);
            if (requestedStates.contains("none")) {
                throw new SnapshotRestoreException(snapshot, "the feature_states value [none] indicates that no feature states should be restored, but other feature states were requested: " + String.valueOf(requestedStates));
            }
            if (!snapshotFeatureStates.keySet().containsAll(requestedStates)) {
                HashSet<String> nonExistingRequestedStates = new HashSet<String>(requestedStates);
                nonExistingRequestedStates.removeAll(snapshotFeatureStates.keySet());
                throw new SnapshotRestoreException(snapshot, "requested feature states [" + String.valueOf(nonExistingRequestedStates) + "] are not present in snapshot");
            }
            featureStatesToRestore = new HashMap<String, List>(snapshotFeatureStates);
            featureStatesToRestore.keySet().retainAll(requestedStates);
        }
        List<String> featuresNotOnThisNode = featureStatesToRestore.keySet().stream().filter(s -> !this.systemIndices.getFeatureNames().contains(s)).toList();
        if (!featuresNotOnThisNode.isEmpty()) {
            throw new SnapshotRestoreException(snapshot, "requested feature states " + String.valueOf(featuresNotOnThisNode) + " are present in snapshot but those features are not installed on the current master node");
        }
        return featureStatesToRestore;
    }

    private Set<Index> resolveSystemIndicesToDelete(ProjectMetadata projectMetadata, Set<String> featureStatesToRestore) {
        if (featureStatesToRestore == null) {
            return Collections.emptySet();
        }
        return featureStatesToRestore.stream().map(this.systemIndices::getFeature).filter(Objects::nonNull).flatMap(feature -> feature.getIndexDescriptors().stream()).flatMap(descriptor -> descriptor.getMatchingIndices(projectMetadata).stream()).map(indexName -> {
            assert (projectMetadata.hasIndex((String)indexName)) : "index [" + indexName + "] not found in metadata but must be present";
            return projectMetadata.indices().get(indexName).getIndex();
        }).collect(Collectors.toUnmodifiableSet());
    }

    private Set<DataStream> resolveSystemDataStreamsToDelete(ProjectMetadata projectMetadata, Set<String> featureStatesToRestore) {
        if (featureStatesToRestore == null) {
            return Collections.emptySet();
        }
        return featureStatesToRestore.stream().map(this.systemIndices::getFeature).filter(Objects::nonNull).flatMap(feature -> feature.getDataStreamDescriptors().stream()).map(SystemDataStreamDescriptor::getDataStreamName).filter(datastreamName -> projectMetadata.dataStreams().containsKey(datastreamName)).map(dataStreamName -> projectMetadata.dataStreams().get(dataStreamName)).collect(Collectors.toUnmodifiableSet());
    }

    static DataStream updateDataStream(DataStream dataStream, ProjectMetadata.Builder projectMetadata, RestoreSnapshotRequest request) {
        String dataStreamName = dataStream.getName();
        if (request.renamePattern() != null && request.renameReplacement() != null) {
            dataStreamName = dataStreamName.replaceAll(request.renamePattern(), request.renameReplacement());
        }
        List<Index> updatedIndices = dataStream.getIndices().stream().map(i -> projectMetadata.get(RestoreService.renameIndex(i.getName(), request, true, false)).getIndex()).toList();
        List<Index> updatedFailureIndices = dataStream.getFailureComponent().getIndices().stream().map(i -> projectMetadata.get(RestoreService.renameIndex(i.getName(), request, false, true)).getIndex()).toList();
        return dataStream.copy().setName(dataStreamName).setBackingIndices(dataStream.getDataComponent().copy().setIndices(updatedIndices).build()).setFailureIndices(dataStream.getFailureComponent().copy().setIndices(updatedFailureIndices).build()).build();
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> cursor : entry.shards().entrySet()) {
                ShardId shardId = cursor.getKey();
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.quiet(), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    private static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (!status.state().completed()) {
                return nonCompletedState;
            }
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (RestoreInProgress.ShardRestoreStatus status : shards.values()) {
            if (status.state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private static String renameIndex(String index, RestoreSnapshotRequest request, boolean isBackingIndex, boolean isFailureStore) {
        if (request.renameReplacement() == null || request.renamePattern() == null) {
            return index;
        }
        String prefix = null;
        if (isBackingIndex && index.startsWith(".ds-")) {
            prefix = ".ds-";
        }
        if (isFailureStore && index.startsWith(".fs-")) {
            prefix = ".fs-";
        }
        if (prefix != null) {
            index = index.substring(prefix.length());
        }
        Object renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
        if (prefix != null) {
            renamedIndex = prefix + (String)renamedIndex;
        }
        return renamedIndex;
    }

    private static Map<String, IndexId> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices, Set<String> dataStreamBackingIndices, Set<String> dataStreamFailureIndices, Set<String> featureIndices, RepositoryData repositoryData) {
        HashMap<String, IndexId> renamedIndices = new HashMap<String, IndexId>();
        for (String index : filteredIndices) {
            String renamedIndex = featureIndices.contains(index) ? index : RestoreService.renameIndex(index, request, dataStreamBackingIndices.contains(index), dataStreamFailureIndices.contains(index));
            IndexId previousIndex = renamedIndices.put(renamedIndex, repositoryData.resolveIndexId(index));
            if (previousIndex == null) continue;
            throw new SnapshotRestoreException(request.repository(), request.snapshot(), "indices [" + index + "] and [" + previousIndex.getName() + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    static void validateSnapshotRestorable(RestoreSnapshotRequest request, RepositoryMetadata repository, SnapshotInfo snapshotInfo, List<BiConsumer<Snapshot, IndexVersion>> preRestoreVersionChecks) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(snapshotInfo.projectId(), repository.name(), snapshotInfo.snapshotId()), "unsupported snapshot state [" + String.valueOf((Object)snapshotInfo.state()) + "]");
        }
        if (IndexVersion.current().before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(snapshotInfo.projectId(), repository.name(), snapshotInfo.snapshotId()), "the snapshot was created with version [" + snapshotInfo.version().toReleaseVersion() + "] which is higher than the version of this node [" + IndexVersion.current().toReleaseVersion() + "]");
        }
        Snapshot snapshot = new Snapshot(snapshotInfo.projectId(), repository.name(), snapshotInfo.snapshotId());
        preRestoreVersionChecks.forEach(c -> c.accept(snapshot, snapshotInfo.version()));
        if (request.includeGlobalState() && snapshotInfo.includeGlobalState() == Boolean.FALSE) {
            throw new SnapshotRestoreException(new Snapshot(snapshotInfo.projectId(), repository.name(), snapshotInfo.snapshotId()), "cannot restore global state since the snapshot was created without global state");
        }
    }

    public static boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ProjectState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : RestoreInProgress.get(currentState.cluster())) {
            for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : entry.shards().entrySet()) {
                Index index = shard.getKey().getIndex();
                if (!indicesToCheck.contains(index) || shard.getValue().state().completed() || currentState.metadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return RestoreInProgress.get(state).get(restoreUUID);
    }

    private void removeCompletedRestoresFromClusterState() {
        this.submitUnbatchedTask("clean up snapshot restore status", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
                boolean changed = false;
                for (RestoreInProgress.Entry entry : RestoreInProgress.get(currentState)) {
                    if (entry.state().completed()) {
                        logger.log(entry.quiet() ? Level.DEBUG : Level.INFO, "completed restore of snapshot [{}] with state [{}]", (Object)entry.snapshot(), (Object)entry.state());
                        changed = true;
                        continue;
                    }
                    restoreInProgressBuilder.add(entry);
                }
                return !changed ? currentState : ClusterState.builder(currentState).putCustom("restore", restoreInProgressBuilder.build()).build();
            }

            @Override
            public void onFailure(Exception e) {
                RestoreService.this.cleanupInProgress = false;
                logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.WARN, "failed to remove completed restores from cluster state", (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                RestoreService.this.cleanupInProgress = false;
            }
        });
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        block5: {
            try {
                if (!event.localNodeMaster() || this.cleanupInProgress) break block5;
                for (RestoreInProgress.Entry entry : RestoreInProgress.get(event.state())) {
                    if (!entry.state().completed()) continue;
                    assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
                    this.removeCompletedRestoresFromClusterState();
                    this.cleanupInProgress = true;
                    break;
                }
            }
            catch (Exception t) {
                assert (false) : t;
                logger.warn("Failed to update restore state ", (Throwable)t);
            }
        }
    }

    private static IndexMetadata updateIndexSettings(Snapshot snapshot, IndexMetadata indexMetadata, Settings changeSettings, String[] ignoreSettings) {
        Boolean previous;
        Boolean changed;
        Settings settings = indexMetadata.getSettings();
        Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(settings).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(changeSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(changeSettings).booleanValue()) {
            throw new SnapshotRestoreException(snapshot, "cannot disable setting [" + IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey() + "] on restore");
        }
        if ("snapshot".equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(settings)) && (changed = changeSettings.getAsBoolean("index.store.snapshot.delete_searchable_snapshot", null)) != null && !Objects.equals(previous = settings.getAsBoolean("index.store.snapshot.delete_searchable_snapshot", null), changed)) {
            throw new SnapshotRestoreException(snapshot, Strings.format((String)"cannot change value of [%s] when restoring searchable snapshot [%s:%s] as index %s", (Object[])new Object[]{"index.store.snapshot.delete_searchable_snapshot", ProjectRepo.projectRepoString(snapshot.getProjectId(), snapshot.getRepository()), snapshot.getSnapshotId().getName(), indexMetadata.getIndex()}));
        }
        IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
        HashSet<String> keyFilters = new HashSet<String>();
        ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
        for (String ignoredSetting : ignoreSettings) {
            if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                    throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                }
                keyFilters.add(ignoredSetting);
                continue;
            }
            simpleMatchPatterns.add(ignoredSetting);
        }
        Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(k -> {
            if (!UNREMOVABLE_SETTINGS.contains(k)) {
                for (String filterKey : keyFilters) {
                    if (!k.equals(filterKey)) continue;
                    return false;
                }
                for (String pattern : simpleMatchPatterns) {
                    if (!Regex.simpleMatch(pattern, k)) continue;
                    return false;
                }
            }
            return true;
        })).put(normalizedChangeSettings.filter(k -> {
            if (UNMODIFIABLE_SETTINGS.contains(k)) {
                throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
            }
            return true;
        }));
        settingsBuilder.remove(MetadataIndexStateService.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
        return builder.settings(settingsBuilder).build();
    }

    private static IndexMetadata convertLegacyIndex(IndexMetadata snapshotIndexMetadata, ClusterState clusterState, IndicesService indicesService) {
        if (snapshotIndexMetadata.getCreationVersion().before(IndexVersion.fromId(5000099))) {
            throw new IllegalArgumentException("can't restore an index created before version 5.0.0");
        }
        IndexMetadata.Builder convertedIndexMetadataBuilder = IndexMetadata.builder(snapshotIndexMetadata);
        convertedIndexMetadataBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put(IndexMetadata.SETTING_INDEX_VERSION_COMPATIBILITY.getKey(), clusterState.getNodes().getMinSupportedIndexVersion()).put(IndexMetadata.SETTING_BLOCKS_WRITE, true));
        snapshotIndexMetadata = convertedIndexMetadataBuilder.build();
        convertedIndexMetadataBuilder = IndexMetadata.builder(snapshotIndexMetadata);
        MappingMetadata mappingMetadata = snapshotIndexMetadata.mapping();
        if (mappingMetadata != null) {
            Map<String, Object> loadedMappingSource = mappingMetadata.rawSourceAsMap();
            LinkedHashMap<String, Map<String, Object>> legacyMapping = new LinkedHashMap<String, Map<String, Object>>();
            boolean sourceOnlySnapshot = snapshotIndexMetadata.getSettings().getAsBoolean("index.source_only", false);
            if (sourceOnlySnapshot) {
                Object sourceOnlyMeta = mappingMetadata.sourceAsMap().get("_meta");
                if (sourceOnlyMeta instanceof Map) {
                    Map sourceOnlyMetaMap = (Map)sourceOnlyMeta;
                    legacyMapping.put("legacy_mappings", sourceOnlyMetaMap);
                }
            } else {
                legacyMapping.put("legacy_mappings", loadedMappingSource);
            }
            LinkedHashMap<String, Object> newMappingSource = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> mergedMapping = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> typeMapping : loadedMappingSource.entrySet()) {
                if (!(typeMapping.getValue() instanceof Map)) continue;
                Map mapping = (Map)typeMapping.getValue();
                if (mergedMapping.isEmpty()) {
                    mergedMapping.putAll(mapping);
                    continue;
                }
                XContentHelper.mergeDefaults(mergedMapping, mapping);
            }
            if (mergedMapping.containsKey("type")) {
                newMappingSource.put("type", mergedMapping.remove("type"));
            }
            if (mergedMapping.containsKey("dynamic")) {
                newMappingSource.put("dynamic", mergedMapping.remove("dynamic"));
            }
            if (mergedMapping.containsKey("enabled")) {
                newMappingSource.put("enabled", mergedMapping.remove("enabled"));
            }
            if (!sourceOnlySnapshot && mergedMapping.containsKey("_meta") && mergedMapping.get("_meta") instanceof Map) {
                Map oldMeta = (Map)mergedMapping.remove("_meta");
                LinkedHashMap<String, Map<String, Object>> newMeta = new LinkedHashMap<String, Map<String, Object>>();
                newMeta.putAll(oldMeta);
                newMeta.putAll(legacyMapping);
                newMappingSource.put("_meta", newMeta);
            } else {
                newMappingSource.put("_meta", legacyMapping);
            }
            if (!sourceOnlySnapshot) {
                newMappingSource.putAll(mergedMapping);
            }
            LinkedHashMap<String, Object> newMapping = new LinkedHashMap<String, Object>();
            newMapping.put(mappingMetadata.type(), newMappingSource);
            MappingMetadata updatedMappingMetadata = new MappingMetadata(mappingMetadata.type(), newMapping);
            convertedIndexMetadataBuilder.putMapping(updatedMappingMetadata);
            IndexMetadata convertedIndexMetadata = convertedIndexMetadataBuilder.build();
            try {
                Mapping mapping;
                try (MapperService mapperService = indicesService.createIndexMapperServiceForValidation(convertedIndexMetadata);){
                    mapperService.merge(convertedIndexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                    mapping = mapperService.documentMapper().mapping();
                }
                if (mapping != null) {
                    convertedIndexMetadataBuilder = IndexMetadata.builder(convertedIndexMetadata);
                    convertedIndexMetadataBuilder.putMapping(new MappingMetadata(mapping.toCompressedXContent()));
                    return convertedIndexMetadataBuilder.build();
                }
            }
            catch (Exception e) {
                IndexMetadata metadata = snapshotIndexMetadata;
                logger.warn(() -> "could not import mappings for legacy index " + metadata.getIndex().getName(), (Throwable)e);
                convertedIndexMetadataBuilder = IndexMetadata.builder(snapshotIndexMetadata);
                newMappingSource.clear();
                newMappingSource.put("_meta", legacyMapping);
                newMapping = new LinkedHashMap();
                newMapping.put(mappingMetadata.type(), newMappingSource);
                updatedMappingMetadata = new MappingMetadata(mappingMetadata.type(), newMapping);
                convertedIndexMetadataBuilder.putMapping(updatedMappingMetadata);
                throw new IllegalArgumentException(e);
            }
        }
        return convertedIndexMetadataBuilder.build();
    }

    private static IndexMetadata.Builder restoreToCreateNewIndex(IndexMetadata snapshotIndexMetadata, String renamedIndexName) {
        return IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName).settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID())).timestampRange(IndexLongFieldRange.NO_SHARDS).eventIngestedRange(IndexLongFieldRange.NO_SHARDS);
    }

    private static IndexMetadata.Builder restoreOverClosedIndex(IndexMetadata snapshotIndexMetadata, IndexMetadata currentIndexMetadata) {
        IndexMetadata.Builder indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion())).mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion())).mappingsUpdatedVersion(snapshotIndexMetadata.getMappingsUpdatedVersion()).settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion())).aliasesVersion(Math.max(snapshotIndexMetadata.getAliasesVersion(), 1L + currentIndexMetadata.getAliasesVersion())).timestampRange(IndexLongFieldRange.NO_SHARDS).eventIngestedRange(IndexLongFieldRange.NO_SHARDS).index(currentIndexMetadata.getIndex().getName()).settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID()).put("index.history.uuid", UUIDs.randomBase64UUID()));
        for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
            indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
        }
        return indexMdBuilder;
    }

    private void ensureValidIndexName(ProjectMetadata projectMetadata, RoutingTable routingTable, IndexMetadata snapshotIndexMetadata, String renamedIndexName) {
        boolean isHidden = snapshotIndexMetadata.isHidden();
        MetadataCreateIndexService.validateIndexName(renamedIndexName, projectMetadata, routingTable);
        this.createIndexService.validateDotIndex(renamedIndexName, isHidden);
        this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
    }

    private static void ensureSearchableSnapshotsRestorable(ClusterState currentState, SnapshotInfo snapshotInfo, Set<Index> indices) {
        ProjectMetadata projectMetadata = currentState.metadata().getProject(snapshotInfo.projectId());
        for (Index index : indices) {
            Settings indexSettings = projectMetadata.getIndexSafe(index).getSettings();
            assert ("snapshot".equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(indexSettings))) : "not a snapshot backed index: " + String.valueOf(index);
            String repositoryUuid = indexSettings.get("index.store.snapshot.repository_uuid");
            String repositoryName = indexSettings.get("index.store.snapshot.repository_name");
            String snapshotUuid = indexSettings.get("index.store.snapshot.snapshot_uuid");
            boolean deleteSnapshot = indexSettings.getAsBoolean("index.store.snapshot.delete_searchable_snapshot", false);
            if (deleteSnapshot && snapshotInfo.indices().size() != 1 && Objects.equals(snapshotUuid, snapshotInfo.snapshotId().getUUID())) {
                throw new SnapshotRestoreException(snapshotInfo.snapshot(), Strings.format((String)"cannot mount snapshot [%s/%s:%s] as index [%s] with the deletion of snapshot on index removal enabled [index.store.snapshot.delete_searchable_snapshot: true]; snapshot contains [%d] indices instead of 1.", (Object[])new Object[]{repositoryName, repositoryUuid, snapshotInfo.snapshotId().getName(), index.getName(), snapshotInfo.indices().size()}));
            }
            for (IndexMetadata other : projectMetadata) {
                boolean otherDeleteSnap;
                String otherRepositoryName;
                String otherRepositoryUuid;
                String otherSnapshotUuid;
                Settings otherSettings;
                if (other.getIndex().equals(index) || !"snapshot".equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(otherSettings = other.getSettings())) || !Objects.equals(snapshotUuid, otherSnapshotUuid = otherSettings.get("index.store.snapshot.snapshot_uuid")) || !RestoreService.matchRepository(repositoryUuid, repositoryName, otherRepositoryUuid = otherSettings.get("index.store.snapshot.repository_uuid"), otherRepositoryName = otherSettings.get("index.store.snapshot.repository_name")) || deleteSnapshot == (otherDeleteSnap = otherSettings.getAsBoolean("index.store.snapshot.delete_searchable_snapshot", false).booleanValue())) continue;
                throw new SnapshotRestoreException(repositoryName, snapshotInfo.snapshotId().getName(), Strings.format((String)"cannot mount snapshot [%s/%s:%s] as index [%s] with [index.store.snapshot.delete_searchable_snapshot: %b]; another index %s is mounted with [index.store.snapshot.delete_searchable_snapshot: %b].", (Object[])new Object[]{repositoryName, repositoryUuid, snapshotInfo.snapshotId().getName(), index.getName(), deleteSnapshot, other.getIndex(), otherDeleteSnap}));
            }
        }
    }

    private static boolean matchRepository(String repositoryUuid, String repositoryName, String otherRepositoryUuid, String otherRepositoryName) {
        if (org.elasticsearch.common.Strings.hasLength(repositoryUuid) && org.elasticsearch.common.Strings.hasLength(otherRepositoryUuid)) {
            return Objects.equals(repositoryUuid, otherRepositoryUuid);
        }
        return Objects.equals(repositoryName, otherRepositoryName);
    }

    static {
        HashSet<String> unremovable = Sets.newHashSetWithExpectedSize(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    private final class RestoreSnapshotStateTask
    extends ClusterStateUpdateTask {
        private final String restoreUUID;
        private final RestoreSnapshotRequest request;
        private final Set<String> featureStatesToRestore;
        private final Map<String, IndexId> indicesToRestore;
        private final Snapshot snapshot;
        private final SnapshotInfo snapshotInfo;
        private final Metadata metadata;
        private final Collection<DataStream> dataStreamsToRestore;
        private final BiConsumer<ClusterState, ProjectMetadata.Builder> updater;
        private final AllocationActionListener<RestoreCompletionResponse> listener;
        private final Settings settings;
        @Nullable
        private RestoreInfo restoreInfo;

        RestoreSnapshotStateTask(RestoreSnapshotRequest request, Snapshot snapshot, Set<String> featureStatesToRestore, Map<String, IndexId> indicesToRestore, SnapshotInfo snapshotInfo, Metadata metadata, Collection<DataStream> dataStreamsToRestore, BiConsumer<ClusterState, ProjectMetadata.Builder> updater, Settings settings, ActionListener<RestoreCompletionResponse> listener) {
            super(request.masterNodeTimeout());
            this.restoreUUID = UUIDs.randomBase64UUID();
            this.request = request;
            this.snapshot = snapshot;
            this.featureStatesToRestore = featureStatesToRestore;
            this.indicesToRestore = indicesToRestore;
            this.snapshotInfo = snapshotInfo;
            this.metadata = metadata;
            this.dataStreamsToRestore = dataStreamsToRestore;
            this.updater = updater;
            this.settings = settings;
            this.listener = new AllocationActionListener<RestoreCompletionResponse>(listener, RestoreService.this.threadPool.getThreadContext());
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            ProjectId projectId = this.snapshot.getProjectId();
            if (!currentState.metadata().hasProject(projectId)) {
                throw new SnapshotRestoreException(this.snapshot, "project [" + String.valueOf(projectId) + "] does not exist");
            }
            this.ensureSnapshotNotDeleted(currentState);
            currentState = MetadataDeleteIndexService.deleteIndices(currentState.projectState(projectId), RestoreService.this.resolveSystemIndicesToDelete(currentState.metadata().getProject(projectId), this.featureStatesToRestore), this.settings);
            currentState = MetadataDataStreamsService.deleteDataStreams(currentState.projectState(projectId), RestoreService.this.resolveSystemDataStreamsToDelete(currentState.metadata().getProject(projectId), this.featureStatesToRestore), this.settings);
            HashSet<Index> searchableSnapshotsIndices = new HashSet<Index>();
            Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            RoutingTable.Builder rtBuilder = RoutingTable.builder(RestoreService.this.allocationService.getShardRoutingRoleStrategy(), currentState.routingTable(projectId));
            HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();
            IndexVersion minIndexCompatibilityVersion = currentState.getNodes().getMinSupportedIndexVersion();
            IndexVersion minReadOnlyIndexCompatibilityVersion = currentState.getNodes().getMinReadOnlySupportedIndexVersion();
            String localNodeId = RestoreService.this.clusterService.state().nodes().getLocalNodeId();
            for (Map.Entry<String, IndexId> indexEntry : this.indicesToRestore.entrySet()) {
                IndexMetadata updatedIndexMetadata;
                IndexId index = indexEntry.getValue();
                IndexMetadata originalIndexMetadata = this.metadata.getProject(projectId).index(index.getName());
                RestoreService.this.repositoriesService.getPreRestoreVersionChecks().forEach(check -> check.accept(this.snapshot, originalIndexMetadata.getCreationVersion()));
                IndexMetadata snapshotIndexMetadata = RestoreService.updateIndexSettings(this.snapshot, originalIndexMetadata, this.request.indexSettings(), this.request.ignoreIndexSettings());
                if (snapshotIndexMetadata.getCompatibilityVersion().isLegacyIndexVersion()) {
                    snapshotIndexMetadata = RestoreService.convertLegacyIndex(snapshotIndexMetadata, currentState, RestoreService.this.indicesService);
                }
                try {
                    snapshotIndexMetadata = RestoreService.this.indexMetadataVerifier.verifyIndexMetadata(snapshotIndexMetadata, minIndexCompatibilityVersion, minReadOnlyIndexCompatibilityVersion);
                }
                catch (Exception ex) {
                    throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + String.valueOf(index) + "] because it cannot be upgraded", ex);
                }
                String renamedIndexName = indexEntry.getKey();
                IndexMetadata currentIndexMetadata = currentState.metadata().getProject(projectId).index(renamedIndexName);
                RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, this.snapshot, this.snapshotInfo.version(), index);
                boolean partial = this.checkPartial(index.getName());
                HashSet<Integer> ignoreShards = new HashSet<Integer>();
                if (currentIndexMetadata == null) {
                    RestoreService.this.ensureValidIndexName(currentState.metadata().getProject(projectId), currentState.routingTable(projectId), snapshotIndexMetadata, renamedIndexName);
                    RestoreService.this.shardLimitValidator.validateShardLimit(snapshotIndexMetadata.getSettings(), currentState.nodes(), currentState.metadata());
                    indexMdBuilder = RestoreService.restoreToCreateNewIndex(snapshotIndexMetadata, renamedIndexName);
                    if (!(this.request.includeAliases() || snapshotIndexMetadata.getAliases().isEmpty() || RestoreService.this.isSystemIndex(snapshotIndexMetadata))) {
                        indexMdBuilder.removeAllAliases();
                    } else {
                        this.ensureNoAliasNameConflicts(snapshotIndexMetadata);
                    }
                    updatedIndexMetadata = indexMdBuilder.build();
                    if (partial) {
                        this.populateIgnoredShards(index.getName(), ignoreShards);
                    }
                    rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, ignoreShards);
                    blocks.addBlocks(projectId, updatedIndexMetadata);
                } else {
                    this.validateExistingClosedIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                    indexMdBuilder = RestoreService.restoreOverClosedIndex(snapshotIndexMetadata, currentIndexMetadata);
                    if (!this.request.includeAliases() && !RestoreService.this.isSystemIndex(snapshotIndexMetadata)) {
                        if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                            indexMdBuilder.removeAllAliases();
                        }
                        for (AliasMetadata alias : currentIndexMetadata.getAliases().values()) {
                            indexMdBuilder.putAlias(alias);
                        }
                    } else {
                        this.ensureNoAliasNameConflicts(snapshotIndexMetadata);
                    }
                    updatedIndexMetadata = indexMdBuilder.build();
                    rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                    blocks.updateBlocks(projectId, updatedIndexMetadata);
                }
                mdBuilder.getProject(projectId).put(updatedIndexMetadata, true);
                Index renamedIndex = updatedIndexMetadata.getIndex();
                for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                    shards.put(new ShardId(renamedIndex, shard), ignoreShards.contains(shard) ? new RestoreInProgress.ShardRestoreStatus(localNodeId, RestoreInProgress.State.FAILURE) : new RestoreInProgress.ShardRestoreStatus(localNodeId));
                }
                if (!"snapshot".equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(updatedIndexMetadata.getSettings()))) continue;
                searchableSnapshotsIndices.add(updatedIndexMetadata.getIndex());
            }
            ClusterState.Builder builder = ClusterState.builder(currentState);
            if (!shards.isEmpty()) {
                builder.putCustom("restore", new RestoreInProgress.Builder(RestoreInProgress.get(currentState)).add(new RestoreInProgress.Entry(this.restoreUUID, this.snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), this.request.quiet(), List.copyOf(this.indicesToRestore.keySet()), Map.copyOf(shards))).build());
            }
            this.applyDataStreamRestores(currentState, mdBuilder, projectId);
            if (this.request.includeGlobalState()) {
                this.applyGlobalStateRestore(currentState, mdBuilder, projectId);
                RestoreService.this.fileSettingsService.handleSnapshotRestore(currentState, builder, mdBuilder, projectId);
            }
            if (RestoreService.completed(shards)) {
                this.restoreInfo = new RestoreInfo(this.snapshot.getSnapshotId().getName(), List.copyOf(this.indicesToRestore.keySet()), shards.size(), shards.size() - RestoreService.failedShards(shards));
            }
            this.updater.accept(currentState, mdBuilder.getProject(projectId));
            ClusterState updatedClusterState = builder.metadata(mdBuilder).blocks(blocks).putRoutingTable(projectId, rtBuilder.build()).build();
            if (!searchableSnapshotsIndices.isEmpty()) {
                RestoreService.ensureSearchableSnapshotsRestorable(updatedClusterState, this.snapshotInfo, searchableSnapshotsIndices);
            }
            return RestoreService.this.allocationService.reroute(updatedClusterState, "restored snapshot [" + String.valueOf(this.snapshot) + "]", this.listener.reroute());
        }

        private void applyDataStreamRestores(ClusterState currentState, Metadata.Builder mdBuilder, ProjectId projectId) {
            HashMap<String, DataStream> updatedDataStreams = new HashMap<String, DataStream>(currentState.metadata().getProject(projectId).dataStreams());
            updatedDataStreams.putAll(this.dataStreamsToRestore.stream().map(ds -> RestoreService.updateDataStream(ds, mdBuilder.getProject(projectId), this.request)).collect(Collectors.toMap(DataStream::getName, Function.identity())));
            HashMap<String, DataStreamAlias> updatedDataStreamAliases = new HashMap<String, DataStreamAlias>(currentState.metadata().getProject(projectId).dataStreamAliases());
            for (DataStreamAlias alias : this.metadata.getProject(projectId).dataStreamAliases().values()) {
                updatedDataStreamAliases.compute(alias.getName(), (key, previous) -> alias.restore((DataStreamAlias)previous, this.request.renamePattern(), this.request.renameReplacement()));
            }
            mdBuilder.getProject(projectId).dataStreams(updatedDataStreams, updatedDataStreamAliases);
        }

        private void ensureSnapshotNotDeleted(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
            if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.projectId().equals(this.snapshot.getProjectId()) && entry.snapshots().contains(this.snapshot.getSnapshotId()))) {
                throw new ConcurrentSnapshotExecutionException(this.snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + String.valueOf(deletionsInProgress.getEntries().get(0)) + "]");
            }
        }

        private void applyGlobalStateRestore(ClusterState currentState, Metadata.Builder mdBuilder, ProjectId projectId) {
            ProjectMetadata.Builder projectBuilder = mdBuilder.getProject(projectId);
            if (this.metadata.persistentSettings() != null) {
                Set set;
                assert (!RestoreService.this.deserializeProjectMetadata && ProjectId.DEFAULT.equals(projectId) || this.metadata.persistentSettings().isEmpty()) : "Inconsistent deserializeProjectMetadata [" + RestoreService.this.deserializeProjectMetadata + "], project [" + String.valueOf(projectId) + "], and cluster level persistent settings " + String.valueOf(this.metadata.persistentSettings());
                Settings settings = this.metadata.persistentSettings();
                if (this.request.skipOperatorOnlyState() && !(set = Stream.concat(settings.keySet().stream(), currentState.metadata().persistentSettings().keySet().stream()).filter(k -> {
                    Setting<?> setting = RestoreService.this.clusterSettings.get((String)k);
                    return setting != null && setting.isOperatorOnly();
                }).collect(Collectors.toSet())).isEmpty()) {
                    settings = Settings.builder().put(settings.filter(k -> false == operatorSettingKeys.contains(k))).put(currentState.metadata().persistentSettings().filter(set::contains)).build();
                }
                RestoreService.this.clusterSettings.validateUpdate(settings);
                mdBuilder.persistentSettings(settings);
            }
            if (this.metadata.getProject(projectId).templates() != null) {
                for (IndexTemplateMetadata indexTemplateMetadata : this.metadata.getProject(projectId).templates().values()) {
                    projectBuilder.put(indexTemplateMetadata);
                }
            }
            mdBuilder.removeCustomIf((key, value) -> value.isRestorable());
            projectBuilder.removeCustomIf((key, value) -> value.isRestorable());
            if (this.metadata.customs() != null) {
                assert (!RestoreService.this.deserializeProjectMetadata || this.metadata.persistentSettings().isEmpty()) : "Inconsistent deserializeProjectMetadata [" + RestoreService.this.deserializeProjectMetadata + "] and cluster level customs " + String.valueOf(this.metadata.customs());
                for (Map.Entry entry : this.metadata.customs().entrySet()) {
                    if (!((Metadata.ClusterCustom)entry.getValue()).isRestorable()) continue;
                    mdBuilder.putCustom((String)entry.getKey(), (Metadata.ClusterCustom)entry.getValue());
                }
            }
            if (this.metadata.getProject(projectId).customs() != null) {
                for (Map.Entry entry : this.metadata.getProject(projectId).customs().entrySet()) {
                    if (!((Metadata.ProjectCustom)entry.getValue()).isRestorable()) continue;
                    projectBuilder.putCustom((String)entry.getKey(), (Metadata.ProjectCustom)entry.getValue());
                }
            }
        }

        private void ensureNoAliasNameConflicts(IndexMetadata snapshotIndexMetadata) {
            for (String aliasName : snapshotIndexMetadata.getAliases().keySet()) {
                IndexId indexId = this.indicesToRestore.get(aliasName);
                if (indexId == null) continue;
                throw new SnapshotRestoreException(this.snapshot, "cannot rename index [" + String.valueOf(indexId) + "] into [" + aliasName + "] because of conflict with an alias with the same name");
            }
        }

        private void populateIgnoredShards(String index, Set<Integer> ignoreShards) {
            for (SnapshotShardFailure failure : this.snapshotInfo.shardFailures()) {
                if (!index.equals(failure.index())) continue;
                ignoreShards.add(failure.shardId());
            }
        }

        private boolean checkPartial(String index) {
            if (RestoreService.failed(this.snapshotInfo, index)) {
                if (this.request.partial()) {
                    return true;
                }
                throw new SnapshotRestoreException(this.snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
            }
            return false;
        }

        private void validateExistingClosedIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
            if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
            }
            if (partial) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
            }
            if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
            }
        }

        @Override
        public void onFailure(Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.snapshot) + "] failed to restore snapshot", (Throwable)e);
            this.listener.clusterStateUpdate().onFailure(e);
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            logger.log(this.request.quiet() ? Level.DEBUG : Level.INFO, "started restore of snapshot [{}] for indices {}", (Object)this.snapshot, this.snapshotInfo.indices());
            this.listener.clusterStateUpdate().onResponse(new RestoreCompletionResponse(this.restoreUUID, this.snapshot, this.restoreInfo));
        }
    }

    public static class RestoreInProgressUpdater
    implements RoutingChangesObserver {
        private final Map<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>> shardChanges = new HashMap<String, Map<ShardId, RestoreInProgress.ShardRestoreStatus>>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes(recoverySource).put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.failure() != null && Lucene.isCorruptionException(unassignedInfo.failure().getCause())) {
                this.changes(recoverySource).put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.failure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes(unassignedShard.recoverySource()).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + String.valueOf(initializedShard.recoverySource())));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(recoverySource).put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Map<ShardId, RestoreInProgress.ShardRestoreStatus> changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new HashMap());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> updates = this.shardChanges.get(entry.uuid());
                    Map<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.isEmpty()) {
                        HashMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = Map.copyOf(shardsBuilder);
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.quiet(), entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }
    }

    public record RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
    }
}

