/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.DoubleValues;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class MedianAbsoluteDeviationAggregator
extends NumericMetricsAggregator.SingleDoubleValue {
    private final DocValueFormat format;
    private final double compression;
    private final TDigestExecutionHint executionHint;
    private ObjectArray<TDigestState> valueSketches;

    MedianAbsoluteDeviationAggregator(String name, ValuesSourceConfig config, DocValueFormat format, AggregationContext context, Aggregator parent, Map<String, Object> metadata, double compression, TDigestExecutionHint executionHint) throws IOException {
        super(name, config, context, parent, metadata);
        assert (config.hasValues());
        this.format = Objects.requireNonNull(format);
        this.compression = compression;
        this.executionHint = executionHint;
        this.valueSketches = context.bigArrays().newObjectArray(1L);
    }

    private boolean hasDataForBucket(long bucketOrd) {
        return bucketOrd < this.valueSketches.size() && this.valueSketches.get(bucketOrd) != null;
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.hasDataForBucket(owningBucketOrd)) {
            return InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valueSketches.get(owningBucketOrd));
        }
        return Double.NaN;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    TDigestState valueSketch = MedianAbsoluteDeviationAggregator.this.getExistingOrNewHistogram(MedianAbsoluteDeviationAggregator.this.bigArrays(), bucket);
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        valueSketch.add(values.nextValue());
                    }
                }
            }
        };
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final DoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    TDigestState valueSketch = MedianAbsoluteDeviationAggregator.this.getExistingOrNewHistogram(MedianAbsoluteDeviationAggregator.this.bigArrays(), bucket);
                    valueSketch.add(values.doubleValue());
                }
            }
        };
    }

    private TDigestState getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.valueSketches = bigArrays.grow(this.valueSketches, bucket + 1L);
        TDigestState state = this.valueSketches.get(bucket);
        if (state == null) {
            state = TDigestState.createWithoutCircuitBreaking(this.compression, this.executionHint);
            this.valueSketches.set(bucket, state);
        }
        return state;
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        if (this.hasDataForBucket(bucket)) {
            TDigestState valueSketch = this.valueSketches.get(bucket);
            return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, valueSketch);
        }
        return this.buildEmptyAggregation();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalMedianAbsoluteDeviation.empty(this.name, this.metadata(), this.format, this.compression, this.executionHint);
    }

    @Override
    public void doClose() {
        Releasables.close(this.valueSketches);
    }
}

