/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class NumericHistogramAggregator
extends AbstractHistogramAggregator {
    private final ValuesSource.Numeric valuesSource;

    public NumericHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinalityUpperBound, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
        DoubleValues singleton = FieldData.unwrapSingleton(values);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        double key = Math.floor((values.nextValue() - NumericHistogramAggregator.this.offset) / NumericHistogramAggregator.this.interval);
                        assert (key >= previousKey);
                        if (key == previousKey) continue;
                        NumericHistogramAggregator.this.addKey(key, doc, owningBucketOrd, sub);
                        previousKey = key;
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final DoubleValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    NumericHistogramAggregator.this.addKey(Math.floor((values.doubleValue() - NumericHistogramAggregator.this.offset) / NumericHistogramAggregator.this.interval), doc, owningBucketOrd, sub);
                }
            }
        };
    }

    private void addKey(double key, int doc, long owningBucketOrd, LeafBucketCollector sub) throws IOException {
        if (this.hardBounds == null || this.hardBounds.contain(key * this.interval)) {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                this.collectBucket(sub, doc, bucketOrd);
            }
        }
    }
}

