/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.core.SuppressForbidden;

class MergedDocValuesRangeQuery {
    MergedDocValuesRangeQuery() {
    }

    @SuppressForbidden(reason="Uses reflection to access package-private lucene class")
    public static Query merge(Query query, Query extraQuery) {
        Class<?> extraQueryClass;
        Class<?> queryClass = query.getClass();
        if (!queryClass.equals(extraQueryClass = extraQuery.getClass()) || !queryClass.getCanonicalName().equals("org.apache.lucene.document.SortedNumericDocValuesRangeQuery")) {
            return null;
        }
        try {
            Field fieldName = queryClass.getDeclaredField("field");
            fieldName.setAccessible(true);
            String field = fieldName.get(query).toString();
            if (!Objects.equals(field, fieldName.get(extraQuery))) {
                return null;
            }
            Field lowerValue = queryClass.getDeclaredField("lowerValue");
            Field upperValue = queryClass.getDeclaredField("upperValue");
            lowerValue.setAccessible(true);
            upperValue.setAccessible(true);
            long q1LowerValue = lowerValue.getLong(query);
            long q1UpperValue = upperValue.getLong(query);
            long q2LowerValue = lowerValue.getLong(extraQuery);
            long q2UpperValue = upperValue.getLong(extraQuery);
            if (q1UpperValue < q2LowerValue || q2UpperValue < q1LowerValue) {
                return new MatchNoDocsQuery("Non-overlapping range queries");
            }
            return NumericDocValuesField.newSlowRangeQuery((String)field, (long)Math.max(q1LowerValue, q2LowerValue), (long)Math.min(q1UpperValue, q2UpperValue));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

