/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.project.ProjectStateRegistry;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;

public class ReservedProjectStateUpdateTask
extends ReservedStateUpdateTask<ReservedProjectStateHandler<?>> {
    private final ProjectId projectId;

    public ReservedProjectStateUpdateTask(ProjectId projectId, String namespace, ReservedStateChunk stateChunk, ReservedStateVersionCheck versionCheck, Map<String, ReservedProjectStateHandler<?>> handlers, SequencedCollection<String> updateSequence, Consumer<ErrorState> errorReporter, ActionListener<ActionResponse.Empty> listener) {
        super(namespace, stateChunk, versionCheck, handlers, updateSequence, errorReporter, listener);
        this.projectId = projectId;
    }

    @Override
    protected Optional<ProjectId> projectId() {
        return Optional.of(this.projectId);
    }

    @Override
    protected TransformState transform(ReservedProjectStateHandler<?> handler, Object state, TransformState transformState) throws Exception {
        return ReservedClusterStateService.transform(handler, this.projectId, state, transformState);
    }

    @Override
    protected ClusterState remove(ReservedProjectStateHandler<?> handler, TransformState prevState) throws Exception {
        return ReservedClusterStateService.remove(handler, this.projectId, prevState);
    }

    @Override
    protected ClusterState execute(ClusterState currentState) {
        if (currentState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return currentState;
        }
        ProjectMetadata currentProject = ReservedClusterStateService.getPotentiallyNewProject(currentState, this.projectId);
        Tuple<ClusterState, ReservedStateMetadata> result = this.execute(ClusterState.builder(currentState).putProjectMetadata(currentProject).build(), ProjectStateRegistry.get(currentState).reservedStateMetadata(this.projectId));
        if (result == null) {
            return currentState;
        }
        ClusterState updatedClusterState = (ClusterState)result.v1();
        ProjectStateRegistry updatedProjectStateRegistry = updatedClusterState.custom("projects_registry", ProjectStateRegistry.EMPTY);
        ProjectMetadata updatedProjectMetadata = updatedClusterState.getMetadata().getProject(this.projectId);
        return ClusterState.builder(currentState).putCustom("projects_registry", ProjectStateRegistry.builder(updatedProjectStateRegistry).putReservedStateMetadata(this.projectId, (ReservedStateMetadata)result.v2()).build()).putProjectMetadata(updatedProjectMetadata).build();
    }
}

