/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.core.Strings;

public interface ActionWithReservedState<T> {
    default public Optional<String> reservedStateHandlerName() {
        return Optional.empty();
    }

    default public Set<String> modifiedKeys(T request) {
        return Collections.emptySet();
    }

    default public void validateForReservedState(Collection<ReservedStateMetadata> reservedStateMetadata, String handlerName, Set<String> modified, Supplier<String> requestSupplier) {
        ArrayList<String> errors = new ArrayList<String>();
        for (ReservedStateMetadata metadata : reservedStateMetadata) {
            Set<String> conflicts = metadata.conflicts(handlerName, modified);
            if (conflicts.isEmpty()) continue;
            errors.add(Strings.format((String)"[%s] set as read-only by [%s]", (Object[])new Object[]{String.join((CharSequence)", ", conflicts), metadata.namespace()}));
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(Strings.format((String)"Failed to process request [%s] with errors: [%s]", (Object[])new Object[]{requestSupplier.get(), String.join((CharSequence)", ", errors)}));
        }
    }
}

