/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.NodeAndClusterIdStateListener;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.health.HealthPeriodicLogger;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.monitor.fs.FsHealthService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.metrics.IndicesMetrics;
import org.elasticsearch.monitor.metrics.NodeMetrics;
import org.elasticsearch.node.NodeConstruction;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeServiceProvider;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.node.ShutdownPrepareService;
import org.elasticsearch.node.internal.TerminationHandler;
import org.elasticsearch.plugins.ClusterCoordinationPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.readiness.ReadinessService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.reservedstate.service.FileSettingsService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.TaskCancellationService;
import org.elasticsearch.tasks.TaskResultsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting<String> NODE_EXTERNAL_ID_SETTING = Setting.simpleString("node.external_id", NODE_NAME_SETTING, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting<String>("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                break;
            }
            default: {
                throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
            }
        }
        return s;
    }, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final Injector injector;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;
    private final TerminationHandler terminationHandler;
    final NamedWriteableRegistry namedWriteableRegistry;
    final NamedXContentRegistry namedXContentRegistry;

    public Node(Environment environment, PluginsLoader pluginsLoader) {
        this(NodeConstruction.prepareConstruction(environment, pluginsLoader, new NodeServiceProvider(), true));
    }

    Node(NodeConstruction construction) {
        this.injector = construction.injector();
        this.environment = construction.environment();
        this.nodeEnvironment = construction.nodeEnvironment();
        this.pluginsService = construction.pluginsService();
        this.client = construction.client();
        this.pluginLifecycleComponents = construction.pluginLifecycleComponents();
        this.localNodeFactory = construction.localNodeFactory();
        this.nodeService = construction.nodeService();
        this.terminationHandler = construction.terminationHandler();
        this.namedWriteableRegistry = construction.namedWriteableRegistry();
        this.namedXContentRegistry = construction.namedXContentRegistry();
    }

    @SuppressForbidden(reason="Cannot guarantee that the temp config path is relative to the environment")
    public static void deleteTemporaryApmConfig(JvmInfo jvmInfo, BiConsumer<Exception, Path> errorHandler) {
        for (String inputArgument : jvmInfo.getInputArguments()) {
            Path apmConfig;
            String APM_AGENT_CONFIG_FILE_REGEX;
            String agentArg;
            String[] parts;
            if (!inputArgument.startsWith("-javaagent:") || !(parts = (agentArg = inputArgument.substring(11)).split("=", 2))[0].matches(APM_AGENT_CONFIG_FILE_REGEX = String.join((CharSequence)("\\" + File.separator), ".*modules", "apm", "elastic-apm-agent-java8-\\d+\\.\\d+\\.\\d+\\.jar"))) continue;
            if (parts.length == 2 && parts[1].startsWith("c=") && (apmConfig = PathUtils.get((String)parts[1].substring(2), (String[])new String[0])).getFileName().toString().matches("^\\.elstcapm\\..*\\.tmp")) {
                try {
                    Files.deleteIfExists(apmConfig);
                }
                catch (IOException e) {
                    errorHandler.accept(e, apmConfig);
                }
            }
            return;
        }
    }

    public Settings settings() {
        return this.environment.settings();
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Coordinator coordinator;
        ClusterService clusterService;
        block19: {
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
            this.injector.getInstance(IndicesService.class).start();
            this.injector.getInstance(IndicesClusterStateService.class).start();
            this.injector.getInstance(SnapshotsService.class).start();
            this.injector.getInstance(SnapshotShardsService.class).start();
            this.injector.getInstance(RepositoriesService.class).start();
            this.injector.getInstance(SearchService.class).start();
            this.injector.getInstance(FsHealthService.class).start();
            this.injector.getInstance(NodeMetrics.class).start();
            this.injector.getInstance(IndicesMetrics.class).start();
            this.injector.getInstance(HealthPeriodicLogger.class).start();
            this.injector.getInstance(SamplingService.class).start();
            this.nodeService.getMonitorService().start();
            clusterService = this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            this.injector.getInstance(GatewayService.class).start();
            coordinator = this.injector.getInstance(Coordinator.class);
            clusterService.getMasterService().setClusterStatePublisher(coordinator);
            transportService = this.injector.getInstance(TransportService.class);
            transportService.getTaskManager().setTaskResultsService(this.injector.getInstance(TaskResultsService.class));
            transportService.getTaskManager().setTaskCancellationService(new TaskCancellationService(transportService));
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            this.injector.getInstance(PeerRecoverySourceService.class).start();
            gatewayMetaState = this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, this.injector.getInstance(MetaStateService.class), this.injector.getInstance(IndexMetadataVerifier.class), this.injector.getInstance(MetadataUpgrader.class), this.injector.getInstance(PersistedClusterStateService.class), this.pluginsService.filterPlugins(ClusterCoordinationPlugin.class).toList(), this.injector.getInstance(CompatibilityVersions.class));
            if (Assertions.ENABLED && !DiscoveryNode.isStateless(this.settings())) {
                try {
                    NodeMetadata nodeMetadata = NodeMetadata.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals(BuildVersion.current()));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(new BootstrapContext(this.environment, onDiskMetadata), transportService.boundAddress(), this.pluginsService.flatMap(Plugin::getBootstrapChecks).toList());
        FileSettingsService fileSettingsService = this.injector.getInstance(FileSettingsService.class);
        fileSettingsService.start();
        clusterService.addStateApplier(transportService.getTaskManager());
        coordinator.start();
        clusterService.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        this.injector.getInstance(CoordinationDiagnosticsService.class).start();
        coordinator.startInitialJoin();
        final TimeValue initialStateTimeout = INITIAL_STATE_TIMEOUT_SETTING.get(this.settings());
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger, thread.getThreadContext());
            if (clusterState.nodes().getMasterNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        Node.this.logger.warn("timed out after [{}={}] while waiting for initial discovery state; for troubleshooting guidance see [{}]", (Object)INITIAL_STATE_TIMEOUT_SETTING.getKey(), (Object)initialStateTimeout, (Object)ReferenceDocs.DISCOVERY_TROUBLESHOOTING);
                        latch.countDown();
                    }
                }, state -> state.nodes().getMasterNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        this.injector.getInstance(HttpServerTransport.class).start();
        if (ReadinessService.enabled(this.environment)) {
            this.injector.getInstance(ReadinessService.class).start();
        }
        if (WRITE_PORTS_FILE_SETTING.get(this.settings()).booleanValue()) {
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
            if (ReadinessService.enabled(this.environment)) {
                ReadinessService readiness = this.injector.getInstance(ReadinessService.class);
                readiness.addBoundAddressListener(address -> this.writePortsFile("readiness", address));
            }
            if (RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(this.environment.settings()).booleanValue()) {
                this.writePortsFile("remote_cluster", transport.boundRemoteAccessAddress());
            }
        }
        this.logger.info("started {}", (Object)transportService.getLocalNode());
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(ClusterPlugin::onNodeStarted);
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService, this.injector.getInstance(ThreadPool.class).getThreadContext());
    }

    private void stop() {
        if (!this.lifecycle.moveToStopped()) {
            return;
        }
        this.logger.info("stopping ...");
        if (ReadinessService.enabled(this.environment)) {
            this.stopIfStarted(ReadinessService.class);
        }
        this.stopIfStarted(HealthPeriodicLogger.class);
        this.stopIfStarted(SamplingService.class);
        this.stopIfStarted(FileSettingsService.class);
        this.injector.getInstance(ResourceWatcherService.class).close();
        this.stopIfStarted(HttpServerTransport.class);
        this.stopIfStarted(SnapshotsService.class);
        this.stopIfStarted(SnapshotShardsService.class);
        this.stopIfStarted(RepositoriesService.class);
        this.stopIfStarted(IndicesClusterStateService.class);
        this.stopIfStarted(Coordinator.class);
        this.stopIfStarted(ClusterService.class);
        this.stopIfStarted(NodeConnectionsService.class);
        this.stopIfStarted(FsHealthService.class);
        Node.stopIfStarted(this.nodeService.getMonitorService());
        this.stopIfStarted(GatewayService.class);
        this.stopIfStarted(SearchService.class);
        this.stopIfStarted(TransportService.class);
        this.stopIfStarted(NodeMetrics.class);
        this.stopIfStarted(IndicesMetrics.class);
        this.pluginLifecycleComponents.forEach(Node::stopIfStarted);
        this.stopIfStarted(IndicesService.class);
        this.logger.info("stopped");
    }

    private <T extends LifecycleComponent> void stopIfStarted(Class<T> componentClass) {
        Node.stopIfStarted((LifecycleComponent)this.injector.getInstance(componentClass));
    }

    private static void stopIfStarted(LifecycleComponent component) {
        if (component.lifecycleState() == Lifecycle.State.STARTED) {
            component.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Object> toClose = new ArrayList<Object>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add((Closeable)((Object)this.injector.getInstance(HttpServerTransport.class)));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SnapshotShardsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(RepositoriesService.class)));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesClusterStateService.class)));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesService.class)));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add((Closeable)((Object)this.injector.getInstance(PeerRecoverySourceService.class)));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add((Closeable)((Object)this.injector.getInstance(ClusterService.class)));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add((Closeable)((Object)this.injector.getInstance(NodeConnectionsService.class)));
        toClose.add(() -> stopWatch.stop().start("cluster_coordinator"));
        toClose.add((Closeable)((Object)this.injector.getInstance(Coordinator.class)));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.nodeService.getMonitorService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add((Closeable)((Object)this.injector.getInstance(FsHealthService.class)));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add((Closeable)((Object)this.injector.getInstance(GatewayService.class)));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add((Closeable)((Object)this.injector.getInstance(SearchService.class)));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add((Closeable)((Object)this.injector.getInstance(TransportService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(NodeMetrics.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(IndicesMetrics.class)));
        if (ReadinessService.enabled(this.environment)) {
            toClose.add((Closeable)((Object)this.injector.getInstance(ReadinessService.class)));
        }
        toClose.add((Closeable)((Object)this.injector.getInstance(FileSettingsService.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(HealthPeriodicLogger.class)));
        toClose.add((Closeable)((Object)this.injector.getInstance(SamplingService.class)));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        this.pluginsService.filterPlugins(Plugin.class).forEach(toClose::add);
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add(this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add(this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(stopWatch::stop);
        if (this.logger.isTraceEnabled()) {
            toClose.add(() -> this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint()));
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public void prepareForClose() {
        this.injector.getInstance(ShutdownPrepareService.class).prepareForShutdown(this.injector.getInstance(TransportService.class).getTaskManager());
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsDir().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsDir().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    static Settings mergePluginSettings(Map<String, Plugin> pluginMap, Settings originalSettings) {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Map.Entry<String, Plugin> entry : pluginMap.entrySet()) {
            Settings settings = entry.getValue().additionalSettings();
            for (String setting : settings.keySet()) {
                String oldPlugin = foundSettings.put(setting, entry.getKey());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + entry.getKey() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
        }
        return builder.put(originalSettings).build();
    }

    static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;

        LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            this.localNode.set((Object)DiscoveryNode.createLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }
}

