/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.spi.Message;

public final class ProvisionException
extends RuntimeException {
    private final Set<Message> messages;

    public ProvisionException(Iterable<Message> messages) {
        this.messages = Collections.unmodifiableSet(Sets.newHashSet(messages));
        if (this.messages.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice provision errors", this.messages);
    }
}

