/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.WrappingProcessor;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public class ConditionalProcessor
extends AbstractProcessor
implements WrappingProcessor {
    static final String TYPE = "conditional";
    private final Script condition;
    private final ScriptService scriptService;
    private final Processor processor;
    private final IngestMetric metric;
    private final LongSupplier relativeTimeProvider;
    private final IngestConditionalScript.Factory precompiledConditionalScriptFactory;

    ConditionalProcessor(String tag, String description, Script script, ScriptService scriptService, Processor processor) {
        this(tag, description, script, scriptService, processor, System::nanoTime);
    }

    ConditionalProcessor(String tag, String description, Script script, ScriptService scriptService, Processor processor, LongSupplier relativeTimeProvider) {
        super(tag, description);
        this.condition = script;
        this.scriptService = scriptService;
        this.processor = processor;
        this.metric = new IngestMetric();
        this.relativeTimeProvider = relativeTimeProvider;
        try {
            this.precompiledConditionalScriptFactory = ScriptType.INLINE.equals(script.getType()) ? scriptService.compile(script, IngestConditionalScript.CONTEXT) : null;
        }
        catch (ScriptException e) {
            throw ConfigurationUtils.newConfigurationException(TYPE, tag, null, e);
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        assert (!this.isAsync());
        boolean matches = this.evaluate(ingestDocument);
        if (matches) {
            long startTimeInNanos = this.relativeTimeProvider.getAsLong();
            try {
                this.metric.preIngest();
                IngestDocument ingestDocument2 = this.processor.execute(ingestDocument);
                return ingestDocument2;
            }
            catch (Exception e) {
                this.metric.ingestFailed();
                throw e;
            }
            finally {
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                this.metric.postIngest(ingestTimeInNanos);
            }
        }
        return ingestDocument;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        boolean matches;
        assert (this.isAsync());
        try {
            matches = this.evaluate(ingestDocument);
        }
        catch (Exception e2) {
            handler.accept(null, e2);
            return;
        }
        if (matches) {
            long startTimeInNanos = this.relativeTimeProvider.getAsLong();
            this.metric.preIngest();
            this.processor.execute(ingestDocument, (result, e) -> {
                long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
                this.metric.postIngest(ingestTimeInNanos);
                if (e != null) {
                    this.metric.ingestFailed();
                    handler.accept((IngestDocument)null, (Exception)e);
                } else {
                    handler.accept((IngestDocument)result, (Exception)null);
                }
            });
        } else {
            handler.accept(ingestDocument, null);
        }
    }

    boolean evaluate(IngestDocument ingestDocument) {
        IngestConditionalScript.Factory factory = this.precompiledConditionalScriptFactory;
        if (factory == null) {
            factory = this.scriptService.compile(this.condition, IngestConditionalScript.CONTEXT);
        }
        return factory.newInstance(this.condition.getParams(), ingestDocument.getUnmodifiableSourceAndMetadata()).execute();
    }

    @Override
    public Processor getInnerProcessor() {
        return this.processor;
    }

    IngestMetric getMetric() {
        return this.metric;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getCondition() {
        return this.condition.getIdOrCode();
    }
}

