/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.translog.Translog;

public final class TranslogHeaderWriter {
    public static final int FIXED_INDEX_HEADER_SIZE = 39;
    public static final int FIXED_DELETE_HEADER_SIZE = 30;
    public static final int FIXED_NO_OP_HEADER_SIZE = 21;
    public static final int OPERATION_TYPE_OFFSET = 4;
    public static final int SERIALIZATION_FORMAT_OFFSET = 5;
    public static final int VERSION_OFFSET = 6;
    public static final int SEQ_NO_OFFSET = 14;
    public static final int PRIMARY_TERM_OFFSET = 22;
    public static final int INDEX_AUTO_GENERATED_ID_TIMESTAMP_OFFSET = 30;
    public static final int INDEX_UID_LENGTH_OFFSET = 38;

    private TranslogHeaderWriter() {
    }

    public static void writeIndexHeader(RecyclerBytesStreamOutput buffer, Translog.Index index) throws IOException {
        int uidLen = index.uid().length;
        int uidVIntLen = RecyclerBytesStreamOutput.vIntLength(uidLen);
        BytesRef page = buffer.tryGetPageForWrite(39 + uidLen + uidVIntLen);
        if (page != null) {
            TranslogHeaderWriter.writeFastIndexHeader(buffer, index, page, uidVIntLen);
        } else {
            TranslogHeaderWriter.writeSlowIndexHeader(buffer, index);
        }
    }

    private static void writeFastIndexHeader(RecyclerBytesStreamOutput buffer, Translog.Index index, BytesRef page, int uidVIntLen) throws IOException {
        BytesReference source;
        BytesRef uid = index.uid();
        String routing = index.routing();
        int off = page.offset;
        byte[] bytes = page.bytes;
        bytes[off + 4] = Translog.Operation.Type.INDEX.id();
        bytes[off + 5] = 12;
        ByteUtils.writeLongBE(index.version(), bytes, off + 6);
        ByteUtils.writeLongBE(index.seqNo(), bytes, off + 14);
        ByteUtils.writeLongBE(index.primaryTerm(), bytes, off + 22);
        ByteUtils.writeLongBE(index.getAutoGeneratedIdTimestamp(), bytes, off + 30);
        StreamOutput.putVInt(bytes, uid.length, off + 38);
        System.arraycopy(uid.bytes, uid.offset, bytes, off + 38 + uidVIntLen, uid.length);
        bytes[off + 38 + uidVIntLen + uid.length] = index.routing() == null ? (byte)0 : 1;
        long variableLengthStart = buffer.position();
        if (routing != null) {
            buffer.writeString(routing);
        }
        int sourceLength = (source = index.source()) == null ? 0 : source.length();
        buffer.writeVInt(sourceLength);
        int variableLengthSize = (int)(buffer.position() - variableLengthStart);
        int sizeOfOperation = 35 + uidVIntLen + uid.length + variableLengthSize + sourceLength + 4;
        ByteUtils.writeIntBE(sizeOfOperation, bytes, off);
    }

    private static void writeSlowIndexHeader(RecyclerBytesStreamOutput buffer, Translog.Index index) throws IOException {
        long start = buffer.position();
        buffer.skip(4);
        buffer.writeByte(Translog.Operation.Type.INDEX.id());
        index.writeHeader(12, buffer);
        long end = buffer.position();
        int operationSize = (int)(end - 4L - start) + index.source().length() + 4;
        buffer.seek(start);
        buffer.writeInt(operationSize);
        buffer.seek(end);
    }

    public static void writeDeleteHeader(RecyclerBytesStreamOutput buffer, Translog.Delete delete) throws IOException {
        int uidLen = delete.uid().length;
        int uidVIntLen = RecyclerBytesStreamOutput.vIntLength(uidLen);
        BytesRef page = buffer.tryGetPageForWrite(30 + uidLen + uidVIntLen);
        if (page != null) {
            TranslogHeaderWriter.writeFastDeleteHeader(delete, page, uidVIntLen);
        } else {
            TranslogHeaderWriter.writeSlowDeleteHeader(buffer, delete);
        }
    }

    private static void writeFastDeleteHeader(Translog.Delete delete, BytesRef page, int uidVIntLen) throws IOException {
        BytesRef uid = delete.uid();
        int off = page.offset;
        byte[] bytes = page.bytes;
        bytes[off + 4] = Translog.Operation.Type.DELETE.id();
        bytes[off + 5] = 8;
        ByteUtils.writeLongBE(delete.version(), bytes, off + 6);
        ByteUtils.writeLongBE(delete.seqNo(), bytes, off + 14);
        ByteUtils.writeLongBE(delete.primaryTerm(), bytes, off + 22);
        StreamOutput.putVInt(bytes, uid.length, off + 30);
        System.arraycopy(uid.bytes, uid.offset, bytes, off + 30 + uidVIntLen, uid.length);
        int sizeOfOperation = 26 + uidVIntLen + uid.length + 4;
        ByteUtils.writeIntBE(sizeOfOperation, bytes, off);
    }

    private static void writeSlowDeleteHeader(RecyclerBytesStreamOutput buffer, Translog.Delete delete) throws IOException {
        long start = buffer.position();
        buffer.skip(4);
        buffer.writeByte(Translog.Operation.Type.DELETE.id());
        delete.writeHeader(8, buffer);
        long end = buffer.position();
        int operationSize = (int)(end - 4L - start) + 4;
        buffer.seek(start);
        buffer.writeInt(operationSize);
        buffer.seek(end);
    }

    public static void writeNoOpHeader(RecyclerBytesStreamOutput buffer, Translog.NoOp noop) throws IOException {
        BytesRef bytesRef = buffer.tryGetPageForWrite(21);
        if (bytesRef != null) {
            int off = bytesRef.offset;
            byte[] bytes = bytesRef.bytes;
            bytes[off + 4] = Translog.Operation.Type.NO_OP.id();
            ByteUtils.writeLongBE(noop.seqNo(), bytes, off + 5);
            ByteUtils.writeLongBE(noop.primaryTerm(), bytes, off + 13);
            long variableLengthStart = buffer.position();
            buffer.writeString(noop.reason());
            int variableLengthSize = (int)(buffer.position() - variableLengthStart);
            int sizeOfOperation = 17 + variableLengthSize + 4;
            ByteUtils.writeIntBE(sizeOfOperation, bytes, off);
        } else {
            TranslogHeaderWriter.writeSlowNoOpHeader(buffer, noop);
        }
    }

    private static void writeSlowNoOpHeader(RecyclerBytesStreamOutput buffer, Translog.NoOp noop) throws IOException {
        long start = buffer.position();
        buffer.skip(4);
        buffer.writeByte(Translog.Operation.Type.NO_OP.id());
        noop.writeHeader(-1, buffer);
        long end = buffer.position();
        int operationSize = (int)(end - 4L - start) + 4;
        buffer.seek(start);
        buffer.writeInt(operationSize);
        buffer.seek(end);
    }
}

