/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public abstract class AbstractBooleansBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    protected final String fieldName;

    public AbstractBooleansBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public final BlockLoader.BooleanBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.booleans(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
        if (docValues != null) {
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
            if (singleton != null) {
                return this.singletonReader(singleton);
            }
            return this.sortedReader(docValues);
        }
        NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
        if (singleton != null) {
            return this.singletonReader(singleton);
        }
        return new BlockLoader.ConstantNullsReader();
    }

    protected abstract BlockLoader.AllReader singletonReader(NumericDocValues var1);

    protected abstract BlockLoader.AllReader sortedReader(SortedNumericDocValues var1);

    static class Sorted
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        Sorted(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BooleanBuilder)builder);
        }

        private void read(int doc, BlockLoader.BooleanBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BooleansFromDocValues.Sorted";
        }
    }

    public static class Singleton
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        public Singleton(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendBoolean(this.numericDocValues.longValue() != 0L);
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.BooleanBuilder blockBuilder = (BlockLoader.BooleanBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendBoolean(this.numericDocValues.longValue() != 0L);
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BooleansFromDocValues.Singleton";
        }
    }
}

