/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.xcontent.XContentParser;

public class IpFallbackSyntheticSourceReader
extends FallbackSyntheticSourceBlockLoader.SingleValueReader<InetAddress> {
    public IpFallbackSyntheticSourceReader(Object nullValue) {
        super(nullValue);
    }

    @Override
    public void convertValue(Object value, List<InetAddress> accumulator) {
        try {
            if (value instanceof InetAddress) {
                InetAddress ia = (InetAddress)value;
                accumulator.add(ia);
            } else {
                InetAddress address = InetAddresses.forString(value.toString());
                accumulator.add(address);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeToBlock(List<InetAddress> values, BlockLoader.Builder blockBuilder) {
        BlockLoader.BytesRefBuilder builder = (BlockLoader.BytesRefBuilder)blockBuilder;
        for (InetAddress address : values) {
            BytesRef bytesRef = new BytesRef(InetAddressPoint.encode((InetAddress)address));
            builder.appendBytesRef(bytesRef);
        }
    }

    @Override
    protected void parseNonNullValue(XContentParser parser, List<InetAddress> accumulator) throws IOException {
        try {
            InetAddress address = InetAddresses.forString(parser.text());
            accumulator.add(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

