/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class ConstantFieldType
extends MappedFieldType {
    public ConstantFieldType(String name, Map<String, String> meta) {
        super(name, IndexType.NONE, false, meta);
        assert (this.isSearchable());
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    @Override
    public TextSearchInfo getTextSearchInfo() {
        return TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS;
    }

    protected abstract boolean matches(String var1, boolean var2, QueryRewriteContext var3);

    private static String valueToString(Object value) {
        return value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
    }

    @Override
    public final Query termQuery(Object value, SearchExecutionContext context) {
        return this.internalTermQuery(value, context);
    }

    public final Query internalTermQuery(Object value, QueryRewriteContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, false, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        return this.internalTermQueryCaseInsensitive(value, context);
    }

    public final Query internalTermQueryCaseInsensitive(Object value, QueryRewriteContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, true, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        return this.innerTermsQuery(values, context);
    }

    public final Query innerTermsQuery(Collection<?> values, QueryRewriteContext context) {
        for (Object value : values) {
            String pattern = ConstantFieldType.valueToString(value);
            if (!this.matches(pattern, false, context)) continue;
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query prefixQuery(String prefix, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        return this.prefixQuery(prefix, caseInsensitive, (QueryRewriteContext)context);
    }

    public final Query prefixQuery(String prefix, boolean caseInsensitive, QueryRewriteContext context) {
        String pattern = prefix + "*";
        if (this.matches(pattern, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        return this.wildcardQuery(value, caseInsensitive, (QueryRewriteContext)context);
    }

    public final Query wildcardQuery(String value, boolean caseInsensitive, QueryRewriteContext context) {
        if (this.matches(value, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    public Query wildcardLikeQuery(String value, boolean caseInsensitive, QueryRewriteContext context) {
        return this.wildcardQuery(value, caseInsensitive, context);
    }

    @Override
    public final boolean fieldHasValue(FieldInfos fieldInfos) {
        return true;
    }

    public abstract String getConstantFieldValue(SearchExecutionContext var1);

    @Override
    public Query automatonQuery(Supplier<Automaton> automatonSupplier, Supplier<CharacterRunAutomaton> characterRunAutomatonSupplier, @Nullable MultiTermQuery.RewriteMethod method, SearchExecutionContext context, String description) {
        CharacterRunAutomaton compiled = characterRunAutomatonSupplier.get();
        boolean matches = compiled.run(this.getConstantFieldValue(context));
        if (matches) {
            return new MatchAllDocsQuery();
        }
        return new MatchNoDocsQuery("The \"" + context.getFullyQualifiedIndex().getName() + "\" query was rewritten to a \"match_none\" query.");
    }
}

