/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.DoubleScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class DoubleScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    final DoubleFieldScript.LeafFactory leafFactory;
    private final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

    private DoubleScriptFieldData(String fieldName, DoubleFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    public DoubleScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public DoubleScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new DoubleScriptLeafFieldData(new DoubleScriptDocValues(this.leafFactory.newInstance(context)), this.toScriptFieldFactory);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    @Override
    protected IndexType indexType() {
        return IndexType.NONE;
    }

    public static class DoubleScriptLeafFieldData
    extends LeafDoubleFieldData {
        private final DoubleScriptDocValues doubleScriptDocValues;
        protected final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        DoubleScriptLeafFieldData(DoubleScriptDocValues doubleScriptDocValues, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.doubleScriptDocValues = doubleScriptDocValues;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            return this.doubleScriptDocValues;
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getDoubleValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final DoubleFieldScript.LeafFactory leafFactory;
        protected final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        public Builder(String name, DoubleFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public DoubleScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new DoubleScriptFieldData(this.name, this.leafFactory, this.toScriptFieldFactory);
        }
    }
}

