/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.zstd;

import java.io.IOException;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.Zstd;

public class ZstdCompressionMode
extends CompressionMode {
    private final int level;

    public ZstdCompressionMode(int level) {
        this.level = level;
    }

    public Compressor newCompressor() {
        return new ZstdCompressor(this.level);
    }

    public Decompressor newDecompressor() {
        return new ZstdDecompressor();
    }

    public String toString() {
        return "ZSTD(level=" + this.level + ")";
    }

    private static final class ZstdCompressor
    extends Compressor {
        final int level;
        final byte[] copyBuffer = new byte[4096];

        private ZstdCompressor(int level) {
            this.level = level;
        }

        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            NativeAccess nativeAccess = NativeAccess.instance();
            Zstd zstd = nativeAccess.getZstd();
            int srcLen = Math.toIntExact(buffersInput.length());
            if (srcLen == 0) {
                return;
            }
            int compressBound = zstd.compressBound(srcLen);
            try (CloseableByteBuffer src = nativeAccess.newConfinedBuffer(srcLen);
                 CloseableByteBuffer dest = nativeAccess.newConfinedBuffer(compressBound);){
                while (buffersInput.position() < buffersInput.length()) {
                    int numBytes = Math.min(this.copyBuffer.length, (int)(buffersInput.length() - buffersInput.position()));
                    buffersInput.readBytes(this.copyBuffer, 0, numBytes);
                    src.buffer().put(this.copyBuffer, 0, numBytes);
                }
                src.buffer().flip();
                int compressedLen = zstd.compress(dest, src, this.level);
                out.writeVInt(compressedLen);
                int written = 0;
                while (written < compressedLen) {
                    int numBytes = Math.min(this.copyBuffer.length, compressedLen - written);
                    dest.buffer().get(this.copyBuffer, 0, numBytes);
                    out.writeBytes(this.copyBuffer, 0, numBytes);
                    assert ((written += numBytes) == dest.buffer().position());
                }
            }
        }

        public void close() throws IOException {
        }
    }

    private static final class ZstdDecompressor
    extends Decompressor {
        final byte[] copyBuffer = new byte[4096];

        private ZstdDecompressor() {
        }

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            if (originalLength == 0) {
                bytes.offset = 0;
                bytes.length = 0;
                return;
            }
            NativeAccess nativeAccess = NativeAccess.instance();
            Zstd zstd = nativeAccess.getZstd();
            int compressedLength = in.readVInt();
            try (CloseableByteBuffer src = nativeAccess.newConfinedBuffer(compressedLength);
                 CloseableByteBuffer dest = nativeAccess.newConfinedBuffer(originalLength);){
                while (src.buffer().position() < compressedLength) {
                    int numBytes = Math.min(this.copyBuffer.length, compressedLength - src.buffer().position());
                    in.readBytes(this.copyBuffer, 0, numBytes);
                    src.buffer().put(this.copyBuffer, 0, numBytes);
                }
                src.buffer().flip();
                int decompressedLen = zstd.decompress(dest, src);
                if (decompressedLen != originalLength) {
                    throw new CorruptIndexException("Expected " + originalLength + " decompressed bytes, got " + decompressedLen, in);
                }
                bytes.bytes = ArrayUtil.growNoCopy((byte[])bytes.bytes, (int)length);
                dest.buffer().get(offset, bytes.bytes, 0, length);
                bytes.offset = 0;
                bytes.length = length;
            }
        }

        public Decompressor clone() {
            return new ZstdDecompressor();
        }
    }
}

