/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

public record CentroidAssignments(int numCentroids, float[][] centroids, int[] assignments, int[] overspillAssignments, float[] globalCentroid) {
    public CentroidAssignments(int dims, float[][] centroids, int[] assignments, int[] overspillAssignments) {
        this(centroids.length, centroids, assignments, overspillAssignments, CentroidAssignments.computeGlobalCentroid(dims, centroids));
        assert (assignments.length == overspillAssignments.length || overspillAssignments.length == 0) : "assignments and overspillAssignments must have the same length";
    }

    private static float[] computeGlobalCentroid(int dims, float[][] centroids) {
        float[] globalCentroid = new float[dims];
        for (float[] centroid : centroids) {
            assert (centroid.length == dims);
            for (int j = 0; j < centroid.length; ++j) {
                int n = j;
                globalCentroid[n] = globalCentroid[n] + centroid[j];
            }
        }
        int j = 0;
        while (j < globalCentroid.length) {
            int n = j++;
            globalCentroid[n] = globalCentroid[n] / (float)centroids.length;
        }
        return globalCentroid;
    }
}

