/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;

public class GenericFlatVectorReaders {
    private final Map<FlatVectorsReaderKey, FlatVectorsReader> readers = new HashMap<FlatVectorsReaderKey, FlatVectorsReader>();
    private final Map<Integer, FlatVectorsReader> readersForFields = new HashMap<Integer, FlatVectorsReader>();

    public void loadField(int fieldNumber, Field field, LoadFlatVectorsReader loadReader) throws IOException {
        FlatVectorsReaderKey key = new FlatVectorsReaderKey(field);
        FlatVectorsReader reader = this.readers.get(key);
        if (reader == null) {
            reader = loadReader.getReader(field.rawVectorFormatName(), field.useDirectIOReads());
            if (reader == null) {
                throw new IllegalStateException("Cannot find flat vector format: " + field.rawVectorFormatName());
            }
            this.readers.put(key, reader);
        }
        this.readersForFields.put(fieldNumber, reader);
    }

    public FlatVectorsReader getReaderForField(int fieldNumber) {
        FlatVectorsReader reader = this.readersForFields.get(fieldNumber);
        if (reader == null) {
            throw new IllegalArgumentException("Invalid field number [" + fieldNumber + "]");
        }
        return reader;
    }

    public Collection<FlatVectorsReader> allReaders() {
        return Collections.unmodifiableCollection(this.readers.values());
    }

    public GenericFlatVectorReaders getMergeInstance() throws IOException {
        GenericFlatVectorReaders mergeReaders = new GenericFlatVectorReaders();
        IdentityHashMap<FlatVectorsReader, FlatVectorsReader> mergeInstances = new IdentityHashMap<FlatVectorsReader, FlatVectorsReader>();
        for (Map.Entry<FlatVectorsReaderKey, FlatVectorsReader> entry : this.readers.entrySet()) {
            FlatVectorsReader mergeInstance = entry.getValue().getMergeInstance();
            mergeInstances.put(entry.getValue(), mergeInstance);
            mergeReaders.readers.put(entry.getKey(), mergeInstance);
        }
        for (Map.Entry<Object, FlatVectorsReader> entry : this.readersForFields.entrySet()) {
            mergeReaders.readersForFields.put((Integer)entry.getKey(), (FlatVectorsReader)mergeInstances.get(entry.getValue()));
        }
        return mergeReaders;
    }

    private record FlatVectorsReaderKey(String formatName, boolean useDirectIO) {
        private FlatVectorsReaderKey(Field field) {
            this(field.rawVectorFormatName(), field.useDirectIOReads());
        }

        @Override
        public String toString() {
            return this.formatName + (this.useDirectIO ? " with Direct IO" : "");
        }
    }

    public static interface Field {
        public String rawVectorFormatName();

        public boolean useDirectIOReads();
    }

    @FunctionalInterface
    public static interface LoadFlatVectorsReader {
        public FlatVectorsReader getReader(String var1, boolean var2) throws IOException;
    }
}

