/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

public class BytesReferenceIndexInput
extends IndexInput {
    private final BytesReference bytesReference;
    private int filePointer;
    private StreamInput streamInput;

    public BytesReferenceIndexInput(String resourceDescription, BytesReference bytesReference) {
        this(resourceDescription, bytesReference, 0);
    }

    private BytesReferenceIndexInput(String resourceDescription, BytesReference bytesReference, int filePointer) {
        super(resourceDescription);
        this.bytesReference = bytesReference;
        this.filePointer = filePointer;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    private StreamInput getOrOpenStreamInput() throws IOException {
        if (this.streamInput == null) {
            this.streamInput = this.bytesReference.slice(this.filePointer, this.bytesReference.length() - this.filePointer).streamInput();
        }
        return this.streamInput;
    }

    public void seek(long longPos) throws IOException {
        if (longPos < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + longPos);
        }
        if (longPos > (long)this.bytesReference.length()) {
            throw new EOFException("seek past EOF");
        }
        int pos = (int)longPos;
        if (pos < this.filePointer) {
            this.streamInput = null;
        } else if (this.streamInput != null) {
            int toSkip = pos - this.filePointer;
            long skipped = this.streamInput.skip(toSkip);
            assert (skipped == (long)toSkip);
        }
        this.filePointer = pos;
    }

    public long length() {
        return this.bytesReference.length();
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset >= 0L && length >= 0L && offset + length <= (long)this.bytesReference.length()) {
            return new BytesReferenceIndexInput(sliceDescription, this.bytesReference.slice((int)offset, (int)length));
        }
        throw new IllegalArgumentException(Strings.format("slice() %s out of bounds: offset=%d,length=%d,fileLength=%d: %s", new Object[]{sliceDescription, offset, length, this.bytesReference.length(), this}));
    }

    public byte readByte() throws IOException {
        try {
            byte by = this.getOrOpenStreamInput().readByte();
            return by;
        }
        finally {
            ++this.filePointer;
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.getOrOpenStreamInput().readBytes(b, offset, len);
        this.filePointer += len;
    }

    public short readShort() throws IOException {
        try {
            short s = Short.reverseBytes(this.getOrOpenStreamInput().readShort());
            return s;
        }
        finally {
            this.filePointer += 2;
        }
    }

    public int readInt() throws IOException {
        try {
            int n = Integer.reverseBytes(this.getOrOpenStreamInput().readInt());
            return n;
        }
        finally {
            this.filePointer += 4;
        }
    }

    public long readLong() throws IOException {
        try {
            long l = Long.reverseBytes(this.getOrOpenStreamInput().readLong());
            return l;
        }
        finally {
            this.filePointer += 8;
        }
    }

    public IndexInput clone() {
        return new BytesReferenceIndexInput(this.toString(), this.bytesReference, this.filePointer);
    }
}

