/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.UnsupportedSelectorException;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.search.crossproject.CrossProjectIndexExpressionsRewriter;
import org.elasticsearch.search.crossproject.TargetProjects;

public class IndexAbstractionResolver {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public IndexAbstractionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public ResolvedIndexExpressions resolveIndexAbstractions(List<String> indices, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, Function<IndexComponentSelector, Set<String>> allAuthorizedAndAvailableBySelector, BiPredicate<String, IndexComponentSelector> isAuthorized, boolean includeDataStreams) {
        ResolvedIndexExpressions.Builder resolvedExpressionsBuilder = ResolvedIndexExpressions.builder();
        boolean wildcardSeen = false;
        for (String originalIndexExpression : indices) {
            wildcardSeen = this.resolveIndexAbstraction(resolvedExpressionsBuilder, originalIndexExpression, originalIndexExpression, indicesOptions, projectMetadata, allAuthorizedAndAvailableBySelector, isAuthorized, includeDataStreams, Set.of(), wildcardSeen);
        }
        return resolvedExpressionsBuilder.build();
    }

    public ResolvedIndexExpressions resolveIndexAbstractions(List<String> indices, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, Function<IndexComponentSelector, Set<String>> allAuthorizedAndAvailableBySelector, BiPredicate<String, IndexComponentSelector> isAuthorized, TargetProjects targetProjects, boolean includeDataStreams) {
        if (targetProjects == TargetProjects.LOCAL_ONLY_FOR_CPS_DISABLED) {
            String message = "cannot resolve indices cross project if target set is local only";
            assert (false) : "cannot resolve indices cross project if target set is local only";
            throw new IllegalArgumentException("cannot resolve indices cross project if target set is local only");
        }
        String originProjectAlias = targetProjects.originProjectAlias();
        Set<String> linkedProjectAliases = targetProjects.allProjectAliases();
        ResolvedIndexExpressions.Builder resolvedExpressionsBuilder = ResolvedIndexExpressions.builder();
        boolean wildcardSeen = false;
        for (String originalIndexExpression : indices) {
            CrossProjectIndexExpressionsRewriter.IndexRewriteResult indexRewriteResult = CrossProjectIndexExpressionsRewriter.rewriteIndexExpression(originalIndexExpression, originProjectAlias, linkedProjectAliases);
            String localIndexExpression = indexRewriteResult.localExpression();
            if (localIndexExpression == null) {
                resolvedExpressionsBuilder.addRemoteExpressions(originalIndexExpression, indexRewriteResult.remoteExpressions());
                continue;
            }
            wildcardSeen = this.resolveIndexAbstraction(resolvedExpressionsBuilder, originalIndexExpression, localIndexExpression, indicesOptions, projectMetadata, allAuthorizedAndAvailableBySelector, isAuthorized, includeDataStreams, indexRewriteResult.remoteExpressions(), wildcardSeen);
        }
        return resolvedExpressionsBuilder.build();
    }

    private boolean resolveIndexAbstraction(ResolvedIndexExpressions.Builder resolvedExpressionsBuilder, String originalIndexExpression, String localIndexExpression, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, Function<IndexComponentSelector, Set<String>> allAuthorizedAndAvailableBySelector, BiPredicate<String, IndexComponentSelector> isAuthorized, boolean includeDataStreams, Set<String> remoteExpressions, boolean wildcardSeen) {
        String indexAbstraction;
        boolean minus = false;
        if (localIndexExpression.charAt(0) == '-' && wildcardSeen) {
            indexAbstraction = localIndexExpression.substring(1);
            minus = true;
        } else {
            indexAbstraction = localIndexExpression;
        }
        Tuple<String, String> expressionAndSelector = IndexNameExpressionResolver.splitSelectorExpression(indexAbstraction);
        String selectorString = (String)expressionAndSelector.v2();
        if (!indicesOptions.allowSelectors() && selectorString != null) {
            throw new UnsupportedSelectorException(indexAbstraction);
        }
        indexAbstraction = (String)expressionAndSelector.v1();
        IndexComponentSelector selector = IndexComponentSelector.getByKeyOrThrow(selectorString);
        indexAbstraction = IndexNameExpressionResolver.resolveDateMathExpression(indexAbstraction);
        if (indicesOptions.expandWildcardExpressions() && Regex.isSimpleMatchPattern(indexAbstraction)) {
            wildcardSeen = true;
            HashSet<String> resolvedIndices = new HashSet<String>();
            for (String authorizedIndex : allAuthorizedAndAvailableBySelector.apply(selector)) {
                if (!Regex.simpleMatch(indexAbstraction, authorizedIndex) || !IndexAbstractionResolver.isIndexVisible(indexAbstraction, selectorString, authorizedIndex, indicesOptions, projectMetadata, this.indexNameExpressionResolver, includeDataStreams)) continue;
                IndexAbstractionResolver.resolveSelectorsAndCollect(authorizedIndex, selectorString, indicesOptions, resolvedIndices, projectMetadata);
            }
            if (resolvedIndices.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) {
                    throw new IndexNotFoundException(indexAbstraction);
                }
                resolvedExpressionsBuilder.addExpressions(originalIndexExpression, new HashSet<String>(), ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS, remoteExpressions);
            } else if (minus) {
                resolvedExpressionsBuilder.excludeFromLocalExpressions(resolvedIndices);
            } else {
                resolvedExpressionsBuilder.addExpressions(originalIndexExpression, resolvedIndices, ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS, remoteExpressions);
            }
        } else {
            HashSet<String> resolvedIndices = new HashSet<String>();
            IndexAbstractionResolver.resolveSelectorsAndCollect(indexAbstraction, selectorString, indicesOptions, resolvedIndices, projectMetadata);
            if (minus) {
                resolvedExpressionsBuilder.excludeFromLocalExpressions(resolvedIndices);
            } else {
                boolean authorized = isAuthorized.test(indexAbstraction, selector);
                if (authorized) {
                    boolean visible = IndexAbstractionResolver.indexExists(projectMetadata, indexAbstraction) && IndexAbstractionResolver.isIndexVisible(indexAbstraction, selectorString, indexAbstraction, indicesOptions, projectMetadata, this.indexNameExpressionResolver, includeDataStreams);
                    ResolvedIndexExpression.LocalIndexResolutionResult result = visible ? ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS : ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE;
                    resolvedExpressionsBuilder.addExpressions(originalIndexExpression, resolvedIndices, result, remoteExpressions);
                } else if (indicesOptions.ignoreUnavailable()) {
                    resolvedExpressionsBuilder.addExpressions(originalIndexExpression, new HashSet<String>(), ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_UNAUTHORIZED, remoteExpressions);
                } else {
                    resolvedExpressionsBuilder.addExpressions(originalIndexExpression, resolvedIndices, ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_UNAUTHORIZED, remoteExpressions);
                }
            }
        }
        return wildcardSeen;
    }

    private static void resolveSelectorsAndCollect(String indexAbstraction, String selectorString, IndicesOptions indicesOptions, Set<String> collect, ProjectMetadata projectMetadata) {
        if (indicesOptions.allowSelectors()) {
            boolean acceptsAllSelectors;
            IndexAbstraction abstraction = (IndexAbstraction)projectMetadata.getIndicesLookup().get(indexAbstraction);
            boolean bl = acceptsAllSelectors = abstraction == null || abstraction.isDataStreamRelated();
            if (selectorString == null) {
                selectorString = IndexComponentSelector.DATA.getKey();
            }
            collect.add(IndexNameExpressionResolver.combineSelectorExpression(indexAbstraction, selectorString));
        } else {
            assert (selectorString == null) : "A selector string [" + selectorString + "] is present but selectors are disabled in this context";
            collect.add(indexAbstraction);
        }
    }

    public static boolean isIndexVisible(String expression, @Nullable String selectorString, String index, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, IndexNameExpressionResolver resolver, boolean includeDataStreams) {
        IndexComponentSelector selector;
        boolean isVisible;
        IndexAbstraction indexAbstraction = (IndexAbstraction)projectMetadata.getIndicesLookup().get(index);
        if (indexAbstraction == null) {
            throw new IllegalStateException("could not resolve index abstraction [" + index + "]");
        }
        boolean isHidden = indexAbstraction.isHidden();
        boolean bl = isVisible = !isHidden || indicesOptions.expandWildcardsHidden() || IndexAbstractionResolver.isVisibleDueToImplicitHidden(expression, index);
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
            IndexComponentSelector selector2;
            boolean bl2 = isVisible = isVisible && !indicesOptions.ignoreAliases();
            if (isVisible && indexAbstraction.isSystem() && resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName())) {
                Index writeIndex = indexAbstraction.getWriteIndex();
                if (writeIndex == null) {
                    return false;
                }
                return IndexAbstractionResolver.isIndexVisible(expression, selectorString, writeIndex.getName(), indicesOptions, projectMetadata, resolver, includeDataStreams);
            }
            if (isVisible && selectorString != null && IndexComponentSelector.FAILURES.equals(selector2 = IndexComponentSelector.getByKey(selectorString))) {
                isVisible = indexAbstraction.isDataStreamRelated();
            }
            return isVisible;
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            if (!includeDataStreams) {
                return false;
            }
            if (indexAbstraction.isSystem()) {
                return IndexAbstractionResolver.isSystemIndexVisible(resolver, indexAbstraction);
            }
            return isVisible;
        }
        assert (indexAbstraction.getIndices().size() == 1) : "concrete index must point to a single index";
        if (!isVisible) {
            return false;
        }
        if (indexAbstraction.isSystem()) {
            if (resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName())) {
                return IndexAbstractionResolver.isSystemIndexVisible(resolver, indexAbstraction);
            }
            if (indexAbstraction.getParentDataStream() != null) {
                if (!indexAbstraction.getParentDataStream().isSystem()) {
                    assert (false) : "system index is part of a data stream that is not a system data stream";
                    throw new IllegalStateException("system index is part of a data stream that is not a system data stream");
                }
                return IndexAbstractionResolver.isSystemIndexVisible(resolver, indexAbstraction);
            }
        }
        if (selectorString != null && !Regex.isMatchAllPattern(selectorString) && IndexComponentSelector.FAILURES.equals(selector = IndexComponentSelector.getByKey(selectorString))) {
            return false;
        }
        IndexMetadata indexMetadata = projectMetadata.index(indexAbstraction.getIndices().get(0));
        if (indexMetadata.getState() == IndexMetadata.State.CLOSE && indicesOptions.expandWildcardsClosed()) {
            return true;
        }
        return indexMetadata.getState() == IndexMetadata.State.OPEN && indicesOptions.expandWildcardsOpen();
    }

    private static boolean isSystemIndexVisible(IndexNameExpressionResolver resolver, IndexAbstraction indexAbstraction) {
        SystemIndices.SystemIndexAccessLevel level = resolver.getSystemIndexAccessLevel();
        switch (level) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case RESTRICTED: {
                return resolver.getSystemIndexAccessPredicate().test(indexAbstraction.getName());
            }
            case BACKWARDS_COMPATIBLE_ONLY: {
                return resolver.getNetNewSystemIndexPredicate().test(indexAbstraction.getName());
            }
        }
        assert (false) : "unexpected system index access level [" + String.valueOf((Object)level) + "]";
        throw new IllegalStateException("unexpected system index access level [" + String.valueOf((Object)level) + "]");
    }

    private static boolean isVisibleDueToImplicitHidden(String expression, String index) {
        return index.startsWith(".") && expression.startsWith(".") && Regex.isSimpleMatchPattern(expression);
    }

    private static boolean indexExists(ProjectMetadata projectMetadata, String indexAbstraction) {
        return projectMetadata.getIndicesLookup().get(indexAbstraction) != null;
    }
}

