/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamLifecycle
implements SimpleDiffable<DataStreamLifecycle>,
ToXContentObject {
    public static final TransportVersion ADDED_ENABLED_FLAG_VERSION = TransportVersions.V_8_10_X;
    public static final TransportVersion ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM = TransportVersion.fromName("add_sample_method_downsample_dlm");
    public static final String EFFECTIVE_RETENTION_REST_API_CAPABILITY = "data_stream_lifecycle_effective_retention";
    public static final String DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME = "data_streams.lifecycle_only.mode";
    public static final String INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME = "include_effective_retention";
    public static final Map<String, String> INCLUDE_EFFECTIVE_RETENTION_PARAMS = Map.of("include_effective_retention", "true");
    public static final Tuple<TimeValue, RetentionSource> INFINITE_RETENTION = Tuple.tuple(null, (Object)((Object)RetentionSource.DATA_STREAM_CONFIGURATION));
    private static final String DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE = "Failure store lifecycle does not support downsampling, please remove the downsampling configuration.";
    private static final TransportVersion INTRODUCE_LIFECYCLE_TEMPLATE = TransportVersion.fromName("introduce_lifecycle_template");
    public static final String DOWNSAMPLING_METHOD_WITHOUT_ROUNDS_ERROR = "Downsampling method can only be set when there is at least one downsampling round.";
    public static final Setting<RolloverConfiguration> CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING = new Setting<RolloverConfiguration>("cluster.lifecycle.default.rollover", "max_age=auto,max_primary_shard_size=50gb,min_docs=1,max_primary_shard_docs=200000000", s -> RolloverConfiguration.parseSetting(s, "cluster.lifecycle.default.rollover"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final DataStreamLifecycle DEFAULT_DATA_LIFECYCLE = DataStreamLifecycle.createDataLifecycle(null, null, null, null);
    public static final DataStreamLifecycle DEFAULT_FAILURE_LIFECYCLE = DataStreamLifecycle.createFailuresLifecycle(null, null);
    public static final String DATA_STREAM_LIFECYCLE_ORIGIN = "data_stream_lifecycle";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField DATA_RETENTION_FIELD = new ParseField("data_retention", new String[0]);
    public static final ParseField EFFECTIVE_RETENTION_FIELD = new ParseField("effective_retention", new String[0]);
    public static final ParseField RETENTION_SOURCE_FIELD = new ParseField("retention_determined_by", new String[0]);
    public static final ParseField DOWNSAMPLING_FIELD = new ParseField("downsampling", new String[0]);
    public static final ParseField DOWNSAMPLING_METHOD_FIELD = new ParseField("downsampling_method", new String[0]);
    private static final ParseField ROLLOVER_FIELD = new ParseField("rollover", new String[0]);
    public static final ConstructingObjectParser<DataStreamLifecycle, LifecycleType> PARSER = new ConstructingObjectParser("lifecycle", false, (args, lt) -> new DataStreamLifecycle((LifecycleType)lt, (Boolean)args[0], (TimeValue)args[1], (List)args[2], (DownsampleConfig.SamplingMethod)args[3]));
    private static final TransportVersion INTRODUCE_FAILURES_LIFECYCLE;
    private final LifecycleType lifecycleType;
    private final boolean enabled;
    @Nullable
    private final TimeValue dataRetention;
    @Nullable
    private final List<DownsamplingRound> downsamplingRounds;
    @Nullable
    private final DownsampleConfig.SamplingMethod downsamplingMethod;

    public static boolean isDataStreamsLifecycleOnlyMode(Settings settings) {
        return settings.getAsBoolean(DATA_STREAMS_LIFECYCLE_ONLY_SETTING_NAME, false);
    }

    DataStreamLifecycle(LifecycleType lifecycleType, @Nullable Boolean enabled, @Nullable TimeValue dataRetention, @Nullable List<DownsamplingRound> downsamplingRounds, @Nullable DownsampleConfig.SamplingMethod downsamplingMethod) {
        this.lifecycleType = lifecycleType;
        this.enabled = enabled == null || enabled != false;
        this.dataRetention = dataRetention;
        if (lifecycleType == LifecycleType.FAILURES && downsamplingRounds != null) {
            throw new IllegalArgumentException(DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE);
        }
        DownsamplingRound.validateRounds(downsamplingRounds);
        this.downsamplingRounds = downsamplingRounds;
        if (downsamplingMethod != null && downsamplingRounds == null) {
            throw new IllegalArgumentException(DOWNSAMPLING_METHOD_WITHOUT_ROUNDS_ERROR);
        }
        this.downsamplingMethod = downsamplingMethod;
    }

    public static DataStreamLifecycle createDataLifecycle(@Nullable Boolean enabled, @Nullable TimeValue dataRetention, @Nullable List<DownsamplingRound> downsamplingRounds, @Nullable DownsampleConfig.SamplingMethod downsamplingMethod) {
        return new DataStreamLifecycle(LifecycleType.DATA, enabled, dataRetention, downsamplingRounds, downsamplingMethod);
    }

    public static DataStreamLifecycle createFailuresLifecycle(@Nullable Boolean enabled, @Nullable TimeValue dataRetention) {
        return new DataStreamLifecycle(LifecycleType.FAILURES, enabled, dataRetention, null, null);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean targetsFailureStore() {
        return this.lifecycleType == LifecycleType.FAILURES;
    }

    public String getLifecycleType() {
        return this.lifecycleType.label;
    }

    @Nullable
    public TimeValue getEffectiveDataRetention(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        return (TimeValue)this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream).v1();
    }

    public Tuple<TimeValue, RetentionSource> getEffectiveDataRetentionWithSource(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (!this.enabled()) {
            return INFINITE_RETENTION;
        }
        if (globalRetention == null || isInternalDataStream) {
            return Tuple.tuple((Object)this.dataRetention(), (Object)((Object)RetentionSource.DATA_STREAM_CONFIGURATION));
        }
        if (this.dataRetention() == null) {
            return globalRetention.defaultRetention() != null ? Tuple.tuple((Object)globalRetention.defaultRetention(), (Object)((Object)(this.targetsFailureStore() ? RetentionSource.DEFAULT_FAILURES_RETENTION : RetentionSource.DEFAULT_GLOBAL_RETENTION))) : Tuple.tuple((Object)globalRetention.maxRetention(), (Object)((Object)RetentionSource.MAX_GLOBAL_RETENTION));
        }
        if (globalRetention.maxRetention() != null && globalRetention.maxRetention().getMillis() < this.dataRetention().getMillis()) {
            return Tuple.tuple((Object)globalRetention.maxRetention(), (Object)((Object)RetentionSource.MAX_GLOBAL_RETENTION));
        }
        return Tuple.tuple((Object)this.dataRetention(), (Object)((Object)RetentionSource.DATA_STREAM_CONFIGURATION));
    }

    @Nullable
    public TimeValue dataRetention() {
        return this.dataRetention;
    }

    public void addWarningHeaderIfDataRetentionNotEffective(@Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) {
        if (globalRetention == null || isInternalDataStream) {
            return;
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (effectiveDataRetentionWithSource.v1() == null) {
            return;
        }
        String effectiveRetentionStringRep = ((TimeValue)effectiveDataRetentionWithSource.v1()).getStringRep();
        switch (((RetentionSource)((Object)effectiveDataRetentionWithSource.v2())).ordinal()) {
            case 1: {
                HeaderWarning.addWarning("Not providing a retention is not allowed for this project. The default retention of [" + effectiveRetentionStringRep + "] will be applied.", new Object[0]);
                break;
            }
            case 2: {
                String retentionProvidedPart = this.dataRetention() == null ? "Not providing a retention is not allowed for this project." : "The retention provided [" + (this.dataRetention() == null ? "infinite" : this.dataRetention().getStringRep()) + "] is exceeding the max allowed data retention of this project [" + effectiveRetentionStringRep + "].";
                HeaderWarning.addWarning(retentionProvidedPart + " The max retention of [" + effectiveRetentionStringRep + "] will be applied", new Object[0]);
                break;
            }
        }
    }

    @Nullable
    public List<DownsamplingRound> downsamplingRounds() {
        return this.downsamplingRounds;
    }

    @Nullable
    public DownsampleConfig.SamplingMethod downsamplingMethod() {
        return this.downsamplingMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamLifecycle that = (DataStreamLifecycle)o;
        return this.lifecycleType == that.lifecycleType && Objects.equals(this.dataRetention, that.dataRetention) && Objects.equals(this.downsamplingRounds, that.downsamplingRounds) && Objects.equals(this.downsamplingMethod, that.downsamplingMethod) && this.enabled == that.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.lifecycleType, this.enabled, this.dataRetention, this.downsamplingRounds, this.downsamplingMethod);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            if (out.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE)) {
                out.writeOptionalTimeValue(this.dataRetention);
            } else {
                DataStreamLifecycle.writeLegacyOptionalValue(this.dataRetention, out, StreamOutput::writeTimeValue);
            }
        }
        if (out.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            if (out.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE)) {
                out.writeOptionalCollection(this.downsamplingRounds);
            } else {
                DataStreamLifecycle.writeLegacyOptionalValue(this.downsamplingRounds, out, StreamOutput::writeCollection);
            }
            out.writeBoolean(this.enabled());
        }
        if (out.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE)) {
            this.lifecycleType.writeTo(out);
        }
        if (out.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM)) {
            out.writeOptionalWriteable(this.downsamplingMethod);
        }
    }

    public DataStreamLifecycle(StreamInput in) throws IOException {
        this.dataRetention = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? (in.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE) ? in.readOptionalTimeValue() : DataStreamLifecycle.readLegacyOptionalValue(in, StreamInput::readTimeValue)) : null;
        if (in.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
            this.downsamplingRounds = in.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE) ? in.readOptionalCollectionAsList(DownsamplingRound::read) : DataStreamLifecycle.readLegacyOptionalValue(in, is -> is.readCollectionAsList(DownsamplingRound::read));
            this.enabled = in.readBoolean();
        } else {
            this.downsamplingRounds = null;
            this.enabled = true;
        }
        this.lifecycleType = in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? LifecycleType.read(in) : LifecycleType.DATA;
        this.downsamplingMethod = in.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM) ? in.readOptionalWriteable(DownsampleConfig.SamplingMethod::read) : null;
    }

    private static <T> void writeLegacyOptionalValue(T value, StreamOutput out, Writeable.Writer<T> writer) throws IOException {
        boolean isDefined = value != null;
        out.writeBoolean(isDefined);
        if (isDefined) {
            out.writeBoolean(true);
            writer.write(out, value);
        }
    }

    private static <T> T readLegacyOptionalValue(StreamInput in, Writeable.Reader<T> reader) throws IOException {
        boolean isNotNull;
        T value = null;
        boolean isDefined = in.readBoolean();
        if (isDefined && (isNotNull = in.readBoolean())) {
            value = reader.read(in);
        }
        return value;
    }

    public static Diff<DataStreamLifecycle> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamLifecycle::new, in);
    }

    public String toString() {
        return "DataStreamLifecycle{lifecycleTarget=" + String.valueOf(this.lifecycleType) + ", enabled=" + this.enabled + ", dataRetention=" + String.valueOf(this.dataRetention) + ", downsamplingRounds=" + String.valueOf(this.downsamplingRounds) + ", downsamplingMethod=" + String.valueOf(this.downsamplingMethod) + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.dataRetention != null) {
            builder.field(DATA_RETENTION_FIELD.getPreferredName(), this.dataRetention.getStringRep());
        }
        Tuple<TimeValue, RetentionSource> effectiveDataRetentionWithSource = this.getEffectiveDataRetentionWithSource(globalRetention, isInternalDataStream);
        if (params.paramAsBoolean(INCLUDE_EFFECTIVE_RETENTION_PARAM_NAME, false) && effectiveDataRetentionWithSource.v1() != null) {
            builder.field(EFFECTIVE_RETENTION_FIELD.getPreferredName(), ((TimeValue)effectiveDataRetentionWithSource.v1()).getStringRep());
            builder.field(RETENTION_SOURCE_FIELD.getPreferredName(), ((RetentionSource)((Object)effectiveDataRetentionWithSource.v2())).displayName());
        }
        if (this.downsamplingRounds != null) {
            builder.field(DOWNSAMPLING_FIELD.getPreferredName(), this.downsamplingRounds);
        }
        if (this.downsamplingMethod != null) {
            builder.field(DOWNSAMPLING_METHOD_FIELD.getPreferredName(), this.downsamplingMethod.toString());
        }
        if (rolloverConfiguration != null) {
            builder.field(ROLLOVER_FIELD.getPreferredName());
            rolloverConfiguration.evaluateAndConvertToXContent(builder, params, (TimeValue)effectiveDataRetentionWithSource.v1());
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamLifecycle dataLifecycleFromXContent(XContentParser parser) throws IOException {
        return (DataStreamLifecycle)PARSER.parse(parser, (Object)LifecycleType.DATA);
    }

    public static DataStreamLifecycle failureLifecycleFromXContent(XContentParser parser) throws IOException {
        return (DataStreamLifecycle)PARSER.parse(parser, (Object)LifecycleType.FAILURES);
    }

    public static ToXContent.Params addEffectiveRetentionParams(ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(INCLUDE_EFFECTIVE_RETENTION_PARAMS, params);
    }

    public static Template createDataLifecycleTemplate(boolean enabled, TimeValue dataRetention, List<DownsamplingRound> downsamplingRounds, DownsampleConfig.SamplingMethod downsamplingMethod) {
        return new Template(LifecycleType.DATA, enabled, ResettableValue.create(dataRetention), ResettableValue.create(downsamplingRounds), ResettableValue.create(downsamplingMethod));
    }

    public static Template createDataLifecycleTemplate(boolean enabled, ResettableValue<TimeValue> dataRetention, ResettableValue<List<DownsamplingRound>> downsamplingRounds, ResettableValue<DownsampleConfig.SamplingMethod> downsamplingMethod) {
        return new Template(LifecycleType.DATA, enabled, dataRetention, downsamplingRounds, downsamplingMethod);
    }

    public static Template createFailuresLifecycleTemplate(boolean enabled, TimeValue dataRetention) {
        return new Template(LifecycleType.FAILURES, enabled, ResettableValue.create(dataRetention), ResettableValue.undefined(), ResettableValue.undefined());
    }

    public static Builder builder(DataStreamLifecycle lifecycle) {
        return new Builder(lifecycle);
    }

    public static Builder builder(Template template) {
        return new Builder(template);
    }

    public static Builder dataLifecycleBuilder() {
        return new Builder(LifecycleType.DATA);
    }

    public static Builder failuresLifecycleBuilder() {
        return new Builder(LifecycleType.FAILURES);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            String value = p.textOrNull();
            if (value == null) {
                return null;
            }
            return TimeValue.parseTimeValue((String)value, (String)DATA_RETENTION_FIELD.getPreferredName());
        }, DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return AbstractObjectParser.parseArray((XContentParser)p, null, DownsamplingRound::fromXContent);
        }, DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DownsampleConfig.SamplingMethod.fromString(p.text()), DOWNSAMPLING_METHOD_FIELD, ObjectParser.ValueType.STRING);
        INTRODUCE_FAILURES_LIFECYCLE = TransportVersion.fromName("introduce_failures_lifecycle");
    }

    static enum LifecycleType implements Writeable
    {
        DATA("data", 0),
        FAILURES("failures", 1);

        private final String label;
        private final byte id;
        private static final Map<Byte, LifecycleType> REGISTRY;

        private LifecycleType(String label, byte id) {
            this.label = label;
            this.id = id;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.write(this.id);
        }

        public static LifecycleType read(StreamInput in) throws IOException {
            return REGISTRY.get(in.readByte());
        }

        static {
            REGISTRY = Arrays.stream(LifecycleType.values()).collect(Collectors.toMap(l -> l.id, Function.identity()));
        }
    }

    public record DownsamplingRound(TimeValue after, DateHistogramInterval fixedInterval) implements Writeable,
    ToXContentObject
    {
        public static final ParseField AFTER_FIELD = new ParseField("after", new String[0]);
        public static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
        public static final long FIVE_MINUTES_MILLIS = TimeValue.timeValueMinutes((long)5L).getMillis();
        private static final ConstructingObjectParser<DownsamplingRound, Void> PARSER = new ConstructingObjectParser("downsampling_round", false, (args, unused) -> new DownsamplingRound((TimeValue)args[0], (DateHistogramInterval)args[1]));

        public DownsamplingRound {
            if (fixedInterval.estimateMillis() < FIVE_MINUTES_MILLIS) {
                throw new IllegalArgumentException("A downsampling round must have a fixed interval of at least five minutes but found: " + String.valueOf(fixedInterval));
            }
        }

        static void validateRounds(List<DownsamplingRound> rounds) {
            if (rounds == null) {
                return;
            }
            if (rounds.isEmpty()) {
                throw new IllegalArgumentException("Downsampling configuration should have at least one round configured.");
            }
            if (rounds.size() > 10) {
                throw new IllegalArgumentException("Downsampling configuration supports maximum 10 configured rounds. Found: " + rounds.size());
            }
            DownsamplingRound previous = null;
            for (DownsamplingRound round : rounds) {
                if (previous == null) {
                    previous = round;
                    continue;
                }
                if (round.after.compareTo(previous.after) < 0) {
                    throw new IllegalArgumentException("A downsampling round must have a later 'after' value than the proceeding, " + round.after.getStringRep() + " is not after " + previous.after.getStringRep() + ".");
                }
                DownsampleConfig.validateSourceAndTargetIntervals(previous.fixedInterval(), round.fixedInterval());
            }
        }

        public static DownsamplingRound read(StreamInput in) throws IOException {
            TimeValue after = in.readTimeValue();
            DateHistogramInterval fixedInterval = in.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM) ? new DateHistogramInterval(in) : new DownsampleConfig(in).getFixedInterval();
            return new DownsamplingRound(after, fixedInterval);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeTimeValue(this.after);
            if (out.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM)) {
                out.writeWriteable(this.fixedInterval);
            } else {
                out.writeWriteable(new DownsampleConfig(this.fixedInterval, null));
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(AFTER_FIELD.getPreferredName(), this.after.getStringRep());
            builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.fixedInterval().toString());
            builder.endObject();
            return builder;
        }

        public static DownsamplingRound fromXContent(XContentParser parser, Void context) throws IOException {
            return (DownsamplingRound)PARSER.parse(parser, (Object)context);
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this, true, true);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), value -> TimeValue.parseTimeValue((String)value, (String)AFTER_FIELD.getPreferredName()), AFTER_FIELD);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
        }
    }

    public static enum RetentionSource {
        DATA_STREAM_CONFIGURATION,
        DEFAULT_GLOBAL_RETENTION,
        MAX_GLOBAL_RETENTION,
        DEFAULT_FAILURES_RETENTION;


        public String displayName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record Template(LifecycleType lifecycleType, boolean enabled, ResettableValue<TimeValue> dataRetention, ResettableValue<List<DownsamplingRound>> downsamplingRounds, ResettableValue<DownsampleConfig.SamplingMethod> downsamplingMethod) implements ToXContentObject,
    Writeable
    {
        public static final Template DATA_DEFAULT = new Template(LifecycleType.DATA, true, ResettableValue.undefined(), ResettableValue.undefined(), ResettableValue.undefined());
        public static final ConstructingObjectParser<Template, LifecycleType> PARSER = new ConstructingObjectParser("lifecycle_template", false, (args, lt) -> new Template((LifecycleType)lt, args[0] == null || (Boolean)args[0] != false, args[1] == null ? ResettableValue.undefined() : (ResettableValue)args[1], args[2] == null ? ResettableValue.undefined() : (ResettableValue)args[2], args[3] == null ? ResettableValue.undefined() : (ResettableValue)args[3]));

        Template(LifecycleType lifecycleType, boolean enabled, TimeValue dataRetention, List<DownsamplingRound> downsamplingRounds, DownsampleConfig.SamplingMethod downsamplingMethod) {
            this(lifecycleType, enabled, ResettableValue.create(dataRetention), ResettableValue.create(downsamplingRounds), ResettableValue.create(downsamplingMethod));
        }

        public Template {
            if (lifecycleType == LifecycleType.FAILURES && downsamplingRounds.get() != null) {
                throw new IllegalArgumentException(DataStreamLifecycle.DOWNSAMPLING_NOT_SUPPORTED_ERROR_MESSAGE);
            }
            if (downsamplingRounds.isDefined() && downsamplingRounds.get() != null) {
                DownsamplingRound.validateRounds(downsamplingRounds.get());
            } else if (downsamplingMethod.isDefined() && downsamplingMethod.get() != null) {
                throw new IllegalArgumentException(DataStreamLifecycle.DOWNSAMPLING_METHOD_WITHOUT_ROUNDS_ERROR);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                if (out.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE)) {
                    ResettableValue.write(out, this.dataRetention, StreamOutput::writeTimeValue);
                } else {
                    Template.writeLegacyValue(out, this.dataRetention, StreamOutput::writeTimeValue);
                }
            }
            if (out.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
                if (out.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE)) {
                    ResettableValue.write(out, this.downsamplingRounds, StreamOutput::writeCollection);
                } else {
                    Template.writeLegacyValue(out, this.downsamplingRounds, StreamOutput::writeCollection);
                }
                out.writeBoolean(this.enabled);
            }
            if (out.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE)) {
                this.lifecycleType.writeTo(out);
            }
            if (out.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM)) {
                ResettableValue.write(out, this.downsamplingMethod, StreamOutput::writeWriteable);
            }
        }

        private static <T> void writeLegacyValue(StreamOutput out, ResettableValue<T> value, Writeable.Writer<T> writer) throws IOException {
            out.writeBoolean(value.isDefined());
            if (value.isDefined()) {
                out.writeBoolean(!value.shouldReset());
                if (!value.shouldReset()) {
                    writer.write(out, value.get());
                }
            }
        }

        static <T> ResettableValue<T> readLegacyValues(StreamInput in, Writeable.Reader<T> reader) throws IOException {
            boolean isDefined = in.readBoolean();
            if (!isDefined) {
                return ResettableValue.undefined();
            }
            boolean hasNonNullValue = in.readBoolean();
            if (!hasNonNullValue) {
                return ResettableValue.reset();
            }
            T value = reader.read(in);
            return ResettableValue.create(value);
        }

        public static Template read(StreamInput in) throws IOException {
            boolean enabled = true;
            ResettableValue<TimeValue> dataRetention = ResettableValue.undefined();
            ResettableValue<List<DownsamplingRound>> downsamplingRounds = ResettableValue.undefined();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                dataRetention = in.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE) ? ResettableValue.read(in, StreamInput::readTimeValue) : Template.readLegacyValues(in, StreamInput::readTimeValue);
            }
            if (in.getTransportVersion().onOrAfter(ADDED_ENABLED_FLAG_VERSION)) {
                downsamplingRounds = in.getTransportVersion().supports(INTRODUCE_LIFECYCLE_TEMPLATE) ? ResettableValue.read(in, i -> i.readCollectionAsList(DownsamplingRound::read)) : Template.readLegacyValues(in, i -> i.readCollectionAsList(DownsamplingRound::read));
                enabled = in.readBoolean();
            }
            LifecycleType lifecycleTarget = in.getTransportVersion().supports(INTRODUCE_FAILURES_LIFECYCLE) ? LifecycleType.read(in) : LifecycleType.DATA;
            ResettableValue<DownsampleConfig.SamplingMethod> downsamplingMethod = in.getTransportVersion().supports(ADD_SAMPLE_METHOD_DOWNSAMPLE_DLM) ? ResettableValue.read(in, DownsampleConfig.SamplingMethod::read) : ResettableValue.undefined();
            return new Template(lifecycleTarget, enabled, dataRetention, downsamplingRounds, downsamplingMethod);
        }

        public static Template dataLifecycleTemplatefromXContent(XContentParser parser) throws IOException {
            return (Template)PARSER.parse(parser, (Object)LifecycleType.DATA);
        }

        public static Template failuresLifecycleTemplatefromXContent(XContentParser parser) throws IOException {
            return (Template)PARSER.parse(parser, (Object)LifecycleType.FAILURES);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.toXContent(builder, params, null, null, false);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention, boolean isInternalDataStream) throws IOException {
            builder.startObject();
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
            this.dataRetention.toXContent(builder, params, DATA_RETENTION_FIELD.getPreferredName(), TimeValue::getStringRep);
            this.downsamplingRounds.toXContent(builder, params, DOWNSAMPLING_FIELD.getPreferredName());
            this.downsamplingMethod.toXContent(builder, params, DOWNSAMPLING_METHOD_FIELD.getPreferredName(), DownsampleConfig.SamplingMethod::toString);
            if (rolloverConfiguration != null) {
                builder.field(ROLLOVER_FIELD.getPreferredName());
                rolloverConfiguration.evaluateAndConvertToXContent(builder, params, this.toDataStreamLifecycle().getEffectiveDataRetention(globalRetention, isInternalDataStream));
            }
            builder.endObject();
            return builder;
        }

        public DataStreamLifecycle toDataStreamLifecycle() {
            return new DataStreamLifecycle(this.lifecycleType, this.enabled, this.dataRetention.get(), this.downsamplingRounds.get(), this.downsamplingMethod.get());
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                String value = p.textOrNull();
                return value == null ? ResettableValue.reset() : ResettableValue.create(TimeValue.parseTimeValue((String)value, (String)DATA_RETENTION_FIELD.getPreferredName()));
            }, DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return ResettableValue.reset();
                }
                return ResettableValue.create(AbstractObjectParser.parseArray((XContentParser)p, null, DownsamplingRound::fromXContent));
            }, DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                String value = p.textOrNull();
                return value == null ? ResettableValue.reset() : ResettableValue.create(DownsampleConfig.SamplingMethod.fromString(value));
            }, DOWNSAMPLING_METHOD_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        }
    }

    public static class Builder {
        private final LifecycleType lifecycleType;
        private boolean enabled = true;
        @Nullable
        private TimeValue dataRetention = null;
        @Nullable
        private List<DownsamplingRound> downsamplingRounds = null;
        @Nullable
        private DownsampleConfig.SamplingMethod downsamplingMethod = null;

        private Builder(LifecycleType lifecycleType) {
            this.lifecycleType = lifecycleType;
        }

        private Builder(Template template) {
            this.lifecycleType = template.lifecycleType();
            this.enabled = template.enabled();
            this.dataRetention = template.dataRetention().get();
            this.downsamplingRounds = template.downsamplingRounds().get();
            this.downsamplingMethod = template.downsamplingMethod().get();
        }

        private Builder(DataStreamLifecycle lifecycle) {
            this.lifecycleType = lifecycle.lifecycleType;
            this.enabled = lifecycle.enabled();
            this.dataRetention = lifecycle.dataRetention();
            this.downsamplingRounds = lifecycle.downsamplingRounds();
            this.downsamplingMethod = lifecycle.downsamplingMethod();
        }

        public Builder composeTemplate(Template template) {
            assert (this.lifecycleType == template.lifecycleType()) : "Trying to compose templates with different lifecycle types";
            this.enabled(template.enabled());
            this.dataRetention(template.dataRetention());
            this.downsamplingRounds(template.downsamplingRounds());
            this.downsamplingMethod(template.downsamplingMethod());
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder dataRetention(ResettableValue<TimeValue> dataRetention) {
            if (dataRetention.isDefined()) {
                this.dataRetention = dataRetention.get();
            }
            return this;
        }

        public Builder dataRetention(@Nullable TimeValue dataRetention) {
            this.dataRetention = dataRetention;
            return this;
        }

        public Builder downsamplingRounds(ResettableValue<List<DownsamplingRound>> downsampling) {
            if (downsampling.isDefined()) {
                this.downsamplingRounds = downsampling.get();
            }
            return this;
        }

        public Builder downsamplingRounds(@Nullable List<DownsamplingRound> downsampling) {
            this.downsamplingRounds = downsampling;
            return this;
        }

        public Builder downsamplingMethod(ResettableValue<DownsampleConfig.SamplingMethod> downsamplingMethod) {
            if (downsamplingMethod.isDefined()) {
                this.downsamplingMethod = downsamplingMethod.get();
            }
            return this;
        }

        public Builder downsamplingMethod(@Nullable DownsampleConfig.SamplingMethod downsamplingMethod) {
            this.downsamplingMethod = downsamplingMethod;
            return this;
        }

        public DataStreamLifecycle build() {
            return new DataStreamLifecycle(this.lifecycleType, this.enabled, this.dataRetention, this.downsamplingRounds, this.downsamplingMethod);
        }

        public Template buildTemplate() {
            return new Template(this.lifecycleType, this.enabled, this.dataRetention, this.downsamplingRounds, this.downsamplingMethod);
        }
    }
}

