/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record ClusterSnapshotStats(int snapshotsInProgressCount, int incompleteShardSnapshotCount, int deletionsInProgressCount, int cleanupsInProgressCount, List<PerRepositoryStats> statsByRepository) implements ToXContentObject,
Writeable
{
    public static final ClusterSnapshotStats EMPTY = new ClusterSnapshotStats(0, 0, 0, 0, List.of());

    public static ClusterSnapshotStats of(ClusterState clusterState, long currentTimeMillis) {
        return ClusterSnapshotStats.of(RepositoriesMetadata.get(clusterState), SnapshotsInProgress.get(clusterState), SnapshotDeletionsInProgress.get(clusterState), RepositoryCleanupInProgress.get(clusterState), currentTimeMillis);
    }

    private static ClusterSnapshotStats of(RepositoriesMetadata repositoriesMetadata, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress snapshotDeletionsInProgress, RepositoryCleanupInProgress repositoryCleanupInProgress, long currentTimeMillis) {
        int snapshotsInProgressCount = snapshotsInProgress.count();
        int incompleteShardSnapshotCount = 0;
        int deletionsInProgressCount = snapshotDeletionsInProgress.getEntries().size();
        int cleanupsInProgressCount = repositoryCleanupInProgress.entries().size();
        ArrayList<PerRepositoryStats> perRepositoryStats = new ArrayList<PerRepositoryStats>(repositoriesMetadata.repositories().size());
        for (RepositoryMetadata repository : repositoriesMetadata.repositories()) {
            String repositoryName = repository.name();
            String repositoryType = repository.type();
            int snapshotCount = 0;
            int cloneCount = 0;
            int finalizationsCount = 0;
            int totalShards = 0;
            int completeShards = 0;
            EnumMap shardStatesAccumulator = Arrays.stream(SnapshotsInProgress.ShardState.values()).collect(Collectors.toMap(Function.identity(), ignored -> new AtomicInteger(), (s1, s2) -> {
                assert (false);
                return s1;
            }, () -> new EnumMap(SnapshotsInProgress.ShardState.class)));
            int deletionsCount = 0;
            int snapshotDeletionsCount = 0;
            int activeDeletionsCount = 0;
            long firstStartTimeMillis = currentTimeMillis;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(repositoryName)) {
                firstStartTimeMillis = Math.min(firstStartTimeMillis, entry.startTime());
                if (entry.state().completed()) {
                    ++finalizationsCount;
                }
                if (entry.isClone()) {
                    ++cloneCount;
                    continue;
                }
                ++snapshotCount;
                totalShards += entry.shards().size();
                for (SnapshotsInProgress.ShardSnapshotStatus value : entry.shards().values()) {
                    if (value.state().completed()) {
                        ++completeShards;
                    }
                    ((AtomicInteger)shardStatesAccumulator.get((Object)value.state())).incrementAndGet();
                }
            }
            for (SnapshotDeletionsInProgress.Entry entry : snapshotDeletionsInProgress.getEntries()) {
                if (!entry.repository().equals(repositoryName)) continue;
                firstStartTimeMillis = Math.min(firstStartTimeMillis, entry.startTime());
                ++deletionsCount;
                snapshotDeletionsCount += entry.snapshots().size();
                if (entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                ++activeDeletionsCount;
            }
            perRepositoryStats.add(new PerRepositoryStats(repositoryName, repositoryType, snapshotCount, cloneCount, finalizationsCount, totalShards, completeShards, deletionsCount, snapshotDeletionsCount, activeDeletionsCount, firstStartTimeMillis, new EnumMap<SnapshotsInProgress.ShardState, Integer>(shardStatesAccumulator.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicInteger)e.getValue()).get())))));
            incompleteShardSnapshotCount += totalShards - completeShards;
        }
        return new ClusterSnapshotStats(snapshotsInProgressCount, incompleteShardSnapshotCount, deletionsInProgressCount, cleanupsInProgressCount, List.copyOf(perRepositoryStats));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("current_counts");
        builder.field("snapshots", this.snapshotsInProgressCount);
        builder.field("shard_snapshots", this.incompleteShardSnapshotCount);
        builder.field("snapshot_deletions", this.deletionsInProgressCount);
        builder.field("concurrent_operations", this.snapshotsInProgressCount + this.deletionsInProgressCount);
        builder.field("cleanups", this.cleanupsInProgressCount);
        builder.endObject();
        builder.startObject("repositories");
        for (PerRepositoryStats perRepositoryStats : this.statsByRepository) {
            perRepositoryStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.snapshotsInProgressCount);
        out.writeVInt(this.incompleteShardSnapshotCount);
        out.writeVInt(this.deletionsInProgressCount);
        out.writeVInt(this.cleanupsInProgressCount);
        out.writeCollection(this.statsByRepository);
    }

    public static ClusterSnapshotStats readFrom(StreamInput in) throws IOException {
        return new ClusterSnapshotStats(in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readCollectionAsList(PerRepositoryStats::readFrom));
    }

    record PerRepositoryStats(String repositoryName, String repositoryType, int snapshotCount, int cloneCount, int finalizationsCount, int totalShards, int completeShards, int deletionsCount, int snapshotDeletionsCount, int activeDeletionsCount, long firstStartTimeMillis, EnumMap<SnapshotsInProgress.ShardState, Integer> shardStates) implements ToXContentFragment,
    Writeable
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.repositoryName);
            builder.field("type", this.repositoryType);
            builder.startObject("current_counts");
            builder.field("snapshots", this.snapshotCount);
            builder.field("clones", this.cloneCount);
            builder.field("finalizations", this.finalizationsCount);
            builder.field("deletions", this.deletionsCount);
            builder.field("snapshot_deletions", this.snapshotDeletionsCount);
            builder.field("active_deletions", this.activeDeletionsCount);
            builder.startObject("shards");
            builder.field("total", this.totalShards);
            builder.field("complete", this.completeShards);
            builder.field("incomplete", this.totalShards - this.completeShards);
            builder.startObject("states");
            for (Map.Entry<SnapshotsInProgress.ShardState, Integer> entry : this.shardStates.entrySet()) {
                builder.field(entry.getKey().toString(), entry.getValue());
            }
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.timestampFieldsFromUnixEpochMillis("oldest_start_time_millis", "oldest_start_time", this.firstStartTimeMillis);
            return builder.endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.repositoryName);
            out.writeString(this.repositoryType);
            out.writeVInt(this.snapshotCount);
            out.writeVInt(this.cloneCount);
            out.writeVInt(this.finalizationsCount);
            out.writeVInt(this.totalShards);
            out.writeVInt(this.completeShards);
            out.writeVInt(this.deletionsCount);
            out.writeVInt(this.snapshotDeletionsCount);
            out.writeVInt(this.activeDeletionsCount);
            out.writeVLong(this.firstStartTimeMillis);
            out.writeMap(this.shardStates, (o, state) -> o.writeString(state.toString()), StreamOutput::writeVInt);
        }

        static PerRepositoryStats readFrom(StreamInput in) throws IOException {
            return new PerRepositoryStats(in.readString(), in.readString(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVLong(), new EnumMap<SnapshotsInProgress.ShardState, Integer>(in.readMap(i -> SnapshotsInProgress.ShardState.valueOf(in.readString()), StreamInput::readVInt)));
        }
    }
}

