/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.action.termvectors.EnsureDocsSearchableAction;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsShardResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiTermsVectorAction
extends TransportSingleShardAction<MultiTermVectorsShardRequest, MultiTermVectorsShardResponse> {
    private final NodeClient client;
    private final IndicesService indicesService;
    private final boolean stateless;
    private static final String ACTION_NAME = "indices:data/read/mtv[shard]";
    public static final ActionType<MultiTermVectorsShardResponse> TYPE = new ActionType("indices:data/read/mtv[shard]");

    @Inject
    public TransportShardMultiTermsVectorAction(ClusterService clusterService, NodeClient client, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, projectResolver, indexNameExpressionResolver, MultiTermVectorsShardRequest::new, threadPool.executor("get"));
        this.client = client;
        this.indicesService = indicesService;
        this.stateless = DiscoveryNode.isStateless(clusterService.getSettings());
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiTermVectorsShardResponse> getResponseReader() {
        return MultiTermVectorsShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiTermVectorsShardRequest request) {
        return false;
    }

    @Override
    protected ShardIterator shards(ProjectState project, TransportSingleShardAction.InternalRequest request) {
        ShardIterator iterator = this.clusterService.operationRouting().getShards(project, request.concreteIndex(), ((MultiTermVectorsShardRequest)request.request()).shardId(), ((MultiTermVectorsShardRequest)request.request()).preference());
        if (iterator == null) {
            return new ShardIterator(null, List.of());
        }
        return ShardIterator.allSearchableShards(iterator);
    }

    @Override
    protected void asyncShardOperation(MultiTermVectorsShardRequest request, ShardId shardId, ActionListener<MultiTermVectorsShardResponse> listener) throws IOException {
        if (this.stateless) {
            String[] realTimeIds = (String[])request.requests.stream().filter(r -> r.realtime()).map(TermVectorsRequest::id).toArray(String[]::new);
            if (realTimeIds.length > 0) {
                EnsureDocsSearchableAction.EnsureDocsSearchableRequest ensureDocsSearchableRequest = new EnsureDocsSearchableAction.EnsureDocsSearchableRequest(request.index(), shardId.id(), realTimeIds);
                ensureDocsSearchableRequest.setParentTask(this.clusterService.localNode().getId(), request.getParentTask().getId());
                this.client.executeLocally(EnsureDocsSearchableAction.TYPE, ensureDocsSearchableRequest, listener.delegateFailureAndWrap((l, r) -> super.asyncShardOperation(request, shardId, l)));
            } else {
                super.asyncShardOperation(request, shardId, listener);
            }
        } else {
            super.asyncShardOperation(request, shardId, listener);
        }
    }

    @Override
    protected MultiTermVectorsShardResponse shardOperation(MultiTermVectorsShardRequest request, ShardId shardId) {
        MultiTermVectorsShardResponse response = new MultiTermVectorsShardResponse();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        for (int i = 0; i < request.locations.size(); ++i) {
            TermVectorsRequest termVectorsRequest = request.requests.get(i);
            try {
                TermVectorsResponse termVectorsResponse = TermVectorsService.getTermVectors(indexShard, termVectorsRequest);
                response.add((int)request.locations.get(i), termVectorsResponse);
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                this.logger.debug(() -> Strings.format((String)"%s failed to execute multi term vectors for [%s]", (Object[])new Object[]{shardId, termVectorsRequest.id()}), (Throwable)e);
                response.add((int)request.locations.get(i), new MultiTermVectorsResponse.Failure(request.index(), termVectorsRequest.id(), e));
            }
        }
        return response;
    }
}

