/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public abstract class TransportBroadcastAction<Request extends BroadcastRequest<Request>, Response extends BaseBroadcastResponse, ShardRequest extends BroadcastShardRequest, ShardResponse extends BroadcastShardResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String transportShardAction;
    private final Executor executor;

    protected TransportBroadcastAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> requestReader, Writeable.Reader<ShardRequest> shardRequestReader, Executor executor) {
        super(actionName, transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = actionName + "[s]";
        this.executor = executor;
        assert (this.executor != EsExecutors.DIRECT_EXECUTOR_SERVICE) : "O(#shards) work must always fork to an appropriate executor";
        transportService.registerRequestHandler(this.transportShardAction, this.executor, shardRequestReader, (request, channel, task) -> ActionListener.completeWith(new ChannelActionListener(channel), () -> this.shardOperation(request, task)));
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        this.executor.execute(ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, listener)));
    }

    protected void doExecuteForked(Task task, Request request, ActionListener<Response> listener) {
        assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
        new AsyncBroadcastAction(this, task, request, listener).start();
    }

    protected abstract Response newResponse(Request var1, AtomicReferenceArray<?> var2, ClusterState var3);

    protected abstract ShardRequest newShardRequest(int var1, ShardRouting var2, Request var3);

    protected abstract ShardResponse readShardResponse(StreamInput var1) throws IOException;

    protected abstract ShardResponse shardOperation(ShardRequest var1, Task var2) throws IOException;

    protected abstract List<? extends ShardIterator> shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    protected static class AsyncBroadcastAction {
        final Task task;
        final Request request;
        final ActionListener<Response> listener;
        final ClusterState clusterState;
        final DiscoveryNodes nodes;
        final List<? extends ShardIterator> shardsIts;
        final int expectedOps;
        final AtomicInteger counterOps = new AtomicInteger();
        protected final AtomicReferenceArray<Object> shardsResponses;
        final /* synthetic */ TransportBroadcastAction this$0;

        protected AsyncBroadcastAction(Task task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.clusterState = this$0.clusterService.state();
            ClusterBlockException blockException = this$0.checkGlobalBlock(this.clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            String[] concreteIndices = this$0.indexNameExpressionResolver.concreteIndexNames(this.clusterState, (IndicesRequest)request);
            blockException = this$0.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = this.clusterState.nodes();
            ((TransportBroadcastAction)this$0).logger.trace("resolving shards based on cluster state version [{}]", (Object)this.clusterState.version());
            this.shardsIts = this$0.shards(this.clusterState, request, concreteIndices);
            this.expectedOps = this.shardsIts.size();
            this.shardsResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.shardsIts.size() == 0) {
                ActionListener.completeWith(this.listener, () -> this.this$0.newResponse(this.request, new AtomicReferenceArray(0), this.clusterState));
                return;
            }
            int shardIndex = -1;
            for (ShardIterator shardIterator : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = (ShardRouting)shardIterator.nextOrNull();
                if (shard != null) {
                    this.performOperation(shardIterator, shard, shardIndex);
                    continue;
                }
                this.onOperation(null, shardIterator, shardIndex, new NoShardAvailableActionException(shardIterator.shardId()));
            }
        }

        protected void performOperation(ShardIterator shardIt, ShardRouting shard, int shardIndex) {
            if (shard == null) {
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                try {
                    Object shardRequest = this.this$0.newShardRequest(shardIt.size(), shard, this.request);
                    shardRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                    if (node == null) {
                        this.onOperation(shard, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
                    } else {
                        this.sendShardRequest(node, shardRequest, ActionListener.wrap(r -> this.onOperation(shard, shardIndex, r), e -> this.onOperation(shard, shardIt, shardIndex, (Exception)e)));
                    }
                }
                catch (Exception e2) {
                    this.onOperation(shard, shardIt, shardIndex, e2);
                }
            }
        }

        protected void sendShardRequest(DiscoveryNode node, ShardRequest shardRequest, ActionListener<ShardResponse> listener) {
            this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)shardRequest, new ActionListenerResponseHandler<BroadcastShardResponse>(listener, this.this$0::readShardResponse, this.this$0.executor));
        }

        protected void onOperation(ShardRouting shard, int shardIndex, ShardResponse response) {
            this.this$0.logger.trace("received response for {}", (Object)shard);
            this.shardsResponses.set(shardIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim();
            }
        }

        void onOperation(@Nullable ShardRouting shard, ShardIterator shardIt, int shardIndex, Exception e) {
            this.setFailure(shardIt, shardIndex, e);
            ShardRouting nextShard = (ShardRouting)shardIt.nextOrNull();
            if (nextShard != null) {
                if (e != null && this.this$0.logger.isTraceEnabled() && !TransportActions.isShardNotAvailableException(e)) {
                    this.this$0.logger.trace(() -> Strings.format((String)"%s: failed to execute [%s]", (Object[])new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request}), (Throwable)e);
                }
                this.performOperation(shardIt, nextShard, shardIndex);
            } else {
                if (this.this$0.logger.isDebugEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.this$0.logger.debug(() -> Strings.format((String)"%s: failed to execute [%s]", (Object[])new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request}), (Throwable)e);
                }
                if (this.expectedOps == this.counterOps.incrementAndGet()) {
                    this.finishHim();
                }
            }
        }

        protected void finishHim() {
            assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
            ActionListener.completeWith(this.listener, () -> this.this$0.newResponse(this.request, this.shardsResponses, this.clusterState));
        }

        void setFailure(ShardIterator shardIt, int shardIndex, Exception e) {
            Object response;
            if (!(e instanceof BroadcastShardOperationFailedException)) {
                e = new BroadcastShardOperationFailedException(shardIt.shardId(), (Throwable)e);
            }
            if ((response = this.shardsResponses.get(shardIndex)) == null) {
                this.shardsResponses.set(shardIndex, e);
            }
            if (!(response instanceof Throwable)) {
                return;
            }
            if (TransportActions.isReadOverrideException(e)) {
                this.shardsResponses.set(shardIndex, e);
            }
        }
    }
}

