/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class GetIndexTemplatesRequest
extends LocalClusterStateRequest {
    private final String[] names;

    public GetIndexTemplatesRequest(TimeValue masterTimeout, String ... names) {
        super(masterTimeout);
        this.names = names;
    }

    public GetIndexTemplatesRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError("names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText(name)) continue;
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
        }
        return validationException;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }

    public String[] names() {
        return this.names;
    }
}

